/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.util;

import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.wss.logging.LogStringsMessages;
import com.sun.xml.wss.util.WSSServletContextFacade;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServletContextUtil {
    private static final String CLASS_NAME = "jakarta.servlet.ServletContext";
    private static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    private ServletContextUtil() {
    }

    public static WSSServletContextFacade wrap(Object context) {
        if (context == null) {
            return null;
        }
        Class<?> servletContextClass = ServletContextUtil.findServletContextClass();
        if (servletContextClass == null) {
            return null;
        }
        if (servletContextClass.isInstance(servletContextClass)) {
            return new WSSServletContextFacade(context);
        }
        return null;
    }

    public static WSSServletContextFacade getServletContextFacade(WSEndpoint<?> endpoint) {
        Container container = endpoint.getContainer();
        if (container == null) {
            return null;
        }
        Class<?> contextClass = ServletContextUtil.findServletContextClass();
        if (contextClass == null) {
            log.log(Level.WARNING, LogStringsMessages.WSS_1542_SERVLET_CONTEXT_NOTFOUND());
            return null;
        }
        return ServletContextUtil.wrap(container.getSPI(contextClass));
    }

    private static Class<?> findServletContextClass() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                return loader.loadClass(CLASS_NAME);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return ServletContextUtil.class.getClassLoader().loadClass(CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

