/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.jdeparser.Assertions;
import org.jboss.jdeparser.BasicJBlock;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ImplJTry;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JCatch;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JMod;
import org.jboss.jdeparser.JTry;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class ImplJCatch
extends BasicJBlock
implements JCatch {
    private final ImplJTry _try;
    private final int mods;
    private final String var;
    private final ArrayList<JType> types = new ArrayList(1);

    ImplJCatch(ImplJTry _try, int mods, JType type, String var) {
        super(_try.getParent(), JBlock.Braces.REQUIRED);
        this.mods = mods;
        this.var = var;
        this.types.add(type);
        this._try = _try;
    }

    @Override
    public JCatch or(JType orType) {
        this.types.add(orType);
        return this;
    }

    @Override
    public JCatch or(String orType) {
        return this.or(JTypes.typeNamed(orType));
    }

    @Override
    public JCatch or(Class<? extends Throwable> orType) {
        return this.or(JTypes.typeOf(orType));
    }

    @Override
    public JVarDeclaration with(int mods, String type, String var, JExpr init) {
        return this._try.with(mods, type, var, init);
    }

    @Override
    public JVarDeclaration with(int mods, JType type, String var, JExpr init) {
        return this._try.with(mods, type, var, init);
    }

    @Override
    public JVarDeclaration with(int mods, Class<? extends AutoCloseable> type, String var, JExpr init) {
        return this._try.with(mods, type, var, init);
    }

    @Override
    public JCatch _catch(int mods, String type, String var) {
        return this._try._catch(mods, type, var);
    }

    @Override
    public JCatch _catch(int mods, Class<? extends Throwable> type, String var) {
        return this._try._catch(mods, type, var);
    }

    @Override
    public JCatch _catch(int mods, JType type, String var) {
        return this._try._catch(mods, type, var);
    }

    @Override
    public JTry ignore(String type) {
        this._try.ignore(type);
        return this;
    }

    @Override
    public JTry ignore(Class<? extends Throwable> type) {
        this._try.ignore(type);
        return this;
    }

    @Override
    public JTry ignore(JType type) {
        this._try.ignore(type);
        return this;
    }

    @Override
    public JBlock _finally() {
        return this._try._finally();
    }

    ImplJTry getTry() {
        return this._try;
    }

    ArrayList<JType> getTypes() {
        return this.types;
    }

    int getMods() {
        return this.mods;
    }

    String getVar() {
        return this.var;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        this.writeComments(writer);
        writer.write(Tokens$.KW.CATCH);
        writer.write(FormatPreferences.Space.BEFORE_PAREN_CATCH);
        writer.write(Tokens$.PUNCT.PAREN.OPEN);
        writer.write(FormatPreferences.Space.WITHIN_PAREN_CATCH);
        JMod.write(writer, this.mods);
        Iterator<JType> iterator = this.types.iterator();
        if (Assertions.alwaysTrue(iterator.hasNext())) {
            writer.write(iterator.next());
            while (iterator.hasNext()) {
                writer.write(Tokens$.PUNCT.BINOP.BOR);
                writer.write(iterator.next());
            }
        }
        writer.writeEscaped(this.var);
        writer.write(FormatPreferences.Space.WITHIN_PAREN_CATCH);
        writer.write(Tokens$.PUNCT.PAREN.CLOSE);
        super.write(writer, FormatPreferences.Space.BEFORE_BRACE_CATCH);
    }
}

