/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.engine;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.mvc.engine.ViewEngine;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.krazo.engine.Viewable;
import org.eclipse.krazo.util.AnnotationUtils;
import org.eclipse.krazo.util.CdiUtils;

@ApplicationScoped
public class ViewEngineFinder {
    @Inject
    private CdiUtils cdiUtils;
    private final Map<String, ViewEngine> cache = new HashMap<String, ViewEngine>();

    public ViewEngine find(Viewable viewable) {
        Optional<Object> engine;
        String view = viewable.getView();
        Class<? extends ViewEngine> engineClass = viewable.getViewEngine();
        if (engineClass != null) {
            engine = Optional.of(this.cdiUtils.newBean(engineClass));
        } else {
            engine = Optional.ofNullable(this.cache.get(view));
            if (!engine.isPresent()) {
                List<ViewEngine> engines = CdiUtils.getApplicationBeans(ViewEngine.class, new Annotation[0]);
                Set candidates = engines.stream().filter(e -> e.supports(view)).collect(Collectors.toSet());
                engine = candidates.stream().max((e1, e2) -> {
                    Priority p1 = AnnotationUtils.getAnnotation(e1.getClass(), Priority.class);
                    int v1 = p1 != null ? p1.value() : 3000;
                    Priority p2 = AnnotationUtils.getAnnotation(e2.getClass(), Priority.class);
                    int v2 = p2 != null ? p2.value() : 3000;
                    return v1 - v2;
                });
                engine.ifPresent(viewEngine -> this.cache.put(view, (ViewEngine)viewEngine));
            }
        }
        return engine.orElse(null);
    }
}

