/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jdke.props;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public final class EnvToPropsConverter {
    private final Path anchor;

    public EnvToPropsConverter(Path relativePathAnchor) {
        if (relativePathAnchor == null || !relativePathAnchor.isAbsolute()) {
            throw new IllegalArgumentException("The path is not absolute: " + String.valueOf(relativePathAnchor));
        }
        this.anchor = relativePathAnchor.normalize();
    }

    public Map<String, File> convert(Map<String, String> envToSysMappings) {
        HashMap<String, File> files = new HashMap<String, File>(envToSysMappings.size());
        for (String envPropertyName : envToSysMappings.keySet()) {
            File file;
            String systemPropertyName = envToSysMappings.get(envPropertyName);
            if (systemPropertyName == null || (file = this.convert(envPropertyName, systemPropertyName)) == null) continue;
            files.put(systemPropertyName, file);
        }
        return files;
    }

    public File convert(String envPropertyName, String systemPropertyName) {
        String value = this.evaluate(envPropertyName, systemPropertyName);
        return value == null ? null : this.toAbsoluteFile(new File(value));
    }

    private String evaluate(String envPropertyName, String systemPropertyName) {
        String envValue;
        String sysValue;
        if (systemPropertyName != null && (sysValue = System.getProperty(systemPropertyName)) != null) {
            return sysValue;
        }
        if (envPropertyName != null && (envValue = System.getenv(envPropertyName)) != null) {
            return envValue;
        }
        return null;
    }

    private File toAbsoluteFile(File file) {
        if (file.isAbsolute()) {
            return file.toPath().normalize().toFile();
        }
        return this.anchor.resolve(file.toPath()).toAbsolutePath().normalize().toFile();
    }
}

