/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent.cdi;

import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.transaction.Transactional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import org.glassfish.enterprise.concurrent.AsynchronousInterceptor;

public class ConcurrentCDIExtension
implements Extension {
    private static final Logger log = Logger.getLogger(ConcurrentCDIExtension.class.getName());

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        log.finest("ConcurrentCDIExtension.beforeBeanDiscovery");
        beforeBeanDiscovery.addInterceptorBinding(Asynchronous.class, new Annotation[0]);
        AnnotatedType asynchronousInterceptor = beanManager.createAnnotatedType(AsynchronousInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(asynchronousInterceptor, AsynchronousInterceptor.class.getName());
    }

    <T> void processAnnotatedType(@Observes @WithAnnotations(value={Asynchronous.class}) ProcessAnnotatedType<T> processAnnotatedType, BeanManager beanManager) throws Exception {
        log.finest("ConcurrentCDIExtension.processAnnotatedType");
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Set annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            boolean validReturnType;
            Asynchronous annotation;
            Method method = annotatedMethod.getJavaMember();
            if (method.getDeclaringClass().equals(AsynchronousInterceptor.class) || (annotation = method.getAnnotation(Asynchronous.class)) == null) continue;
            Class<?> returnType = method.getReturnType();
            boolean bl = validReturnType = returnType.equals(Void.TYPE) || returnType.equals(CompletableFuture.class) || returnType.equals(CompletionStage.class);
            if (!validReturnType) {
                throw new UnsupportedOperationException("Method \"" + method.getName() + "\" annotated with " + Asynchronous.class.getCanonicalName() + " does not return a CompletableFuture, CompletableFuture or void.");
            }
            Transactional transactionalAnnotation = (Transactional)annotatedMethod.getAnnotation(Transactional.class);
            if (transactionalAnnotation == null || transactionalAnnotation.value() == Transactional.TxType.REQUIRES_NEW || transactionalAnnotation.value() == Transactional.TxType.NOT_SUPPORTED) continue;
            throw new UnsupportedOperationException("Method \"" + method.getName() + "\" annotated with " + Asynchronous.class.getCanonicalName() + " is annotated with @Transactional, but not one of the allowed types: REQUIRES_NEW or NOT_SUPPORTED.");
        }
    }
}

