/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.data.provider.RowKey;
import com.sun.webui.jsf.component.Checkbox;
import com.sun.webui.jsf.component.HiddenField;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.IconHyperlink;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.event.TableSortActionListener;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import java.io.IOException;

public final class TableHeader
extends UIComponentBase
implements NamingContainer {
    public static final String ADD_SORT_BUTTON_ID = "_addSortButton";
    public static final String ADD_SORT_BUTTON_FACET = "addSortButton";
    public static final String COLLAPSED_HIDDEN_FIELD_ID = "_collapsedHiddenField";
    public static final String COLLAPSED_HIDDEN_FIELD_FACET = "collapsedHiddenField";
    public static final String GROUP_PANEL_TOGGLE_BUTTON_ID = "_groupPanelToggleButton";
    public static final String GROUP_PANEL_TOGGLE_BUTTON_FACET = "groupPanelToggleButton";
    public static final String PRIMARY_SORT_BUTTON_ID = "_primarySortButton";
    public static final String PRIMARY_SORT_BUTTON_FACET = "primarySortButton";
    public static final String PRIMARY_SORT_LINK_ID = "_primarySortLink";
    public static final String PRIMARY_SORT_LINK_FACET = "primarySortLink";
    public static final String SELECT_MULTIPLE_TOGGLE_BUTTON_ID = "_selectMultipleToggleButton";
    public static final String SELECT_MULTIPLE_TOGGLE_BUTTON_FACET = "selectMultipleToggleButton";
    public static final String SELECT_SORT_BUTTON_ID = "_selectSortButton";
    public static final String SELECT_SORT_BUTTON_FACET = "selectSortButton";
    public static final String SORT_LEVEL_TEXT_ID = "_sortLevelText";
    public static final String SORT_LEVEL_TEXT_FACET = "sortLevelText";
    public static final String TOGGLE_SORT_BUTTON_ID = "_toggleSortButton";
    public static final String TOGGLE_SORT_BUTTON_FACET = "toggleSortButton";
    public static final String WARNING_ICON_ID = "_warningIcon";
    public static final String WARNING_ICON_FACET = "warningIcon";
    private Table table = null;
    private TableColumn tableColumn = null;
    private TableRowGroup tableRowGroup = null;
    private boolean descending = false;
    private boolean descendingSet = false;
    private int selectedRowsCount = -1;
    private int sortCount = -1;
    private int sortLevel = -1;
    private String abbr = null;
    private String align = null;
    private String axis = null;
    private String bgColor = null;
    private String charFor = null;
    private String charOff = null;
    private int colSpan = Integer.MIN_VALUE;
    private boolean colSpanSet = false;
    private String extraHtml = null;
    private boolean groupHeader = false;
    private boolean groupHeaderSet = false;
    private String headers = null;
    private String height = null;
    private boolean noWrap = false;
    private boolean noWrapSet = false;
    private String onClick = null;
    private String onDblClick = null;
    private String onKeyDown = null;
    private String onKeyPress = null;
    private String onKeyUp = null;
    private String onMouseDown = null;
    private String onMouseMove = null;
    private String onMouseOut = null;
    private String onMouseOver = null;
    private String onMouseUp = null;
    private int rowSpan = Integer.MIN_VALUE;
    private boolean rowSpanSet = false;
    private String scope = null;
    private boolean selectHeader = false;
    private boolean selectHeaderSet = false;
    private boolean sortHeader = false;
    private boolean sortHeaderSet = false;
    private String style = null;
    private String styleClass = null;
    private String toolTip = null;
    private String valign = null;
    private boolean visible = false;
    private boolean visibleSet = false;
    private String width = null;

    public TableHeader() {
        this.setRendererType("com.sun.webui.jsf.TableHeader");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.TableHeader";
    }

    public int getSortCount() {
        if (this.sortCount == -1) {
            TableRowGroup group = this.getTableRowGroupAncestor();
            this.sortCount = group != null ? group.getSortCount() : 0;
        }
        return this.sortCount;
    }

    public int getSortLevel() {
        if (this.sortLevel == -1) {
            TableColumn col = this.getTableColumnAncestor();
            TableRowGroup group = this.getTableRowGroupAncestor();
            if (col != null && group != null) {
                this.sortLevel = group.getSortLevel(col.getSortCriteria());
            } else {
                this.log("getSortLevel", "Cannot obtain sort level, TableColumn or TableRowGroup is null");
            }
        }
        return this.sortLevel;
    }

    public Table getTableAncestor() {
        if (this.table == null) {
            TableHeader component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof Table)) continue;
                this.table = (Table)((Object)component);
                break;
            }
        }
        return this.table;
    }

    public TableColumn getTableColumnAncestor() {
        if (this.tableColumn == null) {
            TableHeader component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof TableColumn)) continue;
                this.tableColumn = (TableColumn)((Object)component);
                break;
            }
        }
        return this.tableColumn;
    }

    public TableRowGroup getTableRowGroupAncestor() {
        if (this.tableRowGroup == null) {
            TableHeader component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof TableRowGroup)) continue;
                this.tableRowGroup = (TableRowGroup)((Object)component);
                break;
            }
        }
        return this.tableRowGroup;
    }

    public UIComponent getCollapsedHiddenField() {
        UIComponent facet = this.getFacet(COLLAPSED_HIDDEN_FIELD_FACET);
        if (facet != null) {
            return facet;
        }
        HiddenField child = new HiddenField();
        child.setId(COLLAPSED_HIDDEN_FIELD_ID);
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group != null) {
            child.setText(group.isCollapsed());
        } else {
            this.log("getCollapsedHiddenField", "Cannot set collapsed hidden field value, TableRowGroup is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getGroupPanelToggleButton() {
        UIComponent facet = this.getFacet(GROUP_PANEL_TOGGLE_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table tableAncestor = this.getTableAncestor();
        TableRowGroup group = this.getTableRowGroupAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(GROUP_PANEL_TOGGLE_BUTTON_ID);
        if (group != null && group.isCollapsed()) {
            child.setIcon("TABLE_GROUP_PANEL");
        } else {
            child.setIcon("TABLE_GROUP_PANEL");
        }
        child.setBorder(0);
        StringBuilder buff = new StringBuilder();
        if (tableAncestor != null && group != null) {
            buff.append("document.getElementById('").append(tableAncestor.getClientId(this.getFacesContext())).append("').toggleGroupPanel('").append(group.getClientId(this.getFacesContext())).append("'); return false");
            child.setOnClick(buff.toString());
        } else {
            this.log("getGroupPanelToggleButton", "onClick not set, Table or TableRowGroup is null");
        }
        String zToolTip = group != null && group.isCollapsed() ? theme.getMessage("table.group.expand") : theme.getMessage("table.group.collapse");
        child.setAlt(zToolTip);
        child.setToolTip(zToolTip);
        if (tableAncestor != null) {
            child.setTabIndex(tableAncestor.getTabIndex());
        } else {
            this.log("getGroupPanelToggleButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSelectMultipleToggleButton() {
        UIComponent facet = this.getFacet(SELECT_MULTIPLE_TOGGLE_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Table tableAncestor = this.getTableAncestor();
        TableRowGroup group = this.getTableRowGroupAncestor();
        Checkbox child = new Checkbox();
        child.setId(SELECT_MULTIPLE_TOGGLE_BUTTON_ID);
        child.setSelectedValue(Boolean.TRUE);
        StringBuilder buff = new StringBuilder();
        if (tableAncestor != null && group != null) {
            buff.append("document.getElementById('").append(tableAncestor.getClientId(this.getFacesContext())).append("').selectGroupRows('").append(group.getClientId(this.getFacesContext())).append("', this.checked)");
            child.setOnClick(buff.toString());
        } else {
            this.log("getSelectMultipleToggleButton", "onClick not set, Table or TableRowgroup is null");
        }
        if (group != null) {
            RowKey[] rowKeys = group.getRenderedRowKeys();
            if (rowKeys != null && rowKeys.length > 0 && rowKeys.length == this.getSelectedRowsCount()) {
                child.setSelected(Boolean.TRUE);
                child.setToolTip(this.getTheme().getMessage("table.group.deselectMultiple"));
            } else {
                child.setToolTip(this.getTheme().getMessage("table.group.selectMultiple"));
            }
        } else {
            this.log("getSelectMultipleToggleButton", "Tool tip & selected not set, TableRowGroup is null");
        }
        if (tableAncestor != null) {
            child.setTabIndex(tableAncestor.getTabIndex());
        } else {
            this.log("getSelectMultipleToggleButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getWarningIcon() {
        UIComponent facet = this.getFacet(WARNING_ICON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        TableRowGroup group = this.getTableRowGroupAncestor();
        Icon child = ThemeUtilities.getIcon(theme, "ALERT_WARNING_SMALL");
        RowKey[] rowKeys = group != null ? group.getRenderedRowKeys() : null;
        int rows = this.getSelectedRowsCount();
        if (group != null && !group.isCollapsed() || rows == 0 || rowKeys != null && rowKeys.length > 0 && rowKeys.length == rows) {
            Icon placeHolder = ThemeUtilities.getIcon(theme, "DOT");
            placeHolder.setHeight(child.getHeight());
            placeHolder.setWidth(child.getWidth());
            child = placeHolder;
        } else {
            this.log("getWarningIcon", "Height & width not set, TableRowGroup is null");
        }
        child.setId(WARNING_ICON_ID);
        child.setBorder(0);
        String zToolTip = group != null && group.isCollapsed() ? theme.getMessage("table.group.warning") : null;
        child.setAlt(zToolTip);
        child.setToolTip(zToolTip);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getAddSortButton() {
        UIComponent facet = this.getFacet(ADD_SORT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table tableAncestor = this.getTableAncestor();
        TableColumn col = this.getTableColumnAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(ADD_SORT_BUTTON_ID);
        child.setIcon("TABLE_SORT_ADD");
        child.setBorder(0);
        child.setAlign("top");
        child.setStyleClass(theme.getStyleClass("TABLE_HEADER_LINK_IMG"));
        child.addActionListener(new TableSortActionListener());
        String zToolTip = this.getTheme().getMessage("table.sort.button.add", new String[]{this.getNextSortToolTipAugment()});
        child.setToolTip(zToolTip);
        if (this.isSelectHeader()) {
            child.setAlt(theme.getMessage("table.sort.alt.add", new String[]{theme.getMessage("table.select.selectionColumn")}));
        } else {
            String header = col != null && col.getHeaderText() != null ? col.getHeaderText() : "";
            child.setAlt(theme.getMessage("table.sort.alt.add", new String[]{header}));
        }
        if (tableAncestor != null) {
            child.setTabIndex(tableAncestor.getTabIndex());
        } else {
            this.log("getAddSortButton", "Tab index not set, Table is null");
        }
        if (this.getSortCount() > 0 && this.getSortLevel() > 0) {
            child.getChildren().add(this.getSortLevelText());
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPrimarySortButton() {
        UIComponent facet = this.getFacet(PRIMARY_SORT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table tableAncestor = this.getTableAncestor();
        TableColumn col = this.getTableColumnAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(PRIMARY_SORT_BUTTON_ID);
        child.setIcon("TABLE_SORT_PRIMARY");
        child.setBorder(0);
        child.setAlign("top");
        child.setStyleClass(theme.getStyleClass("TABLE_HEADER_LINK_IMG"));
        child.addActionListener(new TableSortActionListener());
        String zToolTip = theme.getMessage("table.sort.button.primary", new String[]{this.getNextSortToolTipAugment()});
        child.setToolTip(zToolTip);
        if (col != null) {
            String header = col.getHeaderText() != null ? col.getHeaderText() : "";
            child.setAlt(theme.getMessage("table.sort.alt.primary", new String[]{header}));
        } else {
            this.log("getPrimarySortButton", "Alt text not set, TableColumn is null");
        }
        if (tableAncestor != null) {
            child.setTabIndex(tableAncestor.getTabIndex());
        } else {
            this.log("getPrimarySortButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPrimarySortLink() {
        UIComponent facet = this.getFacet(PRIMARY_SORT_LINK_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table tableAncestor = this.getTableAncestor();
        TableColumn col = this.getTableColumnAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(PRIMARY_SORT_LINK_ID);
        child.setStyleClass(theme.getStyleClass("TABLE_HEADER_LINK"));
        child.addActionListener(new TableSortActionListener());
        String zToolTip = "table.sort.link.other";
        if (this.getSortLevel() == 1 && this.getSortCount() == 1) {
            zToolTip = "table.sort.link.primary";
        } else if (this.getSortCount() == 0) {
            zToolTip = "table.sort.link.none";
        }
        if (col != null) {
            child.setIcon(col.getSortIcon());
            child.setText(col.getHeaderText());
            child.setImageURL(col.getSortImageURL());
            child.setToolTip(this.getTheme().getMessage(zToolTip, new String[]{col.getSortToolTipAugment(col.isDescending())}));
        } else {
            this.log("getPrimarySortLink", "Tool tip, icon, text, & image URL not set, TableColumn is null");
        }
        if (tableAncestor != null) {
            child.setTabIndex(tableAncestor.getTabIndex());
        } else {
            this.log("getPrimarySortLink", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSelectSortButton() {
        UIComponent facet = this.getFacet(SELECT_SORT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table tableAncestor = this.getTableAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(SELECT_SORT_BUTTON_ID);
        child.setIcon("TABLE_SORT_SELECT");
        child.setBorder(0);
        child.setAlign("top");
        child.setStyleClass(theme.getStyleClass("TABLE_HEADER_LINK"));
        child.addActionListener(new TableSortActionListener());
        String zToolTip = "table.sort.link.other";
        if (this.getSortLevel() == 1 && this.getSortCount() == 1) {
            zToolTip = "table.sort.link.primary";
        } else if (this.getSortCount() == 0) {
            zToolTip = "table.sort.link.none";
        }
        child.setToolTip(theme.getMessage(zToolTip, new String[]{this.getNextSortToolTipAugment()}));
        String alt = theme.getMessage("table.sort.alt.primary", new String[]{theme.getMessage("table.select.selectionColumn")});
        child.setAlt(alt);
        if (tableAncestor != null) {
            child.setTabIndex(tableAncestor.getTabIndex());
        } else {
            this.log("getSelectSortButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSortLevelText() {
        UIComponent facet = this.getFacet(SORT_LEVEL_TEXT_FACET);
        if (facet != null) {
            return facet;
        }
        StaticText child = new StaticText();
        child.setId(SORT_LEVEL_TEXT_ID);
        child.setText(Integer.toString(this.getSortLevel()));
        child.setStyleClass(this.getTheme().getStyleClass("TABLE_HEADER_SORTNUM"));
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getToggleSortButton() {
        UIComponent facet = this.getFacet(TOGGLE_SORT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table tableAncestor = this.getTableAncestor();
        TableColumn col = this.getTableColumnAncestor();
        TableRowGroup group = this.getTableRowGroupAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(TOGGLE_SORT_BUTTON_ID);
        child.setBorder(0);
        child.setAlign("top");
        child.addActionListener(new TableSortActionListener());
        if (tableAncestor != null && col != null) {
            if (!this.isDescending() && group.isPaginated() && col.getSelectId() != null && !tableAncestor.isHiddenSelectedRows()) {
                child.setDisabled(true);
            }
        } else {
            this.log("getToggleSortButton", "Disabled state not set, Table or TableColumn is null");
        }
        if (col != null) {
            child.setToolTip(theme.getMessage("table.sort.button.toggle", new String[]{col.getSortToolTipAugment(!this.isDescending())}));
            if (this.isSelectHeader()) {
                child.setAlt(theme.getMessage("table.sort.alt.primary", new String[]{theme.getMessage("table.select.selectionColumn"), col.getSortToolTipAugment(this.isDescending()), Integer.toString(this.getSortLevel())}));
            } else {
                String header = col.getHeaderText() != null ? col.getHeaderText() : "";
                child.setAlt(theme.getMessage("table.sort.alt.toggle", new String[]{header, col.getSortToolTipAugment(this.isDescending()), Integer.toString(this.getSortLevel())}));
            }
        } else {
            this.log("getToggleSortButton", "Alt text not set, TableColumn is null");
        }
        if (child.isDisabled()) {
            child.setIcon("TABLE_SORT_DESCENDING_DISABLED");
        } else if (!this.isDescending()) {
            child.setIcon("TABLE_SORT_DESCENDING");
        } else {
            child.setIcon("TABLE_SORT_ASCENDING");
        }
        if (child.isDisabled()) {
            if (this.getSortLevel() == 1) {
                child.setStyleClass(theme.getStyleClass("TABLE_HEADER_SORT_DISABLED"));
            } else {
                child.setStyleClass(theme.getStyleClass("TABLE_HEADER_SELECTCOL_DISABLED"));
            }
        } else {
            child.setStyleClass(theme.getStyleClass("TABLE_HEADER_LINK_IMG"));
        }
        if (this.getSortLevel() > 0 && this.getSortCount() > 0) {
            child.getChildren().add(this.getSortLevelText());
        }
        if (tableAncestor != null) {
            child.setTabIndex(tableAncestor.getTabIndex());
        } else {
            this.log("getToggleSortButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.table = null;
        this.tableColumn = null;
        this.tableRowGroup = null;
        this.descending = false;
        this.descendingSet = false;
        this.selectedRowsCount = -1;
        this.sortCount = -1;
        this.sortLevel = -1;
        super.encodeBegin(context);
    }

    public String getAbbr() {
        if (this.abbr != null) {
            return this.abbr;
        }
        ValueExpression vb = this.getValueExpression("abbr");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAbbr(String newAbbr) {
        this.abbr = newAbbr;
    }

    public String getAlign() {
        if (this.align != null) {
            return this.align;
        }
        ValueExpression vb = this.getValueExpression("align");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAlign(String newAlign) {
        this.align = newAlign;
    }

    public String getAxis() {
        if (this.axis != null) {
            return this.axis;
        }
        ValueExpression vb = this.getValueExpression("axis");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAxis(String newAxis) {
        this.axis = newAxis;
    }

    public String getBgColor() {
        if (this.bgColor != null) {
            return this.bgColor;
        }
        ValueExpression vb = this.getValueExpression("bgColor");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setBgColor(String newBgColor) {
        this.bgColor = newBgColor;
    }

    public String getChar() {
        if (this.charFor != null) {
            return this.charFor;
        }
        ValueExpression vb = this.getValueExpression("char");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setChar(String newCharFor) {
        this.charFor = newCharFor;
    }

    public String getCharOff() {
        if (this.charOff != null) {
            return this.charOff;
        }
        ValueExpression vb = this.getValueExpression("charOff");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setCharOff(String newCharOff) {
        this.charOff = newCharOff;
    }

    public int getColSpan() {
        if (this.colSpanSet) {
            return this.colSpan;
        }
        ValueExpression vb = this.getValueExpression("colSpan");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setColSpan(int newColSpan) {
        this.colSpan = newColSpan;
        this.colSpanSet = true;
    }

    public String getExtraHtml() {
        if (this.extraHtml != null) {
            return this.extraHtml;
        }
        ValueExpression vb = this.getValueExpression("extraHtml");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setExtraHtml(String newExtraHtml) {
        this.extraHtml = newExtraHtml;
    }

    public boolean isGroupHeader() {
        if (this.groupHeaderSet) {
            return this.groupHeader;
        }
        ValueExpression vb = this.getValueExpression("groupHeader");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setGroupHeader(boolean newGroupHeader) {
        this.groupHeader = newGroupHeader;
        this.groupHeaderSet = true;
    }

    public String getHeaders() {
        if (this.headers != null) {
            return this.headers;
        }
        ValueExpression vb = this.getValueExpression("headers");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setHeaders(String newHeaders) {
        this.headers = newHeaders;
    }

    public String getHeight() {
        if (this.height != null) {
            return this.height;
        }
        ValueExpression vb = this.getValueExpression("height");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setHeight(String newHeight) {
        this.height = newHeight;
    }

    public boolean isNoWrap() {
        if (this.noWrapSet) {
            return this.noWrap;
        }
        ValueExpression vb = this.getValueExpression("noWrap");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setNoWrap(boolean newNoWrap) {
        this.noWrap = newNoWrap;
        this.noWrapSet = true;
    }

    public String getOnClick() {
        if (this.onClick != null) {
            return this.onClick;
        }
        ValueExpression vb = this.getValueExpression("onClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnClick(String newOnClick) {
        this.onClick = newOnClick;
    }

    public String getOnDblClick() {
        if (this.onDblClick != null) {
            return this.onDblClick;
        }
        ValueExpression vb = this.getValueExpression("onDblClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnDblClick(String newOnDblClick) {
        this.onDblClick = newOnDblClick;
    }

    public String getOnKeyDown() {
        if (this.onKeyDown != null) {
            return this.onKeyDown;
        }
        ValueExpression vb = this.getValueExpression("onKeyDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyDown(String newOnKeyDown) {
        this.onKeyDown = newOnKeyDown;
    }

    public String getOnKeyPress() {
        if (this.onKeyPress != null) {
            return this.onKeyPress;
        }
        ValueExpression vb = this.getValueExpression("onKeyPress");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyPress(String newOnKeyPress) {
        this.onKeyPress = newOnKeyPress;
    }

    public String getOnKeyUp() {
        if (this.onKeyUp != null) {
            return this.onKeyUp;
        }
        ValueExpression vb = this.getValueExpression("onKeyUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyUp(String newOnKeyUp) {
        this.onKeyUp = newOnKeyUp;
    }

    public String getOnMouseDown() {
        if (this.onMouseDown != null) {
            return this.onMouseDown;
        }
        ValueExpression vb = this.getValueExpression("onMouseDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseDown(String newOnMouseDown) {
        this.onMouseDown = newOnMouseDown;
    }

    public String getOnMouseMove() {
        if (this.onMouseMove != null) {
            return this.onMouseMove;
        }
        ValueExpression vb = this.getValueExpression("onMouseMove");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseMove(String newOnMouseMove) {
        this.onMouseMove = newOnMouseMove;
    }

    public String getOnMouseOut() {
        if (this.onMouseOut != null) {
            return this.onMouseOut;
        }
        ValueExpression vb = this.getValueExpression("onMouseOut");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOut(String newOnMouseOut) {
        this.onMouseOut = newOnMouseOut;
    }

    public String getOnMouseOver() {
        if (this.onMouseOver != null) {
            return this.onMouseOver;
        }
        ValueExpression vb = this.getValueExpression("onMouseOver");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOver(String newOnMouseOver) {
        this.onMouseOver = newOnMouseOver;
    }

    public String getOnMouseUp() {
        if (this.onMouseUp != null) {
            return this.onMouseUp;
        }
        ValueExpression vb = this.getValueExpression("onMouseUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseUp(String newOnMouseUp) {
        this.onMouseUp = newOnMouseUp;
    }

    public int getRowSpan() {
        if (this.rowSpanSet) {
            return this.rowSpan;
        }
        ValueExpression vb = this.getValueExpression("rowSpan");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setRowSpan(int newRowSpan) {
        this.rowSpan = newRowSpan;
        this.rowSpanSet = true;
    }

    public String getScope() {
        if (this.scope != null) {
            return this.scope;
        }
        ValueExpression vb = this.getValueExpression("scope");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setScope(String newScope) {
        this.scope = newScope;
    }

    public boolean isSelectHeader() {
        if (this.selectHeaderSet) {
            return this.selectHeader;
        }
        ValueExpression vb = this.getValueExpression("selectHeader");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setSelectHeader(boolean newSelectHeader) {
        this.selectHeader = newSelectHeader;
        this.selectHeaderSet = true;
    }

    public boolean isSortHeader() {
        if (this.sortHeaderSet) {
            return this.sortHeader;
        }
        ValueExpression vb = this.getValueExpression("sortHeader");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setSortHeader(boolean newSortHeader) {
        this.sortHeader = newSortHeader;
        this.sortHeaderSet = true;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression vb = this.getValueExpression("toolTip");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String newToolTip) {
        this.toolTip = newToolTip;
    }

    public String getValign() {
        if (this.valign != null) {
            return this.valign;
        }
        ValueExpression vb = this.getValueExpression("valign");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setValign(String newValign) {
        this.valign = newValign;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueExpression vb = this.getValueExpression("width");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setWidth(String newWidth) {
        this.width = newWidth;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.abbr = (String)values[1];
        this.align = (String)values[2];
        this.axis = (String)values[3];
        this.bgColor = (String)values[4];
        this.charFor = (String)values[5];
        this.charOff = (String)values[6];
        this.colSpan = (Integer)values[7];
        this.colSpanSet = (Boolean)values[8];
        this.extraHtml = (String)values[9];
        this.groupHeader = (Boolean)values[10];
        this.groupHeaderSet = (Boolean)values[11];
        this.headers = (String)values[12];
        this.height = (String)values[13];
        this.noWrap = (Boolean)values[14];
        this.noWrapSet = (Boolean)values[15];
        this.onClick = (String)values[16];
        this.onDblClick = (String)values[17];
        this.onKeyDown = (String)values[18];
        this.onKeyPress = (String)values[19];
        this.onKeyUp = (String)values[20];
        this.onMouseDown = (String)values[21];
        this.onMouseMove = (String)values[22];
        this.onMouseOut = (String)values[23];
        this.onMouseOver = (String)values[24];
        this.onMouseUp = (String)values[25];
        this.rowSpan = (Integer)values[26];
        this.rowSpanSet = (Boolean)values[27];
        this.scope = (String)values[28];
        this.selectHeader = (Boolean)values[29];
        this.selectHeaderSet = (Boolean)values[30];
        this.sortHeader = (Boolean)values[31];
        this.sortHeaderSet = (Boolean)values[32];
        this.style = (String)values[33];
        this.styleClass = (String)values[34];
        this.toolTip = (String)values[35];
        this.valign = (String)values[36];
        this.visible = (Boolean)values[37];
        this.visibleSet = (Boolean)values[38];
        this.width = (String)values[39];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.abbr, this.align, this.axis, this.bgColor, this.charFor, this.charOff, this.colSpan, this.colSpanSet ? Boolean.TRUE : Boolean.FALSE, this.extraHtml, this.groupHeader ? Boolean.TRUE : Boolean.FALSE, this.groupHeaderSet ? Boolean.TRUE : Boolean.FALSE, this.headers, this.height, this.noWrap ? Boolean.TRUE : Boolean.FALSE, this.noWrapSet ? Boolean.TRUE : Boolean.FALSE, this.onClick, this.onDblClick, this.onKeyDown, this.onKeyPress, this.onKeyUp, this.onMouseDown, this.onMouseMove, this.onMouseOut, this.onMouseOver, this.onMouseUp, this.rowSpan, this.rowSpanSet ? Boolean.TRUE : Boolean.FALSE, this.scope, this.selectHeader ? Boolean.TRUE : Boolean.FALSE, this.selectHeaderSet ? Boolean.TRUE : Boolean.FALSE, this.sortHeader ? Boolean.TRUE : Boolean.FALSE, this.sortHeaderSet ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.toolTip, this.valign, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE, this.width};
        return values;
    }

    private String getNextSortToolTipAugment() {
        TableColumn col = this.getTableColumnAncestor();
        if (col != null) {
            return col.getSortToolTipAugment(this.isDescending());
        }
        return "";
    }

    private int getSelectedRowsCount() {
        TableRowGroup group;
        if (this.selectedRowsCount == -1 && (group = this.getTableRowGroupAncestor()) != null) {
            this.selectedRowsCount = group.getRenderedSelectedRowsCount();
        }
        return this.selectedRowsCount;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(this.getFacesContext());
    }

    private boolean isDescending() {
        if (!this.descendingSet) {
            TableColumn col = this.getTableColumnAncestor();
            TableRowGroup group = this.getTableRowGroupAncestor();
            if (col != null && group != null) {
                this.descending = this.getSortLevel() > 0 ? group.isDescendingSort(col.getSortCriteria()) : col.isDescending();
                this.descendingSet = true;
            }
        }
        return this.descending;
    }

    private void log(String method, String msg) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + msg);
        }
    }
}

