/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;

public class XMLCollectionReferenceMappingMarshalNodeValue
extends MappingNodeValue
implements ContainerValue {
    private CollectionReferenceMapping xmlCollectionReferenceMapping;
    private XPathNode branchNode;
    private int index = -1;

    public XMLCollectionReferenceMappingMarshalNodeValue(CollectionReferenceMapping xmlCollectionReferenceMapping) {
        this.xmlCollectionReferenceMapping = xmlCollectionReferenceMapping;
        this.branchNode = new XPathNode();
        Object namespaceResolver = ((Descriptor)xmlCollectionReferenceMapping.getDescriptor()).getNamespaceResolver();
        List fkFields = xmlCollectionReferenceMapping.getFields();
        int fkFieldsSize = fkFields.size();
        for (int x = 0; x < fkFieldsSize; ++x) {
            Field fkField = (Field)fkFields.get(x);
            this.branchNode.addChild(fkField.getXPathFragment(), new XMLCollectionReferenceMappingFKMarshalNodeValue(xmlCollectionReferenceMapping, fkField), (NamespaceResolver)namespaceResolver);
        }
    }

    @Override
    public boolean isOwningNode(XPathFragment fragment) {
        return true;
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.xmlCollectionReferenceMapping.getContainerPolicy();
    }

    @Override
    public CollectionReferenceMapping getMapping() {
        return this.xmlCollectionReferenceMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.xmlCollectionReferenceMapping.getReuseContainer();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCollectionReferenceMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        Object iterator;
        if (this.xmlCollectionReferenceMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlCollectionReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (null == collection) {
            return false;
        }
        CoreContainerPolicy cp = this.getContainerPolicy();
        if (!cp.hasNext(iterator = cp.iteratorFor(collection))) {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, false);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        marshalRecord.startCollection();
        if (xPathFragment != XPathFragment.SELF_FRAGMENT) {
            marshalRecord.openStartElement(xPathFragment, namespaceResolver);
        }
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        if (xPathFragment != XPathFragment.SELF_FRAGMENT) {
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        marshalRecord.endCollection();
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlCollectionReferenceMapping.usesSingleNode()) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            if (xPathFragment.isAttribute()) {
                marshalRecord.attribute(xPathFragment, namespaceResolver, (String)value);
                marshalRecord.closeStartGroupingElements(groupingFragment);
            } else {
                marshalRecord.closeStartGroupingElements(groupingFragment);
                marshalRecord.characters((String)value);
            }
        } else {
            int size = marshalContext.getNonAttributeChildrenSize(this.branchNode);
            for (int x = 0; x < size; ++x) {
                XPathNode xPathNode = (XPathNode)marshalContext.getNonAttributeChild(x, this.branchNode);
                xPathNode.marshal(marshalRecord, value, session, namespaceResolver, (Marshaller)marshalRecord.getMarshaller(), marshalContext.getMarshalContext(x), null);
            }
        }
        return true;
    }

    @Override
    public boolean isMarshalNodeValue() {
        return !this.xmlCollectionReferenceMapping.usesSingleNode();
    }

    @Override
    public boolean isUnmarshalNodeValue() {
        return false;
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return true;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }

    private static class XMLCollectionReferenceMappingFKMarshalNodeValue
    extends MappingNodeValue {
        private CollectionReferenceMapping xmlCollectionReferenceMapping;
        private Field xmlField;

        public XMLCollectionReferenceMappingFKMarshalNodeValue(CollectionReferenceMapping xmlCollectionReferenceMapping, Field xmlField) {
            this.xmlCollectionReferenceMapping = xmlCollectionReferenceMapping;
            this.xmlField = xmlField;
        }

        @Override
        public boolean isUnmarshalNodeValue() {
            return false;
        }

        @Override
        public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
            return this.marshalSingleValue(xPathFragment, marshalRecord, null, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }

        @Override
        public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
            Object fieldValue = this.xmlCollectionReferenceMapping.buildFieldValue(value, this.xmlField, session);
            if (fieldValue == null) {
                if (null != value) {
                    Field f2 = (Field)this.xmlCollectionReferenceMapping.getSourceToTargetKeyFieldAssociations().get(this.xmlField);
                    fieldValue = ((Context)((Marshaller)marshalRecord.getMarshaller()).getContext()).getValueByXPath(value, f2.getXPath(), f2.getNamespaceResolver(), Object.class);
                }
                if (null == fieldValue) {
                    return false;
                }
            }
            QName schemaType = this.xmlField.getSchemaTypeForValue(fieldValue, session);
            if (xPathFragment.isAttribute()) {
                marshalRecord.attribute(xPathFragment, namespaceResolver, fieldValue, schemaType);
                marshalRecord.closeStartElement();
            } else {
                marshalRecord.closeStartElement();
                marshalRecord.characters(schemaType, fieldValue, null, false);
            }
            return true;
        }

        @Override
        public CollectionReferenceMapping getMapping() {
            return this.xmlCollectionReferenceMapping;
        }
    }
}

