/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.deployment.annotation.handlers.ResourceAnnotationControl;
import jakarta.resource.AdministeredObjectDefinition;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.Set;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=AdministeredObjectDefinition.class)
public class AdministeredObjectDefinitionHandler
extends AbstractResourceHandler {
    private static final ResourceAnnotationControl CTRL = new ResourceAnnotationControl(AdministeredObjectDefinition.class);

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        AdministeredObjectDefinition adminObjectDefnAn = (AdministeredObjectDefinition)ainfo.getAnnotation();
        return this.processAnnotation(adminObjectDefnAn, ainfo, rcContexts);
    }

    protected HandlerProcessingResult processAnnotation(AdministeredObjectDefinition adminObjectDefnAn, AnnotationInfo aiInfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Class annotatedClass = (Class)aiInfo.getAnnotatedElement();
        Annotation[] annotations = annotatedClass.getAnnotations();
        boolean warClass = this.isAWebComponentClass(annotations);
        boolean ejbClass = this.isAEjbComponentClass(annotations);
        for (ResourceContainerContext context : rcContexts) {
            AdministeredObjectDefinitionDescriptor desc;
            if (!CTRL.canProcessAnnotation(annotatedClass, ejbClass, warClass, context)) {
                return this.getDefaultProcessedResult();
            }
            Set aodDescs = context.getResourceDescriptors(JavaEEResourceType.AODD);
            if (this.isDefinitionAlreadyPresent(aodDescs, desc = this.createDescriptor(adminObjectDefnAn))) {
                this.merge(aodDescs, adminObjectDefnAn);
                continue;
            }
            context.addResourceDescriptor((ResourceDescriptor)desc);
        }
        return this.getDefaultProcessedResult();
    }

    private boolean isDefinitionAlreadyPresent(Set<ResourceDescriptor> descriptors, AdministeredObjectDefinitionDescriptor desc) {
        boolean result = false;
        for (ResourceDescriptor descriptor : descriptors) {
            if (!descriptor.equals(desc)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void merge(Set<ResourceDescriptor> aodDescs, AdministeredObjectDefinition defn) {
        for (ResourceDescriptor descriptor : aodDescs) {
            AdministeredObjectDefinitionDescriptor desc = (AdministeredObjectDefinitionDescriptor)descriptor;
            if (!desc.getName().equals(defn.name())) continue;
            if (desc.getDescription() == null && defn.description() != null && !defn.description().isEmpty()) {
                desc.setDescription(defn.description());
            }
            if (desc.getInterfaceName() == null || desc.getInterfaceName().isEmpty()) {
                desc.setInterfaceName(defn.interfaceName());
            }
            if (desc.getClassName() == null || desc.getClassName().isEmpty()) {
                desc.setClassName(defn.className());
            }
            if (desc.getResourceAdapter() == null || desc.getResourceAdapter().isEmpty()) {
                desc.setResourceAdapter(defn.resourceAdapter());
            }
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length <= 0) break;
            for (String property : defnProperties) {
                int index = property.indexOf(61);
                if (index <= 0 || index >= property.length() - 1) continue;
                String name = property.substring(0, index).trim();
                String value = property.substring(index + 1).trim();
                if (properties.get(name) != null) continue;
                properties.put(name, value);
            }
        }
    }

    private AdministeredObjectDefinitionDescriptor createDescriptor(AdministeredObjectDefinition defn) {
        AdministeredObjectDefinitionDescriptor desc = new AdministeredObjectDefinitionDescriptor();
        desc.setMetadataSource(MetadataSource.ANNOTATION);
        desc.setName(defn.name());
        desc.setInterfaceName(defn.interfaceName());
        desc.setClassName(defn.className());
        desc.setResourceAdapter(defn.resourceAdapter());
        if (defn.description() != null && !defn.description().equals("")) {
            desc.setDescription(defn.description());
        }
        if (defn.properties() != null) {
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length > 0) {
                for (String property : defnProperties) {
                    int index = property.indexOf("=");
                    if (index <= 0 || index >= property.length() - 1) continue;
                    String name = property.substring(0, index).trim();
                    String value = property.substring(index + 1).trim();
                    properties.put(name, value);
                }
            }
        }
        return desc;
    }
}

