/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.ConstructType;
import org.jboss.logging.annotations.LoggingClass;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Producer;
import org.jboss.logging.annotations.Signature;
import org.jboss.logging.annotations.Suppressed;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.annotations.TransformException;
import org.jboss.logging.processor.model.LoggerMessageMethod;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ReturnType;
import org.jboss.logging.processor.model.ThrowableType;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.validation.FormatValidator;
import org.jboss.logging.processor.validation.FormatValidatorFactory;
import org.jboss.logging.processor.validation.IdLengthValidator;
import org.jboss.logging.processor.validation.IdRangeValidator;
import org.jboss.logging.processor.validation.MessageIdValidator;
import org.jboss.logging.processor.validation.PropertyValidator;
import org.jboss.logging.processor.validation.ValidationMessage;
import org.jboss.logging.processor.validation.ValidationMessageFactory;

public final class Validator {
    private static final Collection<String> AVAILABLE_LANGUAGES = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
    private final MessageIdValidator messageIdValidator = new MessageIdValidator();
    private final IdLengthValidator idLengthValidator = new IdLengthValidator();
    private final IdRangeValidator idRangeValidator = new IdRangeValidator();
    private final ProcessingEnvironment processingEnv;
    private final Elements elements;
    private final Types types;

    public Validator(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
    }

    public final Collection<ValidationMessage> validate(MessageInterface messageInterface) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String locale = null;
        if (messageInterface.isAnnotatedWith(MessageBundle.class)) {
            Set<MessageMethod> messageMethods = this.getAllMethods(messageInterface);
            messages.addAll(this.validateCommon(messageInterface, messageMethods));
            messages.addAll(this.validateBundle(messageMethods));
            locale = messageInterface.getAnnotation(MessageBundle.class).rootLocale();
        } else if (messageInterface.isAnnotatedWith(MessageLogger.class)) {
            Set<MessageMethod> messageMethods = this.getAllMethods(messageInterface);
            messages.addAll(this.validateCommon(messageInterface, messageMethods));
            messages.addAll(this.validateLogger(messageMethods));
            locale = messageInterface.getAnnotation(MessageLogger.class).rootLocale();
        } else {
            messages.add(ValidationMessageFactory.createError((Element)messageInterface, "Message interface %s is not a message bundle or message logger.", messageInterface.name()));
        }
        if (locale != null && !locale.isEmpty() && !AVAILABLE_LANGUAGES.contains(Locale.forLanguageTag(locale).getLanguage())) {
            messages.add(ValidationMessageFactory.createWarning(messageInterface, "The locale '%s' may be invalid. The target runtime must include this locale to ensure formatting is handled correctly.", locale));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateCommon(MessageInterface messageInterface, Set<MessageMethod> messageMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashMap<CallSite, MessageMethod> methodNames = new HashMap<CallSite, MessageMethod>();
        messages.addAll(this.idLengthValidator.validate(messageInterface));
        messages.addAll(this.idRangeValidator.validate(messageInterface));
        for (MessageMethod messageMethod : messageMethods) {
            FormatValidator formatValidator;
            for (ThrowableType throwableType : messageMethod.thrownTypes()) {
                if (!throwableType.isChecked()) continue;
                messages.add(ValidationMessageFactory.createError(messageMethod, "Interface message methods cannot throw checked exceptions."));
            }
            MessageMethod.Message message = messageMethod.message();
            if (message == null) {
                messages.add(ValidationMessageFactory.createError(messageMethod, "All message bundles and message logger message methods must have or inherit a message."));
                continue;
            }
            if (message.hasId()) {
                if (message.id() < 0) {
                    messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Message id %d is invalid. Must be greater than 0 or inherit another valid id.", message.id()));
                } else {
                    messages.addAll(this.messageIdValidator.validate(messageInterface, messageMethod));
                }
            }
            if ((formatValidator = FormatValidatorFactory.create(messageMethod)).isValid()) {
                int paramCount = messageMethod.formatParameterCount();
                if (messageMethod.formatParameterCount() != formatValidator.argumentCount()) {
                    messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Parameter count does not match for format '%s'. Required: %d Provided: %d", formatValidator.format(), formatValidator.argumentCount(), paramCount));
                }
                TreeMap<Integer, Parameter> positions = new TreeMap<Integer, Parameter>();
                boolean validatePositions = false;
                for (Parameter parameter : messageMethod.parameters()) {
                    if (parameter.isAnnotatedWith(Transform.class)) {
                        this.validateTransform(messages, parameter, parameter.getAnnotation(Transform.class));
                    }
                    if (parameter.isAnnotatedWith(Pos.class)) {
                        validatePositions = true;
                        Pos pos = parameter.getAnnotation(Pos.class);
                        Transform[] transforms = pos.transform();
                        if (transforms != null && transforms.length > 0) {
                            if (pos.value().length != transforms.length) {
                                messages.add(ValidationMessageFactory.createError(parameter, "Positional parameters with transforms must have an equal number of positions and transforms."));
                            } else {
                                for (Transform transform : transforms) {
                                    this.validateTransform(messages, parameter, transform);
                                }
                            }
                        }
                        HashSet<Integer> usedPositions = new HashSet<Integer>();
                        for (int position : pos.value()) {
                            if (usedPositions.contains(position)) {
                                messages.add(ValidationMessageFactory.createError((Element)parameter, "Position '%d' already used for this parameter.", position));
                            } else {
                                usedPositions.add(position);
                            }
                            if (positions.containsKey(position)) {
                                messages.add(ValidationMessageFactory.createError((Element)parameter, "Position '%d' already defined on parameter '%s'", position, ((Parameter)positions.get(position)).name()));
                                continue;
                            }
                            positions.put(position, parameter);
                        }
                    }
                    if (!parameter.isAnnotatedWith(Suppressed.class)) continue;
                    if (!messageMethod.returnType().isThrowable()) {
                        messages.add(ValidationMessageFactory.createError(messageMethod, "The @Suppressed parameter annotation can only be used with message bundle methods that return an exception."));
                    }
                    if (this.isTypeAssignableFrom(parameter, Throwable.class)) continue;
                    messages.add(ValidationMessageFactory.createError(parameter, "The parameter annotated with @Suppressed must be assignable to a Throwable type."));
                }
                if (validatePositions) {
                    for (int i = 0; i < messageMethod.formatParameterCount(); ++i) {
                        int positionIndex = i + 1;
                        if (positions.containsKey(positionIndex)) continue;
                        messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Missing parameter with position '%d' defined.", positionIndex));
                    }
                }
            } else {
                messages.add(ValidationMessageFactory.createError(messageMethod, formatValidator.summaryMessage()));
            }
            if (!messageMethod.inheritsMessage()) {
                String key = messageMethod.name() + messageMethod.formatParameterCount();
                if (methodNames.containsKey(key)) {
                    MessageMethod previousMethod = (MessageMethod)methodNames.get(key);
                    messages.add(ValidationMessageFactory.createError(previousMethod, "Only one message with the same format parameters is allowed."));
                    messages.add(ValidationMessageFactory.createError(messageMethod, "Only one message with the same format parameters is allowed."));
                } else {
                    methodNames.put((CallSite)((Object)key), messageMethod);
                }
            }
            messages.addAll(this.validateParameters(messageMethod));
            messages.addAll(PropertyValidator.validate(this.processingEnv, messageMethod));
        }
        return messages;
    }

    private void validateTransform(List<ValidationMessage> messages, Parameter parameter, Transform transform) {
        List<Transform.TransformType> transformTypes = Arrays.asList(transform.value());
        if (parameter.isPrimitive()) {
            messages.add(ValidationMessageFactory.createError(parameter, "Parameters annotated with @Transform cannot be primitives."));
        } else if (transformTypes.contains((Object)Transform.TransformType.GET_CLASS) && transformTypes.contains((Object)Transform.TransformType.SIZE)) {
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Transform type '%s' not allowed with type '%s'", new Object[]{Transform.TransformType.GET_CLASS, Transform.TransformType.SIZE}));
        } else if (transformTypes.contains((Object)Transform.TransformType.HASH_CODE) && transformTypes.contains((Object)Transform.TransformType.SIZE)) {
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Transform type '%s' not allowed with type '%s'", new Object[]{Transform.TransformType.HASH_CODE, Transform.TransformType.SIZE}));
        } else if (transformTypes.contains((Object)Transform.TransformType.IDENTITY_HASH_CODE) && transformTypes.contains((Object)Transform.TransformType.SIZE)) {
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Transform type '%s' not allowed with type '%s'", new Object[]{Transform.TransformType.IDENTITY_HASH_CODE, Transform.TransformType.SIZE}));
        } else if (transformTypes.contains((Object)Transform.TransformType.IDENTITY_HASH_CODE) && transformTypes.contains((Object)Transform.TransformType.HASH_CODE)) {
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Transform type '%s' not allowed with type '%s'", new Object[]{Transform.TransformType.IDENTITY_HASH_CODE, Transform.TransformType.HASH_CODE}));
        } else if (!(!transformTypes.contains((Object)Transform.TransformType.SIZE) || parameter.isArray() || parameter.isVarArgs() || parameter.isSubtypeOf(Map.class) || parameter.isSubtypeOf(Collection.class) || parameter.isSubtypeOf(CharSequence.class))) {
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Invalid type (%s) for %s. Must be an array, %s, %s or %s.", new Object[]{parameter.asType(), Transform.TransformType.SIZE, Collection.class.getName(), Map.class.getName(), CharSequence.class.getName()}));
        }
    }

    private Collection<ValidationMessage> validateParameters(MessageMethod messageMethod) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        boolean foundCause = false;
        boolean producerFound = false;
        boolean transformExceptionFound = false;
        for (Parameter parameter : messageMethod.parameters()) {
            if (parameter.isAnnotatedWith(Cause.class)) {
                if (foundCause) {
                    messages.add(ValidationMessageFactory.createError(messageMethod, "Only one cause parameter is allowed."));
                } else {
                    foundCause = true;
                }
            }
            if (parameter.isAnnotatedWith(LoggingClass.class) && !parameter.isSameAs(Class.class)) {
                messages.add(ValidationMessageFactory.createError((Element)parameter, "Parameter %s annotated with @LoggingClass on method %s must be of type %s.", parameter.name(), messageMethod.name(), Class.class.getName()));
            }
            if (parameter.isAnnotatedWith(Producer.class)) {
                boolean isFunction = parameter.isSubtypeOf(Function.class);
                boolean isBiFunction = parameter.isSubtypeOf(BiFunction.class);
                TypeMirror requiredReturnType = messageMethod.returnType().resolvedType();
                List<? extends TypeMirror> typeArgs = ElementHelper.getTypeArguments(parameter);
                int size = typeArgs.size();
                if (isFunction) {
                    if (size == 2) {
                        TypeMirror message = typeArgs.get(0);
                        TypeMirror returnType = typeArgs.get(1);
                        if (!this.isTypeAssignableFrom(message, String.class)) {
                            messages.add(ValidationMessageFactory.createError((Element)parameter, "The type %s must be assignable to a String.", message));
                        }
                        if (!this.isTypeAssignableFrom(returnType, requiredReturnType)) {
                            messages.add(ValidationMessageFactory.createError((Element)parameter, "The return type parameter of the function must be assignable from %s", requiredReturnType));
                        }
                    } else {
                        messages.add(ValidationMessageFactory.createError((Element)parameter, "The type parameters could not be validated for the function. The first type argument of the function must be a String and the second type parameter must be the same as or a super type of %s.", requiredReturnType));
                    }
                } else if (isBiFunction) {
                    if (size == 3) {
                        TypeMirror returnType = typeArgs.get(2);
                        TypeMirror first = typeArgs.get(0);
                        TypeMirror second = typeArgs.get(1);
                        if (!this.isTypeAssignableFrom(first, String.class) && !this.types.isSubtype(first, ElementHelper.toType(this.elements, Throwable.class))) {
                            messages.add(ValidationMessageFactory.createError((Element)parameter, "The first type type parameter for %s must be assignable to a String or a super type of a Throwable.", parameter.asType()));
                        }
                        if (!this.isTypeAssignableFrom(second, String.class) && !this.types.isSubtype(second, ElementHelper.toType(this.elements, Throwable.class))) {
                            messages.add(ValidationMessageFactory.createError((Element)parameter, "The second type parameter for %s must be assignable to a String or a super type of a Throwable.", parameter.asType()));
                        }
                        if (!this.isTypeAssignableFrom(returnType, requiredReturnType)) {
                            messages.add(ValidationMessageFactory.createError((Element)parameter, "The return type parameter of the function must be assignable from %s", requiredReturnType));
                        }
                        if (messageMethod.hasCause()) {
                            if (this.types.isSubtype(first, ElementHelper.toType(this.elements, Throwable.class)) && !this.isTypeAssignableFrom(messageMethod.cause().asType(), first)) {
                                messages.add(ValidationMessageFactory.createError((Element)parameter, "The first parameter type, %s, of the BiFunction must be assignable to the cause %s.", first, messageMethod.cause().asType()));
                            }
                            if (this.types.isSubtype(second, ElementHelper.toType(this.elements, Throwable.class)) && !this.isTypeAssignableFrom(messageMethod.cause().asType(), second)) {
                                messages.add(ValidationMessageFactory.createError((Element)parameter, "The second parameter type, %s, of the BiFunction must be assignable to the cause %s.", second, messageMethod.cause().asType()));
                            }
                        } else {
                            messages.add(ValidationMessageFactory.createWarning(messageMethod, "No @Cause parameter was found on the method. A null value will always be passed as the cause parameter to the BiFunction."));
                        }
                    } else {
                        messages.add(ValidationMessageFactory.createError((Element)parameter, "The type parameters could not be validated for the function. The first and second type arguments of the function must be a String or a super type of Throwable. The third type parameter must be the same as or a super type of %s.", requiredReturnType));
                    }
                } else {
                    messages.add(ValidationMessageFactory.createError((Element)parameter, "Parameter annotated with %s must be a %s or %s type", Producer.class.getName(), Function.class.getName(), BiFunction.class.getName()));
                }
                if (producerFound) {
                    messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Only one parameter is allowed to be annotated with %s.", Producer.class.getName()));
                }
                producerFound = true;
            }
            if (!parameter.isAnnotatedWith(TransformException.class)) continue;
            if (!messageMethod.returnType().isThrowable()) {
                messages.add(ValidationMessageFactory.createError((Element)messageMethod, "A parameter annotated with @%s can only be on bundle methods which return a Throwable type.", TransformException.class.getSimpleName()));
                continue;
            }
            if (transformExceptionFound) {
                messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Only one parameter annotated with @%s can be used", TransformException.class.getSimpleName()));
            }
            transformExceptionFound = true;
            if (!this.isTypeAssignableFrom(parameter.asType(), Throwable.class)) {
                messages.add(ValidationMessageFactory.createError((Element)parameter, "The parameter annotated with @%s must be a subclass of Throwable", TransformException.class.getSimpleName()));
            }
            List<TypeMirror> suggested = ElementHelper.getClassArrayAnnotationValue(parameter, TransformException.class, "value");
            for (TypeMirror suggestion : suggested) {
                if (this.types.isAssignable(suggestion, parameter.asType())) continue;
                messages.add(ValidationMessageFactory.createError((Element)parameter, "The suggested return type of %s is not assignable to %s", suggestion, parameter.asType()));
            }
        }
        return messages;
    }

    private Collection<ValidationMessage> validateBundle(Set<MessageMethod> messageMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (MessageMethod messageMethod : messageMethods) {
            messages.addAll(this.validateBundleMethod(messageMethod));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateBundleMethod(MessageMethod messageMethod) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        ReturnType returnType = messageMethod.returnType();
        TypeMirror returnTypeMirror = returnType.asType();
        TypeMirror resolvedReturnType = returnType.resolvedType();
        if (returnTypeMirror.getKind() == TypeKind.VOID || returnTypeMirror.getKind().isPrimitive()) {
            messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Message bundle messageMethod %s has an invalid return type. Cannot be void or a primitive.", messageMethod.name()));
        } else if (returnType.isThrowable()) {
            ThrowableType throwableReturnType = returnType.throwableReturnType();
            if (throwableReturnType.useConstructionParameters()) {
                Signature signature = messageMethod.getAnnotation(Signature.class);
                if (signature != null) {
                    int messageIndex;
                    List<TypeMirror> args = ElementHelper.getClassArrayAnnotationValue(messageMethod, Signature.class, "value");
                    if (!ElementHelper.hasConstructor(this.types, returnType, args)) {
                        messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Could not find constructor for %s with arguments %s", messageMethod.asType(), args));
                    }
                    if ((messageIndex = signature.messageIndex()) < 0) {
                        messages.add(ValidationMessageFactory.createError((Element)messageMethod, "A messageIndex of 0 or greater is required. Value %d is invalid.", messageIndex));
                    }
                }
                if (messageMethod.isAnnotatedWith(ConstructType.class)) {
                    TypeElement constructTypeValue = ElementHelper.getClassAnnotationValue(messageMethod, ConstructType.class);
                    if (constructTypeValue == null) {
                        messages.add(ValidationMessageFactory.createError(messageMethod, "Class not defined for the ConstructType"));
                    } else if (!this.types.isAssignable(constructTypeValue.asType(), returnType.asType())) {
                        messages.add(ValidationMessageFactory.createError((Element)messageMethod, "The requested type %s can not be assigned to %s.", constructTypeValue.asType(), returnType.asType()));
                    }
                }
            } else if (!throwableReturnType.useConstructionParameters() && !messageMethod.parametersAnnotatedWith(Param.class).isEmpty()) {
                messages.add(ValidationMessageFactory.createError((Element)messageMethod, "MessageMethod does not have an usable constructor for the return type %s.", returnType.name()));
            } else {
                boolean usableConstructor;
                boolean hasMessageConstructor = throwableReturnType.hasStringAndThrowableConstructor() || throwableReturnType.hasThrowableAndStringConstructor() || throwableReturnType.hasStringConstructor();
                boolean bl = usableConstructor = throwableReturnType.hasDefaultConstructor() || throwableReturnType.hasStringAndThrowableConstructor() || throwableReturnType.hasStringConstructor() || throwableReturnType.hasThrowableAndStringConstructor() || throwableReturnType.hasThrowableConstructor();
                if (!messageMethod.parametersAnnotatedWith(Producer.class).isEmpty()) {
                    TypeMirror erasure;
                    if (messageMethod.isAnnotatedWith(ConstructType.class)) {
                        messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Method annotated with %s cannot have a parameter annotated with %s.", ConstructType.class.getName(), Producer.class.getName()));
                    }
                    if (!this.isTypeAssignableFrom(erasure = this.types.erasure(resolvedReturnType), Throwable.class)) {
                        messages.add(ValidationMessageFactory.createError(messageMethod, "The return type must be a super class of a java.lang.Throwable"));
                    }
                } else if (!usableConstructor) {
                    messages.add(ValidationMessageFactory.createError((Element)messageMethod, "MessageMethod does not have an usable constructor for the return type %s.", returnType.name()));
                } else if (!hasMessageConstructor) {
                    messages.add(ValidationMessageFactory.createWarning(messageMethod, "The message cannot be set via the throwable constructor and will be ignored."));
                }
            }
        } else {
            if (!this.isTypeAssignableFrom(resolvedReturnType, String.class) && !returnType.isThrowable()) {
                messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Message bundle method (%s) has an invalid return type of %s. Return types must be a String, a subtype of Throwable or a java.util.function.Supplier which returns a String or a subtype of Throwable.", messageMethod.name(), returnTypeMirror));
            }
            if (messageMethod.isAnnotatedWith(ConstructType.class)) {
                messages.add(ValidationMessageFactory.createError(messageMethod, "ConstructType annotation requires a throwable or supplier which produces a throwable return type"));
            }
        }
        return messages;
    }

    private Collection<ValidationMessage> validateLogger(Set<MessageMethod> messageMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (MessageMethod messageMethod : messageMethods) {
            if (messageMethod instanceof LoggerMessageMethod) {
                messages.addAll(this.validateLoggerMethod(messageMethod));
                continue;
            }
            messages.addAll(this.validateBundleMethod(messageMethod));
            if (!messageMethod.isAnnotatedWith(Once.class)) continue;
            messages.add(ValidationMessageFactory.createError(messageMethod, "Only @LogMessage method can be annoted with @Once"));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateLoggerMethod(MessageMethod messageMethod) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (messageMethod.returnType().asType().getKind() != TypeKind.VOID) {
            messages.add(ValidationMessageFactory.createError(messageMethod, "Message logger methods can only have a void return type."));
        }
        return messages;
    }

    private Set<MessageMethod> getAllMethods(MessageInterface messageInterface) {
        if (messageInterface.isAnnotatedWith(MessageBundle.class) || messageInterface.isAnnotatedWith(MessageLogger.class)) {
            LinkedHashSet<MessageMethod> messageMethods = new LinkedHashSet<MessageMethod>();
            for (MessageMethod messageMethod : messageInterface.methods()) {
                messageMethods.add(messageMethod);
            }
            for (MessageInterface msgInterface : messageInterface.extendedInterfaces()) {
                messageMethods.addAll(this.getAllMethods(msgInterface));
            }
            return messageMethods;
        }
        return Collections.emptySet();
    }

    private boolean isTypeAssignableFrom(Element element, Class<?> type) {
        return this.isTypeAssignableFrom(element.asType(), type);
    }

    private boolean isTypeAssignableFrom(TypeMirror typeMirror, Class<?> type) {
        return this.isTypeAssignableFrom(typeMirror, ElementHelper.toType(this.elements, type));
    }

    private boolean isTypeAssignableFrom(TypeMirror typeMirror, TypeMirror type) {
        TypeMirror t = typeMirror;
        if (t.getKind() == TypeKind.ARRAY) {
            t = ((ArrayType)t).getComponentType();
        }
        if (this.types.isAssignable(this.types.erasure(t), ElementHelper.toType(this.elements, Collection.class))) {
            t = this.types.erasure(ElementHelper.getTypeArguments(t).iterator().next());
        }
        return this.types.isAssignable(t, type);
    }
}

