/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.dir;

import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public final class ContextEnumerator
implements NamingEnumeration {
    private static boolean debug = false;
    private NamingEnumeration children = null;
    private Binding currentChild = null;
    private Context root;
    private ContextEnumerator currentChildEnum = null;
    private boolean currentChildExpanded = false;
    private boolean rootProcessed = false;
    private int scope = 2;
    private String contextName = "";

    public ContextEnumerator(Context context) throws NamingException {
        this(context, 2);
    }

    public ContextEnumerator(Context context, int n) throws NamingException {
        this(context, n, "", n != 1);
    }

    public ContextEnumerator(Context context, int n, String string, boolean bl) throws NamingException {
        if (context == null) {
            throw new IllegalArgumentException("null context passed");
        }
        this.root = context;
        if (n != 0) {
            this.children = context.listBindings("");
        }
        this.scope = n;
        this.contextName = string;
        this.rootProcessed = bl ^ true;
        this.prepNextChild();
    }

    public void close() throws NamingException {
        this.root = null;
    }

    private Binding getNextChild() throws NamingException {
        Binding binding = (Binding)this.children.next();
        Binding binding2 = null;
        if (binding.isRelative() && !this.contextName.equals("")) {
            NameParser nameParser = this.root.getNameParser("");
            Name name = nameParser.parse(this.contextName);
            name.add(binding.getName());
            if (debug) {
                System.out.println("ContextEnumerator: adding " + name);
            }
            binding2 = new Binding(name.toString(), binding.getClassName(), binding.getObject(), binding.isRelative());
        } else {
            if (debug) {
                System.out.println("ContextEnumerator: using old binding");
            }
            binding2 = binding;
        }
        return binding2;
    }

    private Binding getNextDescendant() throws NamingException {
        Binding binding = null;
        if (this.scope == 2 && this.currentChildExpanded) {
            if (this.currentChildEnum.hasMore()) {
                binding = (Binding)this.currentChildEnum.next();
            } else {
                binding = this.currentChild;
                this.prepNextChild();
            }
        } else {
            if (debug) {
                System.out.println("getNextDescedant: simple case");
            }
            binding = this.currentChild;
            this.prepNextChild();
        }
        return binding;
    }

    public boolean hasMore() throws NamingException {
        if (this.scope != 0 && this.hasMoreDescendants()) {
            return true;
        }
        return this.rootProcessed ^ true;
    }

    private boolean hasMoreChildren() throws NamingException {
        return this.children != null && this.children.hasMore();
    }

    private boolean hasMoreDescendants() throws NamingException {
        if (this.currentChildExpanded && this.currentChildEnum.hasMore()) {
            if (debug) {
                System.out.println("hasMoreDescendants returning true");
            }
            return true;
        }
        if (debug) {
            System.out.println("hasMoreDescendants returning " + (this.currentChild != null));
        }
        return this.currentChild != null;
    }

    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public Object next() throws NamingException {
        if (this.scope != 0 && this.hasMoreDescendants()) {
            return this.getNextDescendant();
        }
        if (!this.rootProcessed) {
            this.rootProcessed = true;
            return new Binding("", this.root.getClass().getName(), this.root, true);
        }
        throw new NoSuchElementException();
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException(namingException.toString());
        }
    }

    private void prepNextChild() throws NamingException {
        if (this.hasMoreChildren()) {
            try {
                this.currentChild = this.getNextChild();
            }
            catch (NamingException namingException) {
                if (debug) {
                    System.out.println(namingException);
                }
                if (debug) {
                    namingException.printStackTrace();
                }
            }
        } else {
            this.currentChild = null;
            return;
        }
        if (this.scope == 2 && this.currentChild.getObject() instanceof Context) {
            this.currentChildEnum = new ContextEnumerator((Context)this.currentChild.getObject(), this.scope, this.currentChild.getName(), false);
            this.currentChildExpanded = true;
            if (debug) {
                System.out.println("prepNextChild: expanded");
            }
        } else {
            this.currentChildExpanded = false;
            this.currentChildEnum = null;
            if (debug) {
                System.out.println("prepNextChild: normal");
            }
        }
    }
}

