/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigException;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileSourceHelper {
    private static final Logger LOGGER = Logger.getLogger(FileSourceHelper.class.getName());
    private static final int FILE_BUFFER_SIZE = 4096;

    private FileSourceHelper() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static Optional<Instant> lastModifiedTime(Path path) {
        try {
            return Optional.of(Files.getLastModifiedTime(path.toRealPath(new LinkOption[0]), new LinkOption[0]).toInstant());
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, e, () -> "Cannot obtain the last modified time of '" + path + "'.");
            Instant timestamp = Instant.MIN;
            LOGGER.finer("Cannot obtain the last modified time. Used time '" + timestamp + "' as a content timestamp.");
            return Optional.of(timestamp);
        }
    }

    /*
     * Exception decompiling
     */
    public static String safeReadContent(Path path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Optional<byte[]> digest(Path path) {
        Optional<byte[]> optional;
        MessageDigest digest = FileSourceHelper.digest();
        DigestInputStream dis = new DigestInputStream(Files.newInputStream(path, new OpenOption[0]), digest);
        try {
            byte[] buffer = new byte[4096];
            while (dis.read(buffer) != -1) {
            }
            optional = Optional.of(digest.digest());
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return Optional.empty();
            }
            catch (IOException e) {
                throw new ConfigException("Failed to calculate digest for file: " + path, e);
            }
        }
        dis.close();
        return optional;
    }

    public static boolean isModified(Path filePath, byte[] digest) {
        return FileSourceHelper.digest(filePath).map(newDigest -> Arrays.equals(digest, newDigest)).orElse(false) == false;
    }

    public static boolean isModified(Path filePath, Instant stamp) {
        return FileSourceHelper.lastModifiedTime(filePath).map(newStamp -> newStamp.isAfter(stamp)).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<DataAndDigest> readDataAndDigest(Path filePath) {
        ByteArrayOutputStream baos = FileSourceHelper.createByteArrayOutput(filePath);
        MessageDigest md = FileSourceHelper.digest();
        try (FileInputStream fis = new FileInputStream(filePath.toFile());){
            FileLock lock = FileSourceHelper.lockFile(filePath, fis);
            try (DigestInputStream dis = new DigestInputStream(fis, md);){
                int len;
                byte[] buffer = new byte[4096];
                while ((len = dis.read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new ConfigException(String.format("Cannot handle file '%s'.", filePath), e);
        }
        return Optional.of(new DataAndDigest(baos.toByteArray(), md.digest()));
    }

    private static ByteArrayOutputStream createByteArrayOutput(Path filePath) {
        try {
            return new ByteArrayOutputStream((int)Files.size(filePath));
        }
        catch (IOException e) {
            return new ByteArrayOutputStream(4096);
        }
    }

    private static FileLock lockFile(Path filePath, FileInputStream fis) throws IOException {
        try {
            FileLock lock = fis.getChannel().tryLock(0L, Long.MAX_VALUE, false);
            if (null == lock) {
                throw new ConfigException("Failed to acquire a lock on configuration file " + filePath + ", cannot safely read it");
            }
            return lock;
        }
        catch (NonWritableChannelException e) {
            return null;
        }
    }

    private static MessageDigest digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigException("Cannot get MD5 digest algorithm.", e);
        }
    }

    public static final class DataAndDigest {
        private final byte[] data;
        private final byte[] digest;

        private DataAndDigest(byte[] data, byte[] digest) {
            this.data = data;
            this.digest = digest;
        }

        public byte[] data() {
            byte[] result = new byte[this.data.length];
            System.arraycopy(this.data, 0, result, 0, this.data.length);
            return result;
        }

        public byte[] digest() {
            byte[] result = new byte[this.digest.length];
            System.arraycopy(this.digest, 0, result, 0, this.digest.length);
            return result;
        }
    }
}

