/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.FlashlightLoggerInfo;
import org.glassfish.flashlight.impl.client.AgentAttacherInternal;

public final class AgentAttacher {
    private static final String AGENT_CLASSNAME = "org.glassfish.flashlight.agent.ProbeAgentMain";
    private static final Logger logger = FlashlightLoggerInfo.getLogger();
    private static final boolean canAttach;

    public static Optional<Instrumentation> getInstrumentation() {
        try {
            Class<?> agentMainClass = null;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            try {
                agentMainClass = classLoader.loadClass(AGENT_CLASSNAME);
            }
            catch (Throwable t) {
                AgentAttacher.attachAgent();
                agentMainClass = classLoader.loadClass(AGENT_CLASSNAME);
            }
            Method mthd = agentMainClass.getMethod("getInstrumentation", null);
            return Optional.ofNullable((Instrumentation)mthd.invoke(null, null));
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Error while getting Instrumentation object from ProbeAgentMain", throwable);
            return Optional.empty();
        }
    }

    public static synchronized boolean canAttach() {
        return canAttach;
    }

    public static synchronized boolean isAttached() {
        try {
            if (!canAttach) {
                return false;
            }
            return AgentAttacherInternal.isAttached();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static synchronized boolean attachAgent() {
        try {
            if (!canAttach) {
                return false;
            }
            return AgentAttacher.attachAgent(-1, "");
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static synchronized boolean attachAgent(int pid, String options) {
        try {
            if (!canAttach) {
                return false;
            }
            return AgentAttacherInternal.attachAgent(pid, options);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        boolean b = false;
        try {
            AgentAttacherInternal.isAttached();
            b = true;
        }
        catch (Throwable t) {
            b = false;
        }
        canAttach = b;
    }
}

