/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.initfacescontext.NoOpELContext;
import com.sun.faces.config.initfacescontext.NoOpFacesContext;
import com.sun.faces.config.initfacescontext.ServletContextAdapter;
import com.sun.faces.context.ApplicationMap;
import com.sun.faces.context.ExceptionHandlerImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.el.ELContext;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InitFacesContext
extends NoOpFacesContext {
    private static Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String INIT_FACES_CONTEXT_ATTR_NAME = "com.sun.faces.InitFacesContext";
    private ServletContextAdapter servletContextAdapter;
    private UIViewRoot viewRoot;
    private Map<Object, Object> attributes;
    private ELContext elContext = new NoOpELContext();
    private ExceptionHandler exceptionHandler;

    public InitFacesContext(ServletContext servletContext) {
        this.servletContextAdapter = new ServletContextAdapter(servletContext);
        servletContext.setAttribute(INIT_FACES_CONTEXT_ATTR_NAME, (Object)this);
        InitFacesContext.cleanupInitMaps(servletContext);
        this.addServletContextEntryForInitContext(servletContext);
        this.addInitContextEntryForCurrentThread();
    }

    @Override
    public Map<Object, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>();
        }
        return this.attributes;
    }

    @Override
    public ExternalContext getExternalContext() {
        return this.servletContextAdapter;
    }

    @Override
    public UIViewRoot getViewRoot() {
        if (this.viewRoot == null) {
            this.viewRoot = new UIViewRoot();
            this.viewRoot.setLocale(Locale.getDefault());
            this.viewRoot.setViewId("com.sun.faces.xhtml");
        }
        return this.viewRoot;
    }

    @Override
    public ELContext getELContext() {
        return this.elContext;
    }

    public void setELContext(ELContext elContext) {
        this.elContext = elContext;
    }

    @Override
    public Application getApplication() {
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory("jakarta.faces.application.ApplicationFactory");
        return factory.getApplication();
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new ExceptionHandlerImpl(false);
        }
        return this.exceptionHandler;
    }

    @Override
    public boolean isProjectStage(ProjectStage stage) {
        if (stage == null) {
            throw new NullPointerException();
        }
        return stage.equals((Object)this.getApplication().getProjectStage());
    }

    @Override
    public void release() {
        InitFacesContext.setCurrentInstance(null);
        if (this.servletContextAdapter != null) {
            Map<String, Object> applicationMap = this.servletContextAdapter.getApplicationMap();
            if (applicationMap instanceof ApplicationMap && ((ApplicationMap)applicationMap).getContext() != null) {
                applicationMap.remove(INIT_FACES_CONTEXT_ATTR_NAME);
            }
            this.servletContextAdapter.release();
        }
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
        this.elContext = null;
        if (this.viewRoot != null) {
            Map<String, Object> viewMap = this.viewRoot.getViewMap(false);
            if (viewMap != null) {
                viewMap.clear();
            }
            this.viewRoot = null;
        }
    }

    public void releaseCurrentInstance() {
        this.removeInitContextEntryForCurrentThread();
        InitFacesContext.setCurrentInstance(null);
    }

    public void addInitContextEntryForCurrentThread() {
        InitFacesContext.getThreadInitContextMap().put(Thread.currentThread(), this);
    }

    public void removeInitContextEntryForCurrentThread() {
        InitFacesContext.getThreadInitContextMap().remove(Thread.currentThread());
    }

    public void addServletContextEntryForInitContext(ServletContext servletContext) {
        InitFacesContext.getInitContextServletContextMap().put(this, servletContext);
    }

    public void removeServletContextEntryForInitContext() {
        InitFacesContext.getInitContextServletContextMap().remove(this);
    }

    public static void cleanupInitMaps(ServletContext servletContext) {
        Map<InitFacesContext, ServletContext> facesContext2ServletContext = InitFacesContext.getInitContextServletContextMap();
        Map<Thread, InitFacesContext> thread2FacesContext = InitFacesContext.getThreadInitContextMap();
        for (Map.Entry<InitFacesContext, ServletContext> facesContext2ServletContextEntry : new ArrayList<Map.Entry<InitFacesContext, ServletContext>>(facesContext2ServletContext.entrySet())) {
            if (facesContext2ServletContextEntry.getValue() != servletContext) continue;
            facesContext2ServletContext.remove(facesContext2ServletContextEntry.getKey());
            for (Map.Entry<Thread, InitFacesContext> thread2FacesContextEntry : new ArrayList<Map.Entry<Thread, InitFacesContext>>(thread2FacesContext.entrySet())) {
                if (thread2FacesContextEntry.getValue() != facesContext2ServletContextEntry.getKey()) continue;
                thread2FacesContext.remove(thread2FacesContextEntry.getKey());
            }
        }
    }

    static Map<Thread, InitFacesContext> getThreadInitContextMap() {
        try {
            Field threadMap = FacesContext.class.getDeclaredField("threadInitContext");
            threadMap.setAccessible(true);
            return (Map)threadMap.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.log(Level.FINEST, "Unable to get (thread, init context) map", e);
            return null;
        }
    }

    static Map<InitFacesContext, ServletContext> getInitContextServletContextMap() {
        try {
            Field initContextMap = FacesContext.class.getDeclaredField("initContextServletContext");
            initContextMap.setAccessible(true);
            return (Map)initContextMap.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.log(Level.FINEST, "Unable to get (init context, servlet context) map", e);
            return null;
        }
    }

    public static InitFacesContext getInstance(ServletContext servletContext) {
        InitFacesContext result = (InitFacesContext)servletContext.getAttribute(INIT_FACES_CONTEXT_ATTR_NAME);
        if (result != null) {
            result.addInitContextEntryForCurrentThread();
        }
        return result;
    }

    public void reInitializeExternalContext(ServletContext sc) {
        assert (Util.isUnitTestModeEnabled());
        this.servletContextAdapter = new ServletContextAdapter(sc);
    }
}

