/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.ws.api.wsdl.TWSDLExtension;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.GeneratorExtension;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.model.Fault;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.processor.model.java.JavaMethod;
import com.sun.tools.ws.processor.model.java.JavaParameter;
import com.sun.tools.ws.processor.model.jaxb.JAXBTypeAndAnnotation;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.document.Binding;
import com.sun.tools.ws.wsdl.document.Definitions;
import com.sun.tools.ws.wsdl.document.Operation;
import com.sun.tools.ws.wsdl.document.soap.SOAP12Binding;
import com.sun.tools.ws.wsdl.document.soap.SOAPBinding;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.util.ServiceFinder;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import jakarta.xml.ws.Holder;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;

public final class JwsImplGenerator
extends GeneratorBase {
    private static final Map<String, String> TRANSLATION_MAP = new HashMap<String, String>(1);
    private final List<String> implFiles = new ArrayList<String>();

    public static List<String> generate(Model model, WsimportOptions options, ErrorReceiver receiver) {
        if (options.implDestDir == null) {
            return null;
        }
        JwsImplGenerator jwsImplGenerator = new JwsImplGenerator();
        jwsImplGenerator.init(model, options, receiver);
        jwsImplGenerator.doGeneration();
        if (jwsImplGenerator.implFiles.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            if (options.implServiceName != null) {
                msg.append("serviceName=[").append(options.implServiceName).append("] ");
            }
            if (options.implPortName != null) {
                msg.append("portName=[").append(options.implPortName).append("] ");
            }
            if (msg.length() > 0) {
                msg.append(", Not found in wsdl file.\n");
            }
            msg.append("No impl files generated!");
            receiver.warning(null, msg.toString());
        }
        return jwsImplGenerator.implFiles;
    }

    public static boolean moveToImplDestDir(List<String> gImplFiles, WsimportOptions options, ErrorReceiver receiver) {
        if (options.implDestDir == null || gImplFiles == null || gImplFiles.isEmpty()) {
            return true;
        }
        List<ImplFile> generatedImplFiles = ImplFile.toImplFiles(gImplFiles);
        try {
            File implDestDir = JwsImplGenerator.makePackageDir(options);
            for (ImplFile implF : generatedImplFiles) {
                File movedF = JwsImplGenerator.findFile(options, implF.qualifiedName);
                if (movedF == null) {
                    receiver.warning(null, "Class " + implF.qualifiedName + " is not generated. Not moving.");
                    return false;
                }
                File f = new File(implDestDir, implF.name);
                if (movedF.equals(f)) continue;
                if (f.exists() && !f.delete()) {
                    receiver.error("Class " + implF.qualifiedName + " has existed in destImplDir, and it can not be written!", null);
                }
                if (movedF.renameTo(f)) continue;
                throw new Exception();
            }
        }
        catch (Exception e) {
            receiver.error("Moving WebService Impl files failed!", e);
            return false;
        }
        return true;
    }

    private JwsImplGenerator() {
        this.donotOverride = true;
    }

    @Override
    public void visit(Service service) {
        QName serviceName = service.getName();
        if (this.options.implServiceName != null && !JwsImplGenerator.equalsNSOptional(this.options.implServiceName, serviceName)) {
            return;
        }
        for (Port port : service.getPorts()) {
            if (port.isProvider()) continue;
            QName portName = port.getName();
            if (this.options.implPortName != null && !JwsImplGenerator.equalsNSOptional(this.options.implPortName, portName)) continue;
            String simpleClassName = serviceName.getLocalPart() + "_" + portName.getLocalPart() + "Impl";
            String className = this.makePackageQualified(simpleClassName);
            this.implFiles.add(className);
            if (this.donotOverride && GeneratorUtil.classExists(this.options, className)) {
                this.log("Class " + className + " exists. Not overriding.");
                return;
            }
            JDefinedClass cls = null;
            try {
                cls = this.getClass(className, ClassType.CLASS);
            }
            catch (JClassAlreadyExistsException e) {
                this.log("Class " + className + " generates failed. JClassAlreadyExistsException[" + className + "].");
                return;
            }
            JavaInterface portIntf = port.getJavaInterface();
            String portClassName = Names.customJavaTypeClassName(portIntf);
            JDefinedClass portCls = null;
            try {
                portCls = this.getClass(portClassName, ClassType.INTERFACE);
            }
            catch (JClassAlreadyExistsException e) {
                this.log("Class " + className + " generates failed. JClassAlreadyExistsException[" + portClassName + "].");
                return;
            }
            cls._implements((JClass)portCls);
            cls.constructor(1);
            JDocComment comment = cls.javadoc();
            if (service.getJavaDoc() != null) {
                comment.add((Object)service.getJavaDoc());
                comment.add((Object)"\n\n");
            }
            comment.addAll(this.getJAXWSClassComment());
            JAnnotationUse webServiceAnn = cls.annotate(this.cm.ref(WebService.class));
            this.writeWebServiceAnnotation(service, port, webServiceAnn);
            JAnnotationUse bindingTypeAnn = cls.annotate(this.cm.ref(BindingType.class));
            this.writeBindingTypeAnnotation(port, bindingTypeAnn);
            for (GeneratorExtension f : JwsImplGenerator.findService(GeneratorExtension.class)) {
                f.writeWebServiceAnnotation(this.model, this.cm, cls, port);
            }
            for (com.sun.tools.ws.processor.model.Operation operation : port.getOperations()) {
                JDocComment methodDoc;
                JMethod m;
                JavaMethod method = operation.getJavaMethod();
                String methodJavaDoc = operation.getJavaDoc();
                if (method.getReturnType().getName().equals("void")) {
                    m = cls.method(1, Void.TYPE, method.getName());
                    methodDoc = m.javadoc();
                } else {
                    JAXBTypeAndAnnotation retType = method.getReturnType().getType();
                    m = cls.method(1, retType.getType(), method.getName());
                    retType.annotate((JAnnotatable)m);
                    methodDoc = m.javadoc();
                    JCommentPart ret = methodDoc.addReturn();
                    ret.add((Object)("returns " + retType.getName()));
                }
                if (methodJavaDoc != null) {
                    methodDoc.add((Object)methodJavaDoc);
                }
                JClass holder = this.cm.ref(Holder.class);
                for (JavaParameter parameter : method.getParametersList()) {
                    JAXBTypeAndAnnotation paramType = parameter.getType().getType();
                    JVar var = parameter.isHolder() ? m.param((JType)holder.narrow(paramType.getType().boxify()), parameter.getName()) : m.param(paramType.getType(), parameter.getName());
                    methodDoc.addParam(var);
                }
                Operation wsdlOp = operation.getWSDLPortTypeOperation();
                for (Fault fault : operation.getFaultsSet()) {
                    m._throws(fault.getExceptionClass());
                    methodDoc.addThrows(fault.getExceptionClass());
                    wsdlOp.putFault(fault.getWsdlFaultName(), fault.getExceptionClass());
                }
                m.body().block().directStatement("//replace with your impl here");
                m.body().block().directStatement(this.getReturnString(method.getReturnType().getName()));
            }
        }
    }

    private String getReturnString(String type) {
        String nullReturnStr = "return null;";
        if (type.indexOf(46) > -1 || type.indexOf(91) > -1) {
            return "return null;";
        }
        if (type.equals("void")) {
            return "return;";
        }
        if (type.equals("boolean")) {
            return "return false;";
        }
        if (type.equals("int") || type.equals("byte") || type.equals("short") || type.equals("long") || type.equals("double") || type.equals("float")) {
            return "return 0;";
        }
        if (type.equals("char")) {
            return "return '0';";
        }
        return "return null;";
    }

    private void writeWebServiceAnnotation(Service service, Port port, JAnnotationUse webServiceAnn) {
        webServiceAnn.param("portName", port.getName().getLocalPart());
        webServiceAnn.param("serviceName", service.getName().getLocalPart());
        webServiceAnn.param("targetNamespace", service.getName().getNamespaceURI());
        webServiceAnn.param("wsdlLocation", this.wsdlLocation);
        webServiceAnn.param("endpointInterface", port.getJavaInterface().getName());
    }

    private String transToValidJavaIdentifier(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuilder retSB = new StringBuilder();
        if (len == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            retSB.append("J");
        } else {
            retSB.append(s.charAt(0));
        }
        for (int i = 1; i < len; ++i) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) continue;
            retSB.append(s.charAt(i));
        }
        return retSB.toString();
    }

    private String makePackageQualified(String s) {
        s = this.transToValidJavaIdentifier(s);
        if (this.options.defaultPackage != null && !this.options.defaultPackage.isEmpty()) {
            return this.options.defaultPackage + "." + s;
        }
        return s;
    }

    private void writeBindingTypeAnnotation(Port port, JAnnotationUse bindingTypeAnn) {
        QName bName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLBindingName");
        if (bName == null) {
            return;
        }
        String v = this.getBindingType(bName);
        if (v != null) {
            bindingTypeAnn.param("value", v);
        }
    }

    private String resolveBindingValue(TWSDLExtension wsdlext) {
        if (wsdlext.getClass().equals(SOAPBinding.class)) {
            SOAPBinding sb = (SOAPBinding)wsdlext;
            if ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(sb.getTransport())) {
                return "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true";
            }
            for (GeneratorExtension f : JwsImplGenerator.findService(GeneratorExtension.class)) {
                String bindingValue = f.getBindingValue(sb.getTransport(), SOAPVersion.SOAP_11);
                if (bindingValue == null) continue;
                return bindingValue;
            }
            return "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if (wsdlext.getClass().equals(SOAP12Binding.class)) {
            SOAP12Binding sb = (SOAP12Binding)wsdlext;
            if ("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(sb.getTransport())) {
                return "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true";
            }
            for (GeneratorExtension f : JwsImplGenerator.findService(GeneratorExtension.class)) {
                String bindingValue = f.getBindingValue(sb.getTransport(), SOAPVersion.SOAP_12);
                if (bindingValue == null) continue;
                return bindingValue;
            }
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        return null;
    }

    private String getBindingType(QName bName) {
        String value;
        block4: {
            TWSDLExtension wsdlext;
            Binding b;
            Iterator<Binding> bindings;
            Definitions definitions;
            value = null;
            if (this.model.getEntity() instanceof Definitions && (definitions = (Definitions)this.model.getEntity()) != null && (bindings = definitions.bindings()) != null) {
                while (bindings.hasNext()) {
                    TWSDLExtension wsdlext2;
                    Binding binding = bindings.next();
                    if (!bName.getLocalPart().equals(binding.getName()) || !bName.getNamespaceURI().equals(binding.getNamespaceURI())) continue;
                    List bindextends = (List)binding.extensions();
                    Iterator iterator = bindextends.iterator();
                    while (iterator.hasNext() && (value = this.resolveBindingValue(wsdlext2 = (TWSDLExtension)iterator.next())) == null) {
                    }
                    break;
                }
            }
            if (value != null || !(this.model.getEntity() instanceof Definitions) || (b = (Binding)(definitions = (Definitions)this.model.getEntity()).resolveBindings().get(bName)) == null) break block4;
            List bindextends = (List)b.extensions();
            Iterator iterator = bindextends.iterator();
            while (iterator.hasNext() && (value = this.resolveBindingValue(wsdlext = (TWSDLExtension)iterator.next())) == null) {
            }
        }
        return value;
    }

    private static File makePackageDir(WsimportOptions options) {
        File ret = null;
        if (options.defaultPackage != null && !options.defaultPackage.isEmpty()) {
            String subDir = options.defaultPackage.replace('.', '/');
            ret = new File(options.implDestDir, subDir);
        } else {
            ret = options.implDestDir;
        }
        boolean created = ret.mkdirs();
        if (options.verbose && !created) {
            System.out.println(MessageFormat.format("Directory not created: {0}", ret));
        }
        return ret;
    }

    private static String getQualifiedFileName(String canonicalBaseDir, File f) throws IOException {
        String fp = f.getCanonicalPath();
        fp = fp.replace(canonicalBaseDir, "");
        fp = fp.replace('\\', '.');
        if ((fp = fp.replace('/', '.')).startsWith(".")) {
            fp = fp.substring(1);
        }
        return fp;
    }

    private static File findFile(WsimportOptions options, String qualifiedFileName) throws IOException {
        String baseDir = options.sourceDir.getCanonicalPath();
        String fp = null;
        for (File f : options.getGeneratedFiles()) {
            fp = JwsImplGenerator.getQualifiedFileName(baseDir, f);
            if (!qualifiedFileName.equals(fp)) continue;
            return f;
        }
        return null;
    }

    private static boolean equalsNSOptional(String strQName, QName checkQN) {
        if (strQName == null) {
            return false;
        }
        QName reqQN = QName.valueOf(strQName = strQName.trim());
        if (reqQN.getNamespaceURI() == null || reqQN.getNamespaceURI().isEmpty()) {
            return reqQN.getLocalPart().equals(checkQN.getLocalPart());
        }
        return reqQN.equals(checkQN);
    }

    private static <S> ServiceFinder<S> findService(Class<S> type) {
        return ServiceFinder.find(type, ServiceLoader.load(type));
    }

    static {
        TRANSLATION_MAP.put("http://schemas.xmlsoap.org/soap/http", "http://schemas.xmlsoap.org/wsdl/soap/http");
    }

    static final class ImplFile {
        public String qualifiedName;
        public String name;

        private ImplFile(String qualifiedClassName) {
            this.qualifiedName = qualifiedClassName + ".java";
            String simpleClassName = qualifiedClassName;
            int i = qualifiedClassName.lastIndexOf(".");
            if (i != -1) {
                simpleClassName = qualifiedClassName.substring(i + 1);
            }
            this.name = simpleClassName + ".java";
        }

        public static List<ImplFile> toImplFiles(List<String> qualifiedClassNames) {
            ArrayList<ImplFile> ret = new ArrayList<ImplFile>();
            for (String qualifiedClassName : qualifiedClassNames) {
                ret.add(new ImplFile(qualifiedClassName));
            }
            return ret;
        }
    }
}

