/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.optionalelresolver;

import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.MethodNotFoundException;
import jakarta.el.OptionalELResolver;
import jakarta.el.PropertyNotWritableException;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void optionalELResolverEmptyNullTest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        Optional testObject = Optional.empty();
        pass = ELClientIT.testOptionalELResolverProperty(buf, testObject, null, null);
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void optionalELResolverEmptyNonNullTest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        Optional testObject = Optional.empty();
        pass = ELClientIT.testOptionalELResolverProperty(buf, testObject, "property", null);
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void optionalELResolverObjectNullTest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        TestBean testBean = new TestBean("data");
        Optional<TestBean> testObject = Optional.of(testBean);
        pass = ELClientIT.testOptionalELResolverProperty(buf, testObject, null, testBean);
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void optionalELResolverObjectNonNullTest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        TestBean testBean = new TestBean("data");
        Optional<TestBean> testObject = Optional.of(testBean);
        pass = ELClientIT.testOptionalELResolverProperty(buf, testObject, "propertyA", "data");
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    public static boolean testOptionalELResolverProperty(StringBuffer buf, Object base, Object property, Object expectedValue) {
        boolean pass = true;
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELResolver resolver = barebonesContext.getELResolver();
        BeanELResolver beanResolver = new BeanELResolver();
        OptionalELResolver optionalResolver = new OptionalELResolver();
        ((CompositeELResolver)resolver).add((ELResolver)optionalResolver);
        ((CompositeELResolver)resolver).add((ELResolver)beanResolver);
        ELContext context = barebonesContext.getELContext();
        Object result = resolver.getValue(context, base, property);
        if (expectedValue == null && result != null || expectedValue != null && !expectedValue.equals(result)) {
            buf.append("getValue(): Expected [" + String.valueOf(expectedValue) + "] but got [" + String.valueOf(result) + "]");
            pass = false;
        }
        if ((result = resolver.getType(context, base, property)) != null) {
            pass = false;
        }
        try {
            resolver.setValue(context, base, property, (Object)"anything");
            pass = false;
        }
        catch (PropertyNotWritableException propertyNotWritableException) {
            // empty catch block
        }
        boolean bResult = resolver.isReadOnly(context, base, property);
        if (!bResult) {
            pass = false;
        }
        if ((result = resolver.getCommonPropertyType(context, base)) != Object.class) {
            pass = false;
        }
        return pass;
    }

    @Test
    public void optionalELResolverEmptyInvoke() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        Optional testObject = Optional.empty();
        pass = ELClientIT.testOptionalELResolverInvoke(buf, testObject, "doSomething", null);
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void optionalELResolverEmptyInvokeInvalid() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        Optional testObject = Optional.empty();
        pass = ELClientIT.testOptionalELResolverInvoke(buf, testObject, "unknownMethod", null);
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void optionalELResolverObjectInvoke() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        TestBean testBean = new TestBean("data");
        Optional<TestBean> testObject = Optional.of(testBean);
        pass = ELClientIT.testOptionalELResolverInvoke(buf, testObject, "doSomething", "interesting data");
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void optionalELResolverObjectInvokeInvalid() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        TestBean testBean = new TestBean("data");
        Optional<TestBean> testObject = Optional.of(testBean);
        try {
            ELClientIT.testOptionalELResolverInvoke(buf, testObject, "unknownMethod", null);
            pass = false;
            buf.append("invoke(): Expected MethodNotFoundException but no exception was thrown");
        }
        catch (MethodNotFoundException methodNotFoundException) {
            // empty catch block
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    public static boolean testOptionalELResolverInvoke(StringBuffer buf, Object base, Object method, Object expectedValue) {
        boolean pass = true;
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELResolver resolver = barebonesContext.getELResolver();
        BeanELResolver beanResolver = new BeanELResolver();
        OptionalELResolver optionalResolver = new OptionalELResolver();
        ((CompositeELResolver)resolver).add((ELResolver)optionalResolver);
        ((CompositeELResolver)resolver).add((ELResolver)beanResolver);
        ELContext context = barebonesContext.getELContext();
        Object result = resolver.invoke(context, base, method, null, null);
        if (expectedValue == null && result != null || expectedValue != null && !expectedValue.equals(result)) {
            buf.append("invoke(): Expected [" + String.valueOf(expectedValue) + "] but got [" + String.valueOf(result) + "]");
            pass = false;
        }
        return pass;
    }

    public static class TestBean {
        private static final String DATA = "interesting data";
        private final String propertyA;

        public TestBean(String propertyA) {
            this.propertyA = propertyA;
        }

        public String getPropertyA() {
            return this.propertyA;
        }

        public String doSomething() {
            return DATA;
        }
    }
}

