/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks.restadapter;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.restadapter.RESTGeneratorsUtility;
import org.eclipse.comma.project.generatortasks.restadapter.RESTServiceConfig;
import org.eclipse.comma.project.project.FixedSegment;
import org.eclipse.comma.project.project.ParameterSegment;
import org.eclipse.comma.project.project.Path;
import org.eclipse.comma.project.project.RESTOperation;
import org.eclipse.comma.project.project.Segment;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.types.Type;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RequiredPortApiGenerator {
    public static void generate(CommaFileSystemAccess fsa, RESTServiceConfig config) {
        fsa.generateFile(RequiredPortApiGenerator.fileName(config), RequiredPortApiGenerator.classContent(config));
    }

    public static String fileName(RESTServiceConfig config) {
        String _apiName = ProjectUtility.getApiName(config.restTask);
        return String.valueOf(_apiName) + "Api.java";
    }

    public static CharSequence classContent(RESTServiceConfig config) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package org.eclipse.comma.restadapter;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import javax.ws.rs.GET;");
        _builder.newLine();
        _builder.append("import javax.ws.rs.PUT;");
        _builder.newLine();
        _builder.append("import javax.ws.rs.Path;");
        _builder.newLine();
        _builder.append("import javax.ws.rs.PathParam;");
        _builder.newLine();
        _builder.append("import javax.ws.rs.Produces;");
        _builder.newLine();
        _builder.append("import javax.ws.rs.Consumes;");
        _builder.newLine();
        _builder.append("import javax.ws.rs.core.Response;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@Path(\"/\")");
        _builder.newLine();
        _builder.append("public class ");
        String _apiName = ProjectUtility.getApiName(config.restTask);
        _builder.append(_apiName);
        _builder.append("Api {");
        _builder.newLineIfNotEmpty();
        for (Port port : config.ports) {
            _builder.append("    ");
            Signature sig = port.getInterface();
            _builder.newLineIfNotEmpty();
            EList _commands = sig.getCommands();
            for (Command command : _commands) {
                boolean _greaterThan;
                boolean _not;
                _builder.append("    ");
                _builder.newLine();
                _builder.append("    ");
                RESTOperation restCommand = ProjectUtility.getEventRESTMapping((InterfaceEvent)command, config.pathMappings);
                _builder.newLineIfNotEmpty();
                boolean _equals = Objects.equal((Object)((Object)restCommand), (Object)((Object)RESTOperation.GET));
                if (_equals) {
                    _builder.append("    ");
                    _builder.append("@GET");
                    _builder.newLine();
                } else {
                    _builder.append("    ");
                    _builder.append("@PUT");
                    _builder.newLine();
                }
                _builder.append("    ");
                Path path = ProjectUtility.getPath(config.pathMappings, sig, (InterfaceEvent)command);
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("@Path(\"");
                EList<Segment> _segments = path.getSegments();
                for (Segment s : _segments) {
                    _builder.append("/");
                    if (s instanceof FixedSegment) {
                        String _name = ((FixedSegment)s).getName();
                        _builder.append(_name, "    ");
                        continue;
                    }
                    _builder.append("{");
                    String _name_1 = ((ParameterSegment)s).getParameter().getName();
                    _builder.append(_name_1, "    ");
                    _builder.append("}");
                }
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("@Produces({ \"application/json\" })");
                _builder.newLine();
                boolean _equals_1 = Objects.equal((Object)((Object)restCommand), (Object)((Object)RESTOperation.PUT));
                if (_equals_1) {
                    _builder.append("    ");
                    _builder.append("@Consumes({ \"application/json\" })");
                    _builder.newLine();
                }
                _builder.append("    ");
                String _xifexpression = null;
                boolean _equals_2 = Objects.equal((Object)((Object)restCommand), (Object)((Object)RESTOperation.GET));
                _xifexpression = _equals_2 ? "Get" : "Put";
                String suffix = _xifexpression;
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(config.pathMappings, (InterfaceEvent)command);
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                List<Parameter> nonPathParameters = ProjectUtility.getNonPathParameters(config.pathMappings, (InterfaceEvent)command);
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("public Response ");
                String _name_2 = command.getName();
                _builder.append(_name_2, "    ");
                _builder.append(suffix, "    ");
                _builder.append("(");
                boolean _hasElements = false;
                for (Parameter p : pathParameters) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "    ");
                    }
                    _builder.append("@PathParam(\"");
                    String _name_3 = p.getName();
                    _builder.append(_name_3, "    ");
                    _builder.append("\") String ");
                    String _name_4 = p.getName();
                    _builder.append(_name_4, "    ");
                }
                boolean _isEmpty = nonPathParameters.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.append(", String params");
                }
                _builder.append(") throws InterruptedException {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("Event event = new Event(\"Command\", \"");
                String _name_5 = sig.getName();
                _builder.append(_name_5, "        ");
                _builder.append("\", \"");
                String _name_6 = command.getName();
                _builder.append(_name_6, "        ");
                _builder.append("\", \"");
                String _name_7 = port.getName();
                _builder.append(_name_7, "        ");
                _builder.append("\", \"c\");");
                _builder.newLineIfNotEmpty();
                int _size = nonPathParameters.size();
                boolean bl2 = _greaterThan = _size > 1;
                if (_greaterThan) {
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("JsonObject paramsJson = JsonParser.parseString(params).getAsJsonObject();");
                    _builder.newLine();
                } else {
                    boolean _equals_3;
                    int _size_1 = nonPathParameters.size();
                    boolean bl3 = _equals_3 = _size_1 == 1;
                    if (_equals_3) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("JsonElement paramsJson = JsonParser.parseString(params);");
                        _builder.newLine();
                    }
                }
                Functions.Function1 _function = it -> {
                    DIRECTION _direction = it.getDirection();
                    return _direction != DIRECTION.OUT;
                };
                Iterable _filter = IterableExtensions.filter((Iterable)command.getParameters(), (Functions.Function1)_function);
                for (Parameter p_1 : _filter) {
                    boolean _contains = pathParameters.contains(p_1);
                    if (_contains) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("JsonObject ");
                        String _name_8 = p_1.getName();
                        _builder.append(_name_8, "        ");
                        _builder.append("Json = ");
                        Type _type = p_1.getType();
                        String _name_9 = p_1.getName();
                        String _plus = "new JsonPrimitive(" + _name_9;
                        String _plus_1 = String.valueOf(_plus) + ")";
                        Object _convertValueFromSUT = RESTGeneratorsUtility.convertValueFromSUT((EObject)_type, _plus_1);
                        _builder.append(_convertValueFromSUT, "        ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _greaterThan_1;
                        int _size_2 = nonPathParameters.size();
                        boolean bl4 = _greaterThan_1 = _size_2 > 1;
                        if (_greaterThan_1) {
                            _builder.append("    ");
                            _builder.append("    ");
                            _builder.append("JsonElement ");
                            String _name_10 = p_1.getName();
                            _builder.append(_name_10, "        ");
                            _builder.append("Unparsed = paramsJson.get(\"");
                            String _name_11 = p_1.getName();
                            _builder.append(_name_11, "        ");
                            _builder.append("\");");
                            _builder.newLineIfNotEmpty();
                            _builder.append("    ");
                            _builder.append("    ");
                            _builder.append("JsonObject ");
                            String _name_12 = p_1.getName();
                            _builder.append(_name_12, "        ");
                            _builder.append("Json = ");
                            Type _type_1 = p_1.getType();
                            String _name_13 = p_1.getName();
                            String _plus_2 = String.valueOf(_name_13) + "Unparsed";
                            Object _convertValueFromSUT_1 = RESTGeneratorsUtility.convertValueFromSUT((EObject)_type_1, _plus_2);
                            _builder.append(_convertValueFromSUT_1, "        ");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("    ");
                            _builder.append("    ");
                            _builder.append("JsonObject ");
                            String _name_14 = p_1.getName();
                            _builder.append(_name_14, "        ");
                            _builder.append("Json = ");
                            Object _convertValueFromSUT_2 = RESTGeneratorsUtility.convertValueFromSUT((EObject)p_1.getType(), "paramsJson");
                            _builder.append(_convertValueFromSUT_2, "        ");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("event.addParameter(");
                    String _name_15 = p_1.getName();
                    _builder.append(_name_15, "        ");
                    _builder.append("Json);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("System.out.println(event.toJson());");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("while(true) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("if(");
                String _name_16 = sig.getName();
                _builder.append(_name_16, "            ");
                _builder.append("Worker.result");
                String _name_17 = command.getName();
                _builder.append(_name_17, "            ");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("            ");
                _builder.append("String response = ");
                String _name_18 = sig.getName();
                _builder.append(_name_18, "                ");
                _builder.append("Worker.");
                String _apiName_1 = ProjectUtility.getApiName(config.restTask);
                _builder.append(_apiName_1, "                ");
                _builder.append("Results.get(\"");
                String _name_19 = command.getName();
                _builder.append(_name_19, "                ");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("            ");
                String _name_20 = sig.getName();
                _builder.append(_name_20, "                ");
                _builder.append("Worker.result");
                String _name_21 = command.getName();
                _builder.append(_name_21, "                ");
                _builder.append(" = false;");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("            ");
                _builder.append("return Response.status(");
                String _name_22 = sig.getName();
                _builder.append(_name_22, "                ");
                _builder.append("Worker.");
                String _apiName_2 = ProjectUtility.getApiName(config.restTask);
                _builder.append(_apiName_2, "                ");
                _builder.append("Responses.get(\"");
                String _name_23 = command.getName();
                _builder.append(_name_23, "                ");
                _builder.append("\")).entity(response).build();");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("} else {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("            ");
                _builder.append("Thread.sleep(50);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
            }
            EList _signals = sig.getSignals();
            for (Signal signal : _signals) {
                boolean _greaterThan_2;
                boolean _not_1;
                _builder.append("    ");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("@PUT");
                _builder.newLine();
                _builder.append("    ");
                Path path_1 = ProjectUtility.getPath(config.pathMappings, sig, (InterfaceEvent)signal);
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("@Path(\"");
                EList<Segment> _segments_1 = path_1.getSegments();
                for (Segment s_1 : _segments_1) {
                    _builder.append("/");
                    if (s_1 instanceof FixedSegment) {
                        String _name_24 = ((FixedSegment)s_1).getName();
                        _builder.append(_name_24, "    ");
                        continue;
                    }
                    _builder.append("{");
                    String _name_25 = ((ParameterSegment)s_1).getParameter().getName();
                    _builder.append(_name_25, "    ");
                    _builder.append("}");
                }
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("@Produces({ \"application/json\" })");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("@Consumes({ \"application/json\" })");
                _builder.newLine();
                _builder.append("    ");
                ArrayList<Parameter> pathParameters_1 = ProjectUtility.getPathParameters(config.pathMappings, (InterfaceEvent)signal);
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                List<Parameter> nonPathParameters_1 = ProjectUtility.getNonPathParameters(config.pathMappings, (InterfaceEvent)signal);
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("public Response ");
                String _name_26 = signal.getName();
                _builder.append(_name_26, "    ");
                _builder.append("Put(");
                boolean _hasElements_1 = false;
                for (Parameter p_2 : pathParameters_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "    ");
                    }
                    _builder.append("@PathParam(\"");
                    String _name_27 = p_2.getName();
                    _builder.append(_name_27, "    ");
                    _builder.append("\") String ");
                    String _name_28 = p_2.getName();
                    _builder.append(_name_28, "    ");
                }
                boolean _isEmpty_1 = nonPathParameters_1.isEmpty();
                boolean bl = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    _builder.append(", String params");
                }
                _builder.append(") throws InterruptedException {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("Event event = new Event(\"Command\", \"");
                String _name_29 = sig.getName();
                _builder.append(_name_29, "        ");
                _builder.append("\", \"");
                String _name_30 = signal.getName();
                _builder.append(_name_30, "        ");
                _builder.append("\", \"");
                String _name_31 = port.getName();
                _builder.append(_name_31, "        ");
                _builder.append("\", \"c\");");
                _builder.newLineIfNotEmpty();
                int _size_3 = nonPathParameters_1.size();
                boolean bl5 = _greaterThan_2 = _size_3 > 1;
                if (_greaterThan_2) {
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("JsonObject paramsJson = JsonParser.parseString(params).getAsJsonObject();");
                    _builder.newLine();
                } else {
                    boolean _equals_4;
                    int _size_4 = nonPathParameters_1.size();
                    boolean bl6 = _equals_4 = _size_4 == 1;
                    if (_equals_4) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("JsonElement paramsJson = JsonParser.parseString(params);");
                        _builder.newLine();
                    }
                }
                EList _parameters = signal.getParameters();
                for (Parameter p_3 : _parameters) {
                    boolean _contains_1 = pathParameters_1.contains(p_3);
                    if (_contains_1) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("JsonObject ");
                        String _name_32 = p_3.getName();
                        _builder.append(_name_32, "        ");
                        _builder.append("Json = ");
                        Type _type_2 = p_3.getType();
                        String _name_33 = p_3.getName();
                        String _plus_3 = "new JsonPrimitive(" + _name_33;
                        String _plus_4 = String.valueOf(_plus_3) + ")";
                        Object _convertValueFromSUT_3 = RESTGeneratorsUtility.convertValueFromSUT((EObject)_type_2, _plus_4);
                        _builder.append(_convertValueFromSUT_3, "        ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _greaterThan_3;
                        int _size_5 = nonPathParameters_1.size();
                        boolean bl7 = _greaterThan_3 = _size_5 > 1;
                        if (_greaterThan_3) {
                            _builder.append("    ");
                            _builder.append("    ");
                            _builder.append("JsonElement ");
                            String _name_34 = p_3.getName();
                            _builder.append(_name_34, "        ");
                            _builder.append("Unparsed = paramsJson.get(\"");
                            String _name_35 = p_3.getName();
                            _builder.append(_name_35, "        ");
                            _builder.append("\");");
                            _builder.newLineIfNotEmpty();
                            _builder.append("    ");
                            _builder.append("    ");
                            _builder.append("JsonObject ");
                            String _name_36 = p_3.getName();
                            _builder.append(_name_36, "        ");
                            _builder.append("Json = ");
                            Type _type_3 = p_3.getType();
                            String _name_37 = p_3.getName();
                            String _plus_5 = String.valueOf(_name_37) + "Unparsed";
                            Object _convertValueFromSUT_4 = RESTGeneratorsUtility.convertValueFromSUT((EObject)_type_3, _plus_5);
                            _builder.append(_convertValueFromSUT_4, "        ");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("    ");
                            _builder.append("    ");
                            _builder.append("JsonObject ");
                            String _name_38 = p_3.getName();
                            _builder.append(_name_38, "        ");
                            _builder.append("Json = ");
                            Object _convertValueFromSUT_5 = RESTGeneratorsUtility.convertValueFromSUT((EObject)p_3.getType(), "paramsJson");
                            _builder.append(_convertValueFromSUT_5, "        ");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("event.addParameter(");
                    String _name_39 = p_3.getName();
                    _builder.append(_name_39, "        ");
                    _builder.append("Json);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("System.out.println(event.toJson());");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("return Response.ok() .build();");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

