/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.bkd.PointReader;
import org.apache.lucene.util.bkd.PointValue;

public final class OfflinePointReader
implements PointReader {
    long countLeft;
    final IndexInput in;
    byte[] onHeapBuffer;
    int offset;
    final int bytesPerDoc;
    private boolean checked;
    private final int packedValueLength;
    private int pointsInBuffer;
    private final int maxPointOnHeap;
    final String name;
    private final OfflinePointValue pointValue;

    public OfflinePointReader(Directory tempDir, String tempFileName, int packedBytesLength, long start, long length, byte[] reusableBuffer) throws IOException {
        this.bytesPerDoc = packedBytesLength + 4;
        this.packedValueLength = packedBytesLength;
        if ((start + length) * (long)this.bytesPerDoc + (long)CodecUtil.footerLength() > tempDir.fileLength(tempFileName)) {
            throw new IllegalArgumentException("requested slice is beyond the length of this file: start=" + start + " length=" + length + " bytesPerDoc=" + this.bytesPerDoc + " fileLength=" + tempDir.fileLength(tempFileName) + " tempFileName=" + tempFileName);
        }
        if (reusableBuffer == null) {
            throw new IllegalArgumentException("[reusableBuffer] cannot be null");
        }
        if (reusableBuffer.length < this.bytesPerDoc) {
            throw new IllegalArgumentException("Length of [reusableBuffer] must be bigger than " + this.bytesPerDoc);
        }
        this.maxPointOnHeap = reusableBuffer.length / this.bytesPerDoc;
        this.in = start == 0L && length * (long)this.bytesPerDoc == tempDir.fileLength(tempFileName) - (long)CodecUtil.footerLength() ? tempDir.openChecksumInput(tempFileName, IOContext.READONCE) : tempDir.openInput(tempFileName, IOContext.READONCE);
        this.name = tempFileName;
        long seekFP = start * (long)this.bytesPerDoc;
        this.in.seek(seekFP);
        this.countLeft = length;
        this.onHeapBuffer = reusableBuffer;
        this.pointValue = new OfflinePointValue(this.onHeapBuffer, this.packedValueLength);
    }

    @Override
    public boolean next() throws IOException {
        if (this.pointsInBuffer == 0) {
            if (this.countLeft >= 0L && this.countLeft == 0L) {
                return false;
            }
            try {
                if (this.countLeft > (long)this.maxPointOnHeap) {
                    this.in.readBytes(this.onHeapBuffer, 0, this.maxPointOnHeap * this.bytesPerDoc);
                    this.pointsInBuffer = this.maxPointOnHeap - 1;
                    this.countLeft -= (long)this.maxPointOnHeap;
                } else {
                    this.in.readBytes(this.onHeapBuffer, 0, (int)this.countLeft * this.bytesPerDoc);
                    this.pointsInBuffer = Math.toIntExact(this.countLeft - 1L);
                    this.countLeft = 0L;
                }
                this.offset = 0;
            }
            catch (EOFException eofe) {
                assert (this.countLeft == -1L);
                return false;
            }
        } else {
            --this.pointsInBuffer;
            this.offset += this.bytesPerDoc;
        }
        return true;
    }

    @Override
    public PointValue pointValue() {
        this.pointValue.setOffset(this.offset);
        return this.pointValue;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.countLeft == 0L && this.in instanceof ChecksumIndexInput && !this.checked) {
                this.checked = true;
                CodecUtil.checkFooter((ChecksumIndexInput)this.in);
            }
        }
        finally {
            this.in.close();
        }
    }

    static class OfflinePointValue
    implements PointValue {
        final BytesRef packedValue;
        final BytesRef packedValueDocID;
        final int packedValueLength;

        OfflinePointValue(byte[] value, int packedValueLength) {
            this.packedValueLength = packedValueLength;
            this.packedValue = new BytesRef(value, 0, packedValueLength);
            this.packedValueDocID = new BytesRef(value, 0, packedValueLength + 4);
        }

        public void setOffset(int offset) {
            this.packedValue.offset = offset;
            this.packedValueDocID.offset = offset;
        }

        @Override
        public BytesRef packedValue() {
            return this.packedValue;
        }

        @Override
        public int docID() {
            int position = this.packedValueDocID.offset + this.packedValueLength;
            return (this.packedValueDocID.bytes[position] & 0xFF) << 24 | (this.packedValueDocID.bytes[++position] & 0xFF) << 16 | (this.packedValueDocID.bytes[++position] & 0xFF) << 8 | this.packedValueDocID.bytes[++position] & 0xFF;
        }

        @Override
        public BytesRef packedValueDocIDBytes() {
            return this.packedValueDocID;
        }
    }
}

