/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.IReadOnlyDependent;
import org.eclipse.xtext.ui.editor.embedded.TextViewerAction;

public class TextViewerShiftAction
extends TextViewerAction
implements IReadOnlyDependent {
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget = null;

    public TextViewerShiftAction(ResourceBundle bundle, String prefix, ITextViewer viewer, int operationCode) {
        super(bundle, prefix);
        this.setViewer(viewer);
        this.fOperationCode = operationCode;
        this.update();
    }

    public void run() {
        if (this.fOperationCode == -1 || this.fOperationTarget == null) {
            return;
        }
        ITextViewer viewer = this.getTextViewer();
        if (viewer == null) {
            return;
        }
        if (!this.canModifyViewer()) {
            return;
        }
        Display display = null;
        Shell shell = viewer.getTextWidget().getShell();
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                TextViewerShiftAction.this.fOperationTarget.doOperation(TextViewerShiftAction.this.fOperationCode);
            }
        });
    }

    @Override
    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        if (!this.canModifyViewer()) {
            this.setEnabled(false);
            return;
        }
        ITextViewer viewer = this.getTextViewer();
        if (this.fOperationTarget == null && viewer != null && this.fOperationCode != -1) {
            this.fOperationTarget = viewer.getTextOperationTarget();
        }
    }

    protected void updateForTab() {
        super.update();
        if (this.isEnabled()) {
            if (!this.canModifyViewer()) {
                this.setEnabled(false);
                return;
            }
            ITextViewer viewer = this.getTextViewer();
            if (this.fOperationTarget == null && viewer != null && this.fOperationCode != -1) {
                this.fOperationTarget = viewer.getTextOperationTarget();
            }
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
        }
    }

    @Override
    public void setViewer(ITextViewer viewer) {
        super.setViewer(viewer);
        this.fOperationTarget = null;
    }

    public boolean isEnabled(boolean isWritable) {
        if (!isWritable) {
            return false;
        }
        ITextViewer viewer = this.getTextViewer();
        if (this.fOperationTarget == null && viewer != null && this.fOperationCode != -1) {
            this.fOperationTarget = viewer.getTextOperationTarget();
        }
        return this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
    }
}

