/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Observable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.IHelpUIConstants;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.EngineDescriptor;
import org.eclipse.help.ui.internal.views.EngineTypeDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EngineDescriptorManager
extends Observable
implements IHelpUIConstants {
    private ArrayList<EngineDescriptor> descriptors = new ArrayList();
    private EngineTypeDescriptor[] engineTypes;
    private static final String USER_FILE = "userSearches.xml";
    private static final String ATT_ENGINE_TYPE_ID = "engineTypeId";

    public EngineDescriptorManager() {
        this.load();
    }

    public void add(EngineDescriptor desc) {
        this.descriptors.add(desc);
        this.setChanged();
        this.notifyObservers(new DescriptorEvent(desc, 1));
    }

    public void remove(EngineDescriptor desc) {
        this.descriptors.remove(desc);
        this.setChanged();
        this.notifyObservers(new DescriptorEvent(desc, 2));
    }

    public void notifyPropertyChange(EngineDescriptor desc) {
        this.setChanged();
        this.notifyObservers(new DescriptorEvent(desc, 3));
    }

    public EngineDescriptor[] getDescriptors() {
        return this.descriptors.toArray(new EngineDescriptor[this.descriptors.size()]);
    }

    public EngineDescriptor findEngine(String engineId) {
        int i = 0;
        while (i < this.descriptors.size()) {
            EngineDescriptor desc = this.descriptors.get(i);
            if (desc.getId().equals(engineId)) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    public EngineTypeDescriptor[] getEngineTypes() {
        return this.engineTypes;
    }

    public void save() {
        block25: {
            IPath stateLoc = HelpUIPlugin.getDefault().getStateLocation();
            String fileName = stateLoc.append(USER_FILE).toOSString();
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            try {
                try {
                    fos = new FileOutputStream(fileName);
                    osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                    PrintWriter writer = new PrintWriter(osw);
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    writer.println("<engines>");
                    int i = 0;
                    while (i < this.descriptors.size()) {
                        EngineDescriptor desc = this.descriptors.get(i);
                        if (desc.isUserDefined()) {
                            this.save(writer, desc);
                        }
                        ++i;
                    }
                    writer.println("</engines>");
                    writer.flush();
                }
                catch (IOException e) {
                    Platform.getLog(this.getClass()).error(Messages.EngineDescriptorManager_errorSaving, (Throwable)e);
                    if (osw != null) {
                        try {
                            osw.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (osw != null) {
                    try {
                        osw.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void load() {
        this.loadFromExtensionRegistry();
        IPath stateLoc = HelpUIPlugin.getDefault().getStateLocation();
        String fileName = stateLoc.append(USER_FILE).toOSString();
        try {
            this.load(fileName);
        }
        catch (IOException e) {
            Platform.getLog(this.getClass()).error(Messages.EngineDescriptorManager_errorLoading, (Throwable)e);
        }
    }

    private void loadFromExtensionRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.help.ui.searchEngine");
        Hashtable<String, EngineTypeDescriptor> engineTypes = this.loadEngineTypes(elements);
        int i = 0;
        while (i < elements.length) {
            EngineTypeDescriptor etdesc;
            EngineDescriptor desc;
            String engineId;
            IConfigurationElement element = elements[i];
            if (element.getName().equals("engine") && (engineId = (desc = new EngineDescriptor(element)).getEngineTypeId()) != null && (etdesc = engineTypes.get(engineId)) != null) {
                desc.setEngineType(etdesc);
                this.descriptors.add(desc);
            }
            ++i;
        }
    }

    private Hashtable<String, EngineTypeDescriptor> loadEngineTypes(IConfigurationElement[] elements) {
        Hashtable<String, EngineTypeDescriptor> result = new Hashtable<String, EngineTypeDescriptor>();
        ArrayList<EngineTypeDescriptor> list = new ArrayList<EngineTypeDescriptor>();
        int i = 0;
        while (i < elements.length) {
            EngineTypeDescriptor etdesc;
            String id;
            IConfigurationElement element = elements[i];
            if (element.getName().equals("engineType") && (id = (etdesc = new EngineTypeDescriptor(element)).getId()) != null) {
                list.add(etdesc);
                result.put(etdesc.getId(), etdesc);
            }
            ++i;
        }
        this.engineTypes = list.toArray(new EngineTypeDescriptor[list.size()]);
        return result;
    }

    public void load(Reader r) {
        Document document = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = parser.parse(new InputSource(r));
            Node root = document.getFirstChild();
            while (root.getNodeType() == 8) {
                document.removeChild(root);
                root = document.getFirstChild();
            }
            this.load(document, (Element)root);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    public void load(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        FileInputStream stream = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
        this.load(reader);
        reader.close();
    }

    private void load(Document doc, Element root) {
        NodeList engines = root.getElementsByTagName("engine");
        int i = 0;
        while (i < engines.getLength()) {
            Node node = engines.item(i);
            this.loadUserEntry(node);
            ++i;
        }
    }

    private void loadUserEntry(Node node) {
        EngineDescriptor edesc = new EngineDescriptor(this);
        String id = this.getAttribute(node, "id");
        String engineTypeId = this.getAttribute(node, ATT_ENGINE_TYPE_ID);
        EngineTypeDescriptor etdesc = this.findEngineType(engineTypeId);
        String label = this.getAttribute(node, "label");
        String desc = this.getDescription(node);
        if (etdesc == null) {
            return;
        }
        edesc.setEngineType(etdesc);
        edesc.setUserDefined(true);
        edesc.setId(id);
        edesc.setLabel(label);
        edesc.setDescription(desc);
        this.descriptors.add(edesc);
    }

    public String computeNewId(String typeId) {
        ArrayList<Integer> used = new ArrayList<Integer>();
        int i = 0;
        while (i < this.descriptors.size()) {
            String edId;
            int loc;
            String edTypeId;
            EngineDescriptor ed = this.descriptors.get(i);
            if (ed.isUserDefined() && typeId.equals(edTypeId = ed.getEngineTypeId()) && (loc = (edId = ed.getId()).lastIndexOf(46)) != -1) {
                String cvalue = edId.substring(loc + 1);
                int ivalue = Integer.parseInt(cvalue);
                used.add(ivalue);
            }
            ++i;
        }
        i = 1;
        while (i < Integer.MAX_VALUE) {
            if (!this.isUsed(i, used)) {
                return String.valueOf(typeId) + "." + "user." + i;
            }
            ++i;
        }
        return typeId;
    }

    private boolean isUsed(int value, ArrayList<Integer> used) {
        int i = 0;
        while (i < used.size()) {
            Integer iv = used.get(i);
            if (iv == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getDescription(Node node) {
        NodeList list = ((Element)node).getElementsByTagName("description");
        if (list.getLength() == 1) {
            Node desc = list.item(0);
            NodeList children = desc.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 3) {
                    String text = child.getNodeValue();
                    return text.trim();
                }
                ++i;
            }
        }
        return null;
    }

    private void save(PrintWriter writer, EngineDescriptor desc) {
        String indent = "   ";
        String attIndent = String.valueOf(indent) + indent;
        writer.print(indent);
        writer.println("<engine ");
        this.saveAttribute(writer, attIndent, "id", desc.getId());
        this.saveAttribute(writer, attIndent, ATT_ENGINE_TYPE_ID, desc.getEngineTypeId());
        this.saveAttribute(writer, attIndent, "label", desc.getLabel());
        writer.println(">");
        this.saveDescription(writer, String.valueOf(indent) + indent, desc.getDescription());
        writer.print(indent);
        writer.println("</engine>");
    }

    private String getAttribute(Node node, String name) {
        Node att = node.getAttributes().getNamedItem(name);
        if (att != null) {
            return att.getNodeValue();
        }
        return null;
    }

    private void saveAttribute(PrintWriter writer, String indent, String name, String value) {
        if (value == null) {
            return;
        }
        writer.print(indent);
        writer.print(name);
        writer.print("=\"");
        writer.print(value);
        writer.println("\"");
    }

    private void saveDescription(PrintWriter writer, String indent, String desc) {
        if (desc == null) {
            return;
        }
        writer.print(indent);
        writer.println("<description>");
        writer.println(desc);
        writer.print(indent);
        writer.println("</description>");
    }

    private EngineTypeDescriptor findEngineType(String id) {
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.engineTypes.length) {
            EngineTypeDescriptor etd = this.engineTypes[i];
            if (etd.getId().equals(id)) {
                return etd;
            }
            ++i;
        }
        return null;
    }

    public static class DescriptorEvent {
        private EngineDescriptor desc;
        private int kind;

        public DescriptorEvent(EngineDescriptor desc, int kind) {
            this.desc = desc;
            this.kind = kind;
        }

        public EngineDescriptor getDescriptor() {
            return this.desc;
        }

        public int getKind() {
            return this.kind;
        }
    }
}

