/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.ds.internal.annotations.Activator;
import org.eclipse.pde.ds.internal.annotations.AnnotationProcessor;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationProblem;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationVersion;
import org.eclipse.pde.ds.internal.annotations.DSEnums;
import org.eclipse.pde.ds.internal.annotations.Debug;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.pde.ds.internal.annotations.ProblemReporter;
import org.eclipse.pde.ds.internal.annotations.ProjectState;
import org.eclipse.pde.ds.internal.annotations.ReferenceProcessor;
import org.eclipse.pde.ds.internal.annotations.ValidationErrorLevel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentObject;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.IModelTextChangeListener;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.BundleContext;

public class AnnotationVisitor
extends ASTVisitor {
    private static final String COMPONENT_CONTEXT = "org.osgi.service.component.ComponentContext";
    private static final String COMPONENT_ANNOTATION = "org.osgi.service.component.annotations.Component";
    private static final String ACTIVATE_ANNOTATION = "org.osgi.service.component.annotations.Activate";
    private static final String MODIFIED_ANNOTATION = "org.osgi.service.component.annotations.Modified";
    private static final String DEACTIVATE_ANNOTATION = "org.osgi.service.component.annotations.Deactivate";
    private static final String REFERENCE_ANNOTATION = "org.osgi.service.component.annotations.Reference";
    private static final String DESIGNATE_ANNOTATION = "org.osgi.service.metatype.annotations.Designate";
    private static final Pattern PID_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*");
    private static final String ATTRIBUTE_COMPONENT_CONFIGURATION_PID = "configuration-pid";
    private static final String ATTRIBUTE_COMPONENT_REFERENCE = "reference";
    private static final String ATTRIBUTE_SERVICE_SCOPE = "scope";
    private static final String VALUE_SERVICE_SCOPE_DEFAULT = DSEnums.getServiceScope("DEFAULT");
    private static final String VALUE_SERVICE_SCOPE_SINGLETON = DSEnums.getServiceScope("SINGLETON");
    private static final String VALUE_SERVICE_SCOPE_BUNDLE = DSEnums.getServiceScope("BUNDLE");
    private static final Set<String> PROPERTY_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(null, "String", "Long", "Double", "Float", "Integer", "Byte", "Character", "Boolean", "Short")));
    private static final Map<String, String> PRIMITIVE_TYPE_MAP;
    private static final Comparator<IDSReference> REF_NAME_COMPARATOR;
    private static final Debug debug;
    private final AnnotationProcessor processor;
    private final ProjectState state;
    private final DSAnnotationVersion specVersion;
    private final ValidationErrorLevel errorLevel;
    private final Map<String, String> dsKeys;
    private final ProblemReporter problemReporter;

    static {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put(Long.class.getName(), "Long");
        map.put(Double.class.getName(), "Double");
        map.put(Float.class.getName(), "Float");
        map.put(Integer.class.getName(), "Integer");
        map.put(Byte.class.getName(), "Byte");
        map.put(Character.class.getName(), "Character");
        map.put(Boolean.class.getName(), "Boolean");
        map.put(Short.class.getName(), "Short");
        map.put(Long.TYPE.getName(), "Long");
        map.put(Double.TYPE.getName(), "Double");
        map.put(Float.TYPE.getName(), "Float");
        map.put(Integer.TYPE.getName(), "Integer");
        map.put(Byte.TYPE.getName(), "Byte");
        map.put(Character.TYPE.getName(), "Character");
        map.put(Boolean.TYPE.getName(), "Boolean");
        map.put(Short.TYPE.getName(), "Short");
        PRIMITIVE_TYPE_MAP = Collections.unmodifiableMap(map);
        REF_NAME_COMPARATOR = (o1, o2) -> o1.getReferenceName().compareTo(o2.getReferenceName());
        debug = AnnotationProcessor.debug;
    }

    public AnnotationVisitor(AnnotationProcessor processor, ProjectState state, Map<String, String> dsKeys, Set<DSAnnotationProblem> problems) {
        this.processor = processor;
        this.state = state;
        this.specVersion = state.getSpecVersion();
        this.errorLevel = state.getErrorLevel();
        this.dsKeys = dsKeys;
        this.problemReporter = new ProblemReporter(state.getErrorLevel(), problems);
    }

    public boolean visit(TypeDeclaration type) {
        if (!Modifier.isPublic((int)type.getModifiers())) {
            if (this.errorLevel.isIgnore()) {
                return false;
            }
            Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)type);
            if (annotation != null) {
                this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_notPublic, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
            }
            return true;
        }
        Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)type);
        if (annotation != null) {
            boolean isInterface = false;
            boolean isAbstract = false;
            boolean isNested = false;
            boolean noDefaultConstructor = false;
            isInterface = type.isInterface();
            if (isInterface || (isAbstract = Modifier.isAbstract((int)type.getModifiers())) || (isNested = !type.isPackageMemberTypeDeclaration() && !this.isNestedPublicStatic((AbstractTypeDeclaration)type)) || (noDefaultConstructor = !this.hasDefaultConstructor(type))) {
                if (!this.errorLevel.isIgnore()) {
                    if (isInterface) {
                        this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_interface, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else if (isAbstract) {
                        this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_abstract, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else if (isNested) {
                        this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_notTopLevel, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else if (noDefaultConstructor) {
                        this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_noDefaultConstructor, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else {
                        this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentImplementationClass, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    }
                }
            } else {
                ITypeBinding typeBinding = type.resolveBinding();
                if (typeBinding == null) {
                    if (debug.isDebugging()) {
                        debug.trace(String.format("Unable to resolve binding for type: %s", type));
                    }
                } else {
                    IAnnotationBinding annotationBinding = annotation.resolveAnnotationBinding();
                    if (annotationBinding == null) {
                        if (debug.isDebugging()) {
                            debug.trace(String.format("Unable to resolve binding for annotation: %s", annotation));
                        }
                    } else {
                        try {
                            this.processComponent(type, typeBinding, annotation, annotationBinding);
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean visit(EnumDeclaration node) {
        Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)node);
        if (annotation != null) {
            this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_enumeration, (Object)node.getName().getIdentifier()), node.getName().getIdentifier());
        }
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)node);
        if (annotation != null) {
            this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_annotation, (Object)node.getName().getIdentifier()), node.getName().getIdentifier());
        }
        return true;
    }

    private Annotation findComponentAnnotation(AbstractTypeDeclaration type) {
        for (Object item : type.modifiers()) {
            if (!(item instanceof Annotation)) continue;
            Annotation annotation = (Annotation)item;
            IAnnotationBinding annotationBinding = annotation.resolveAnnotationBinding();
            if (annotationBinding == null) {
                if (!debug.isDebugging()) continue;
                debug.trace(String.format("Unable to resolve binding for annotation: %s", annotation));
                continue;
            }
            if (!COMPONENT_ANNOTATION.equals(annotationBinding.getAnnotationType().getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    private boolean isNestedPublicStatic(AbstractTypeDeclaration type) {
        AbstractTypeDeclaration parentType;
        ASTNode parent;
        if (Modifier.isStatic((int)type.getModifiers()) && (parent = type.getParent()) != null && (parent.getNodeType() == 55 || parent.getNodeType() == 81) && Modifier.isPublic((int)(parentType = (AbstractTypeDeclaration)parent).getModifiers())) {
            return parentType.isPackageMemberTypeDeclaration() || this.isNestedPublicStatic(parentType);
        }
        return false;
    }

    private boolean hasDefaultConstructor(TypeDeclaration type) {
        boolean hasConstructor = false;
        MethodDeclaration[] methodDeclarationArray = type.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (method.isConstructor()) {
                hasConstructor = true;
                if (Modifier.isPublic((int)method.getModifiers()) && method.parameters().isEmpty()) {
                    return true;
                }
            }
            ++n2;
        }
        return !hasConstructor;
    }

    private void processComponent(TypeDeclaration type, ITypeBinding typeBinding, Annotation annotation, IAnnotationBinding annotationBinding) throws CoreException {
        block15: {
            IFile oldFile;
            String implClass;
            HashMap<String, Object> params = new HashMap<String, Object>();
            IMemberValuePairBinding[] iMemberValuePairBindingArray = annotationBinding.getDeclaredMemberValuePairs();
            int n = iMemberValuePairBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePairBinding pair = iMemberValuePairBindingArray[n2];
                params.put(pair.getName(), pair.getValue());
                ++n2;
            }
            String name = implClass = typeBinding.getBinaryName();
            Object value = params.get("name");
            if (value instanceof String) {
                name = (String)value;
                this.validateComponentName(annotation, name);
            }
            IPath path = new Path(this.state.getPath()).append(name).addFileExtension("xml");
            String dsKey = path.toPortableString();
            this.dsKeys.put(implClass, dsKey);
            IProject project = typeBinding.getJavaElement().getJavaProject().getProject();
            IFile file = PDEProject.getBundleRelativeFile((IProject)project, (IPath)path);
            IPath filePath = file.getFullPath();
            this.processor.verifyOutputLocation(file);
            String oldPath = this.state.getModelFile(implClass);
            if (oldPath != null && !oldPath.equals(dsKey) && !file.exists() && (oldFile = PDEProject.getBundleRelativeFile((IProject)project, (IPath)Path.fromPortableString((String)oldPath))).exists()) {
                try {
                    oldFile.move(file.getFullPath(), true, true, null);
                }
                catch (CoreException e) {
                    Activator.log((IStatus)new Status(2, "org.eclipse.pde.ds.annotations", String.format("Unable to move model file from '%s' to '%s'.", oldPath, file.getFullPath()), (Throwable)e));
                }
            }
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.connect(filePath, LocationKind.IFILE, null);
            ITextFileBuffer buffer = bufferManager.getTextFileBuffer(filePath, LocationKind.IFILE);
            if (buffer.isDirty()) {
                buffer.commit(null, true);
            }
            IDocument document = buffer.getDocument();
            final DSModel dsModel = new DSModel(document, true);
            dsModel.setUnderlyingResource((IResource)file);
            dsModel.setCharset(StandardCharsets.UTF_8);
            dsModel.load();
            IDocument fDoc = document;
            dsModel.addModelChangedListener((IModelChangedListener)new IModelTextChangeListener(fDoc){
                private final IDocument document;
                private boolean changed;
                {
                    this.document = iDocument;
                }

                public void modelChanged(IModelChangedEvent event) {
                    this.changed = true;
                }

                public TextEdit[] getTextOperations() {
                    if (!this.changed) {
                        return new TextEdit[0];
                    }
                    String text = dsModel.getContents();
                    ReplaceEdit edit = new ReplaceEdit(0, this.document.getLength(), text);
                    return new TextEdit[]{edit};
                }

                public String getReadableName(TextEdit edit) {
                    return null;
                }
            });
            try {
                this.processComponent((IDSModel)dsModel, type, typeBinding, annotation, annotationBinding, params, name, implClass);
                TextEdit[] edits = dsModel.getLastTextChangeListener().getTextOperations();
                if (edits.length <= 0) break block15;
                if (debug.isDebugging()) {
                    debug.trace(String.format("Saving model: %s", file.getFullPath()));
                }
                MultiTextEdit edit = new MultiTextEdit();
                edit.addChildren(edits);
                if (buffer.isSynchronizationContextRequested()) {
                    CoreException[] ex;
                    block16: {
                        IDocument doc = document;
                        ex = new CoreException[1];
                        CountDownLatch latch = new CountDownLatch(1);
                        bufferManager.execute(() -> {
                            try {
                                this.performEdit(doc, (TextEdit)edit);
                            }
                            catch (CoreException e) {
                                coreExceptionArray[0] = e;
                            }
                            latch.countDown();
                        });
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            if (!debug.isDebugging()) break block16;
                            debug.trace("Interrupted while waiting for edits to complete on display thread.", e);
                        }
                    }
                    if (ex[0] != null) {
                        throw ex[0];
                    }
                } else {
                    this.performEdit(document, (TextEdit)edit);
                }
                buffer.commit(null, true);
            }
            finally {
                dsModel.dispose();
                bufferManager.disconnect(buffer.getLocation(), LocationKind.IFILE, null);
            }
        }
    }

    private void performEdit(IDocument document, TextEdit edit) throws CoreException {
        DocumentRewriteSession session = null;
        try {
            try {
                if (document instanceof IDocumentExtension4) {
                    session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                }
                LinkedModeModel.closeAllModels((IDocument)document);
                edit.apply(document);
            }
            catch (BadLocationException | MalformedTreeException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ds.annotations", "Error applying changes to component model.", e));
            }
        }
        catch (Throwable throwable) {
            if (session != null) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
            throw throwable;
        }
        if (session != null) {
            ((IDocumentExtension4)document).stopRewriteSession(session);
        }
    }

    private void processComponent(IDSModel model, TypeDeclaration type, ITypeBinding typeBinding, Annotation annotation, IAnnotationBinding annotationBinding, Map<String, ?> params, String name, String implClass) {
        IMethodBinding modifiedMethod;
        String modified;
        IMethodBinding deactivateMethod;
        boolean lookedForDeactivateMethod;
        IMethodBinding activateMethod;
        boolean lookedForActivateMethod;
        HashMap<String, IDSReference> refMap;
        IDSReference[] refElements;
        ArrayList<IDSReference> references;
        IDSService service;
        IDSDocumentFactory dsFactory;
        IDSComponent component;
        DSAnnotationVersion requiredVersion;
        String[] propertyFiles;
        String[] properties;
        Object value;
        block160: {
            String deactivate;
            block158: {
                block159: {
                    block157: {
                        String activate;
                        block155: {
                            block156: {
                                Object referenceName;
                                HashMap<String, Object> annotationParams;
                                String annotationName;
                                Object annotations;
                                IDSProvide[] pos;
                                Object[] configPidElems;
                                int n;
                                Object serviceName;
                                int i;
                                AbstractCollection services;
                                value = params.get("service");
                                if (value instanceof Object[]) {
                                    Object[] elements = (Object[])value;
                                    services = new LinkedHashSet(elements.length);
                                    HashMap<ITypeBinding[], Integer> serviceDuplicates = this.errorLevel.isIgnore() ? null : new HashMap<ITypeBinding[], Integer>();
                                    i = 0;
                                    while (i < elements.length) {
                                        ITypeBinding serviceType = (ITypeBinding)elements[i];
                                        serviceName = serviceType.getBinaryName();
                                        if (services.add(serviceName)) {
                                            if (serviceDuplicates != null) {
                                                serviceDuplicates.put((ITypeBinding[])serviceName, i);
                                            }
                                        } else if (serviceDuplicates != null) {
                                            this.problemReporter.reportProblem(annotation, "service", i, Messages.AnnotationProcessor_duplicateServiceDeclaration, new String[]{serviceName});
                                            Integer pos2 = serviceDuplicates.put((ITypeBinding[])serviceName, (Integer)null);
                                            if (pos2 != null) {
                                                this.problemReporter.reportProblem(annotation, "service", (int)pos2, Messages.AnnotationProcessor_duplicateServiceDeclaration, new String[]{serviceName});
                                            }
                                        }
                                        this.validateComponentService(annotation, typeBinding, serviceType, i);
                                        ++i;
                                    }
                                } else {
                                    ITypeBinding[] serviceTypes = typeBinding.getInterfaces();
                                    services = new ArrayList(serviceTypes.length);
                                    serviceName = serviceTypes;
                                    int serviceType = serviceTypes.length;
                                    i = 0;
                                    while (i < serviceType) {
                                        ITypeBinding serviceType2 = serviceName[i];
                                        services.add(serviceType2.getBinaryName());
                                        ++i;
                                    }
                                }
                                String factory = null;
                                value = params.get("factory");
                                if (value instanceof String) {
                                    factory = (String)value;
                                    this.validateComponentFactory(annotation, factory);
                                }
                                Boolean serviceFactory = null;
                                value = params.get("servicefactory");
                                if (value instanceof Boolean) {
                                    serviceFactory = (Boolean)value;
                                    if (!this.errorLevel.isIgnore() && Boolean.TRUE.equals(serviceFactory) && services.isEmpty()) {
                                        this.problemReporter.reportProblem(annotation, "servicefactory", Messages.AnnotationVisitor_invalidServiceFactory_noServices, new String[0]);
                                    }
                                }
                                Boolean enabled = null;
                                value = params.get("enabled");
                                if (value instanceof Boolean) {
                                    enabled = (Boolean)value;
                                }
                                Boolean immediate = null;
                                value = params.get("immediate");
                                if (value instanceof Boolean) {
                                    immediate = (Boolean)value;
                                    if (!this.errorLevel.isIgnore()) {
                                        if (factory != null && Boolean.TRUE.equals(immediate)) {
                                            this.problemReporter.reportProblem(annotation, "immediate", Messages.AnnotationVisitor_invalidFactoryComponent_immediate, new String[0]);
                                        }
                                        if (services.isEmpty() && Boolean.FALSE.equals(immediate)) {
                                            this.problemReporter.reportProblem(annotation, "immediate", Messages.AnnotationVisitor_invalidDelayedComponent_noServices, new String[0]);
                                        }
                                    }
                                }
                                if ((value = params.get("property")) instanceof Object[]) {
                                    Object[] elements = (Object[])value;
                                    ArrayList<String> list = new ArrayList<String>(elements.length);
                                    Object[] objectArray = elements;
                                    n = elements.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Object element = objectArray[n2];
                                        if (element instanceof String) {
                                            list.add((String)element);
                                        }
                                        ++n2;
                                    }
                                    properties = list.toArray(new String[list.size()]);
                                } else {
                                    properties = new String[]{};
                                }
                                value = params.get("properties");
                                if (value instanceof Object[]) {
                                    Object[] elements = (Object[])value;
                                    ArrayList<String> list = new ArrayList<String>(elements.length);
                                    Object[] objectArray = elements;
                                    int n3 = elements.length;
                                    n = 0;
                                    while (n < n3) {
                                        Object element = objectArray[n];
                                        if (element instanceof String) {
                                            list.add((String)element);
                                        }
                                        ++n;
                                    }
                                    propertyFiles = list.toArray(new String[list.size()]);
                                    this.validateComponentPropertyFiles(annotation, ((IType)typeBinding.getJavaElement()).getJavaProject().getProject(), propertyFiles);
                                } else {
                                    propertyFiles = new String[]{};
                                }
                                String configPolicy = null;
                                value = params.get("configurationPolicy");
                                if (value instanceof IVariableBinding) {
                                    IVariableBinding configPolicyBinding = (IVariableBinding)value;
                                    configPolicy = DSEnums.getConfigurationPolicy(configPolicyBinding.getName());
                                } else if (this.specVersion == DSAnnotationVersion.V1_3) {
                                    IAnnotationBinding[] iAnnotationBindingArray = typeBinding.getAnnotations();
                                    n = iAnnotationBindingArray.length;
                                    int element = 0;
                                    block4: while (element < n) {
                                        IAnnotationBinding typeAnnotation = iAnnotationBindingArray[element];
                                        if (DESIGNATE_ANNOTATION.equals(typeAnnotation.getAnnotationType().getQualifiedName())) {
                                            IMemberValuePairBinding[] iMemberValuePairBindingArray = typeAnnotation.getDeclaredMemberValuePairs();
                                            int n4 = iMemberValuePairBindingArray.length;
                                            int n5 = 0;
                                            while (n5 < n4) {
                                                IMemberValuePairBinding memberValuePair = iMemberValuePairBindingArray[n5];
                                                if ("factory".equals(memberValuePair.getName())) {
                                                    if (!Boolean.TRUE.equals(memberValuePair.getValue())) break block4;
                                                    configPolicy = "require";
                                                    break block4;
                                                }
                                                ++n5;
                                            }
                                            break;
                                        }
                                        ++element;
                                    }
                                }
                                requiredVersion = DSAnnotationVersion.V1_1;
                                String configPid = null;
                                value = params.get("configurationPid");
                                if (value instanceof String) {
                                    configPid = (String)value;
                                    this.validateComponentConfigPID(annotation, configPid, -1);
                                    requiredVersion = DSAnnotationVersion.V1_2;
                                } else if (this.specVersion == DSAnnotationVersion.V1_3 && value instanceof Object[] && (configPidElems = (Object[])value).length > 0) {
                                    LinkedHashSet<String> configPids = new LinkedHashSet<String>(configPidElems.length);
                                    HashMap<String, Integer> pidDuplicates = this.errorLevel.isIgnore() ? null : new HashMap<String, Integer>(configPidElems.length);
                                    int i2 = 0;
                                    Object[] objectArray = configPidElems;
                                    int n6 = configPidElems.length;
                                    int n7 = 0;
                                    while (n7 < n6) {
                                        Object configPidElem = objectArray[n7];
                                        Object configPidStr = String.valueOf(configPidElem);
                                        if ("$".equals(configPidStr)) {
                                            configPidStr = name;
                                        } else {
                                            this.validateComponentConfigPID(annotation, (String)configPidStr, i2);
                                        }
                                        if (configPids.add((String)configPidStr)) {
                                            if (pidDuplicates != null) {
                                                pidDuplicates.put((String)configPidStr, i2);
                                            }
                                        } else if (pidDuplicates != null) {
                                            this.problemReporter.reportProblem(annotation, "configurationPid", i2, Messages.AnnotationVisitor_invalidComponentConfigurationPid_duplicate, new String[0]);
                                            pos = pidDuplicates.put((String)configPidStr, (Integer)null);
                                            if (pos != null) {
                                                this.problemReporter.reportProblem(annotation, "configurationPid", pos.intValue(), Messages.AnnotationVisitor_invalidComponentConfigurationPid_duplicate, new String[0]);
                                            }
                                        }
                                        ++i2;
                                        ++n7;
                                    }
                                    requiredVersion = i2 > 1 ? DSAnnotationVersion.V1_3 : DSAnnotationVersion.V1_2;
                                    StringBuilder configPidBuf = new StringBuilder();
                                    for (String configPidElem : configPids) {
                                        if (configPidBuf.length() > 0) {
                                            configPidBuf.append(' ');
                                        }
                                        configPidBuf.append(configPidElem);
                                    }
                                    configPid = configPidBuf.toString();
                                }
                                String serviceScope = null;
                                if (this.specVersion == DSAnnotationVersion.V1_3 && (value = params.get(ATTRIBUTE_SERVICE_SCOPE)) instanceof IVariableBinding) {
                                    IVariableBinding serviceScopeBinding = (IVariableBinding)value;
                                    serviceScope = DSEnums.getServiceScope(serviceScopeBinding.getName());
                                    if (!this.errorLevel.isIgnore()) {
                                        if (services.isEmpty()) {
                                            this.problemReporter.reportProblem(annotation, ATTRIBUTE_SERVICE_SCOPE, Messages.AnnotationVisitor_invalidScope_noServices, new String[0]);
                                        } else if ((factory != null || Boolean.TRUE.equals(immediate)) && !serviceScope.equals(VALUE_SERVICE_SCOPE_SINGLETON)) {
                                            this.problemReporter.reportProblem(annotation, ATTRIBUTE_SERVICE_SCOPE, Messages.AnnotationVisitor_invalidScope_factoryImmediate, new String[0]);
                                        }
                                    }
                                }
                                if (this.specVersion == DSAnnotationVersion.V1_3 && serviceFactory != null && serviceScope != null && !serviceScope.equals(VALUE_SERVICE_SCOPE_DEFAULT)) {
                                    if (!this.errorLevel.isIgnore() && !serviceFactory.equals(VALUE_SERVICE_SCOPE_BUNDLE.equals(serviceScope))) {
                                        this.problemReporter.reportProblem(annotation, "servicefactory", -1, true, this.errorLevel, Messages.AnnotationVisitor_invalidServiceFactory_ignored, new String[0]);
                                    }
                                    serviceFactory = null;
                                }
                                if (!(this.errorLevel.isIgnore() || serviceFactory == null || serviceFactory.equals(Boolean.FALSE) || services.isEmpty() || factory == null && !Boolean.TRUE.equals(immediate))) {
                                    this.problemReporter.reportProblem(annotation, "servicefactory", Messages.AnnotationVisitor_invalidServiceFactory_factoryImmediate, new String[0]);
                                }
                                component = model.getDSComponent();
                                if (enabled == null) {
                                    this.removeAttribute((IDSObject)component, "enabled", "true");
                                } else {
                                    component.setEnabled(enabled.booleanValue());
                                }
                                if (name == null) {
                                    this.removeAttribute((IDSObject)component, "name", null);
                                } else {
                                    component.setAttributeName(name);
                                }
                                if (factory == null) {
                                    this.removeAttribute((IDSObject)component, "factory", null);
                                } else {
                                    component.setFactory(factory);
                                }
                                if (immediate == null) {
                                    this.removeAttribute((IDSObject)component, "immediate", null);
                                } else {
                                    component.setImmediate(immediate.booleanValue());
                                }
                                if (configPolicy == null) {
                                    this.removeAttribute((IDSObject)component, "configuration-policy", "optional");
                                } else {
                                    component.setConfigurationPolicy(configPolicy);
                                }
                                if (configPid == null) {
                                    this.removeAttribute((IDSObject)component, ATTRIBUTE_COMPONENT_CONFIGURATION_PID, null);
                                } else {
                                    component.setXMLAttribute(ATTRIBUTE_COMPONENT_CONFIGURATION_PID, configPid);
                                }
                                dsFactory = model.getFactory();
                                service = component.getService();
                                if (services.isEmpty()) {
                                    if (service != null) {
                                        component.removeService(service);
                                    }
                                } else {
                                    if (service == null) {
                                        service = dsFactory.createService();
                                        int firstPos = Math.max(0, this.indexOfLastPropertyOrProperties(component));
                                        component.addChildNode((IDocumentElementNode)service, firstPos, true);
                                    }
                                    if (serviceScope == null || serviceScope.equals(VALUE_SERVICE_SCOPE_DEFAULT)) {
                                        this.removeAttribute((IDSObject)service, ATTRIBUTE_SERVICE_SCOPE, null);
                                    } else {
                                        service.setXMLAttribute(ATTRIBUTE_SERVICE_SCOPE, serviceScope);
                                        requiredVersion = DSAnnotationVersion.V1_3;
                                    }
                                    IDSProvide[] provides = service.getProvidedServices();
                                    HashMap<String, IDSProvide> provideMap = new HashMap<String, IDSProvide>(provides.length);
                                    pos = provides;
                                    int configPidStr = provides.length;
                                    int n8 = 0;
                                    while (n8 < configPidStr) {
                                        IDSProvide provide = pos[n8];
                                        provideMap.put(provide.getInterface(), provide);
                                        ++n8;
                                    }
                                    ArrayList<IDSProvide> provideList = new ArrayList<IDSProvide>(services.size());
                                    for (String serviceName2 : services) {
                                        IDSProvide provide = (IDSProvide)provideMap.remove(serviceName2);
                                        if (provide == null) {
                                            provide = dsFactory.createProvide();
                                            provide.setInterface(serviceName2);
                                        }
                                        provideList.add(provide);
                                    }
                                    int firstPos = provides.length == 0 ? -1 : service.indexOf((IDocumentElementNode)provides[0]);
                                    this.removeChildren((IDSObject)service, provideMap.values());
                                    this.addOrMoveChildren((IDSObject)service, provideList, firstPos);
                                    if (serviceFactory == null) {
                                        this.removeAttribute((IDSObject)service, "servicefactory", "false");
                                    } else {
                                        service.setServiceFactory(serviceFactory.booleanValue());
                                    }
                                }
                                references = new ArrayList<IDSReference>();
                                HashMap<String, Annotation> referenceNames = new HashMap<String, Annotation>();
                                refElements = component.getReferences();
                                refMap = new HashMap<String, IDSReference>(refElements.length);
                                IDSReference[] iDSReferenceArray = refElements;
                                int n9 = refElements.length;
                                int provide = 0;
                                while (provide < n9) {
                                    IDSReference refElement = iDSReferenceArray[provide];
                                    String referenceName2 = refElement.getReferenceName();
                                    if (referenceName2 == null) {
                                        String referenceBind = refElement.getXMLAttributeValue("field");
                                        if (referenceBind != null) {
                                            referenceName2 = ReferenceProcessor.getReferenceName(referenceBind);
                                        }
                                        if (referenceName2 == null && (referenceName2 = refElement.getReferenceBind()) == null) {
                                            referenceName2 = refElement.getReferenceInterface();
                                        }
                                    }
                                    refMap.put(referenceName2, refElement);
                                    ++provide;
                                }
                                if (annotation.isNormalAnnotation() && this.specVersion == DSAnnotationVersion.V1_3) {
                                    for (Object annotationValue : ((NormalAnnotation)annotation).values()) {
                                        MemberValuePair annotationMemberValuePair = (MemberValuePair)annotationValue;
                                        if (!ATTRIBUTE_COMPONENT_REFERENCE.equals(annotationMemberValuePair.getName().getIdentifier())) continue;
                                        annotations = new ArrayList();
                                        Expression memberValue = annotationMemberValuePair.getValue();
                                        if (memberValue instanceof Annotation) {
                                            ((ArrayList)annotations).add((Annotation)memberValue);
                                        } else if (memberValue instanceof ArrayInitializer) {
                                            for (Object memberValueElement : ((ArrayInitializer)memberValue).expressions()) {
                                                if (!(memberValueElement instanceof Annotation)) continue;
                                                ((ArrayList)annotations).add((Annotation)memberValueElement);
                                            }
                                        }
                                        Iterator iterator = ((ArrayList)annotations).iterator();
                                        while (iterator.hasNext()) {
                                            Annotation referenceAnnotation = (Annotation)iterator.next();
                                            IAnnotationBinding referenceAnnotationBinding = referenceAnnotation.resolveAnnotationBinding();
                                            if (referenceAnnotationBinding == null) {
                                                if (!debug.isDebugging()) continue;
                                                debug.trace(String.format("Unable to resolve binding for annotation: %s", referenceAnnotation));
                                                continue;
                                            }
                                            annotationName = referenceAnnotationBinding.getAnnotationType().getQualifiedName();
                                            if (!REFERENCE_ANNOTATION.equals(annotationName)) continue;
                                            annotationParams = new HashMap<String, Object>();
                                            IMemberValuePairBinding[] iMemberValuePairBindingArray = referenceAnnotationBinding.getDeclaredMemberValuePairs();
                                            int n10 = iMemberValuePairBindingArray.length;
                                            int n11 = 0;
                                            while (n11 < n10) {
                                                IMemberValuePairBinding pair = iMemberValuePairBindingArray[n11];
                                                annotationParams.put(pair.getName(), pair.getValue());
                                                ++n11;
                                            }
                                            String referenceName3 = (String)annotationParams.get("name");
                                            IDSReference reference = (IDSReference)refMap.remove(referenceName3);
                                            if (reference == null) {
                                                reference = this.createReference(dsFactory);
                                            }
                                            references.add(reference);
                                            ReferenceProcessor referenceProcessor = new ReferenceProcessor(this, this.specVersion, requiredVersion, this.errorLevel, this.state.getMissingUnbindMethodLevel(), this.problemReporter);
                                            requiredVersion = requiredVersion.max(referenceProcessor.processReference(reference, typeBinding, referenceAnnotation, referenceAnnotationBinding, annotationParams, referenceNames));
                                        }
                                    }
                                }
                                if (this.specVersion == DSAnnotationVersion.V1_3) {
                                    annotations = type.getFields();
                                    int annotationMemberValuePair = ((FieldDeclaration[])annotations).length;
                                    provide = 0;
                                    while (provide < annotationMemberValuePair) {
                                        FieldDeclaration field = annotations[provide];
                                        for (Object modifier : field.modifiers()) {
                                            if (!(modifier instanceof Annotation)) continue;
                                            Annotation fieldAnnotation = (Annotation)modifier;
                                            IAnnotationBinding fieldAnnotationBinding = fieldAnnotation.resolveAnnotationBinding();
                                            if (fieldAnnotationBinding == null) {
                                                if (!debug.isDebugging()) continue;
                                                debug.trace(String.format("Unable to resolve binding for annotation: %s", fieldAnnotation));
                                                continue;
                                            }
                                            annotationName = fieldAnnotationBinding.getAnnotationType().getQualifiedName();
                                            if (!REFERENCE_ANNOTATION.equals(annotationName)) continue;
                                            annotationParams = null;
                                            for (Object fragmentElement : field.fragments()) {
                                                IDSReference reference;
                                                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragmentElement;
                                                IVariableBinding fieldBinding = fragment.resolveBinding();
                                                if (fieldBinding == null) {
                                                    if (!debug.isDebugging()) continue;
                                                    debug.trace(String.format("Unable to resolve binding for field: %s", fragment));
                                                    continue;
                                                }
                                                if (annotationParams == null) {
                                                    annotationParams = new HashMap();
                                                    IMemberValuePairBinding[] iMemberValuePairBindingArray = fieldAnnotationBinding.getDeclaredMemberValuePairs();
                                                    int n12 = iMemberValuePairBindingArray.length;
                                                    int n13 = 0;
                                                    while (n13 < n12) {
                                                        IMemberValuePairBinding pair = iMemberValuePairBindingArray[n13];
                                                        annotationParams.put(pair.getName(), pair.getValue());
                                                        ++n13;
                                                    }
                                                }
                                                if ((referenceName = (String)annotationParams.get("name")) == null) {
                                                    referenceName = fieldBinding.getName();
                                                }
                                                if ((reference = (IDSReference)refMap.remove(referenceName)) == null) {
                                                    reference = this.createReference(dsFactory);
                                                }
                                                references.add(reference);
                                                ReferenceProcessor referenceProcessor = new ReferenceProcessor(this, this.specVersion, requiredVersion, this.errorLevel, this.state.getMissingUnbindMethodLevel(), this.problemReporter);
                                                referenceProcessor.processReference(reference, field, fieldBinding, fieldAnnotation, fieldAnnotationBinding, annotationParams, referenceNames);
                                                requiredVersion = DSAnnotationVersion.V1_3;
                                            }
                                        }
                                        ++provide;
                                    }
                                }
                                activate = null;
                                lookedForActivateMethod = false;
                                activateMethod = null;
                                Annotation activateAnnotation = null;
                                deactivate = null;
                                lookedForDeactivateMethod = false;
                                deactivateMethod = null;
                                Annotation deactivateAnnotation = null;
                                modified = null;
                                modifiedMethod = null;
                                Annotation modifiedAnnotation = null;
                                referenceName = type.getMethods();
                                int fieldBinding = ((MethodDeclaration[])referenceName).length;
                                int fragment = 0;
                                while (fragment < fieldBinding) {
                                    MethodDeclaration method = referenceName[fragment];
                                    for (Object modifier : method.modifiers()) {
                                        if (!(modifier instanceof Annotation)) continue;
                                        Annotation methodAnnotation = (Annotation)modifier;
                                        IAnnotationBinding methodAnnotationBinding = methodAnnotation.resolveAnnotationBinding();
                                        if (methodAnnotationBinding == null) {
                                            if (!debug.isDebugging()) continue;
                                            debug.trace(String.format("Unable to resolve binding for annotation: %s", methodAnnotation));
                                            continue;
                                        }
                                        String annotationName2 = methodAnnotationBinding.getAnnotationType().getQualifiedName();
                                        if (ACTIVATE_ANNOTATION.equals(annotationName2)) {
                                            if (activate == null) {
                                                activate = method.getName().getIdentifier();
                                                if (this.specVersion == DSAnnotationVersion.V1_3) {
                                                    activateMethod = method.resolveBinding();
                                                }
                                                activateAnnotation = methodAnnotation;
                                                this.validateLifeCycleMethod(methodAnnotation, "activate", method);
                                                continue;
                                            }
                                            if (this.errorLevel.isIgnore()) continue;
                                            this.problemReporter.reportProblem(methodAnnotation, null, Messages.AnnotationProcessor_duplicateActivateMethod, method.getName().getIdentifier());
                                            if (activateAnnotation == null) continue;
                                            this.problemReporter.reportProblem(activateAnnotation, null, Messages.AnnotationProcessor_duplicateActivateMethod, activate);
                                            activateAnnotation = null;
                                            continue;
                                        }
                                        if (DEACTIVATE_ANNOTATION.equals(annotationName2)) {
                                            if (deactivate == null) {
                                                deactivate = method.getName().getIdentifier();
                                                if (this.specVersion == DSAnnotationVersion.V1_3) {
                                                    deactivateMethod = method.resolveBinding();
                                                }
                                                deactivateAnnotation = methodAnnotation;
                                                this.validateLifeCycleMethod(methodAnnotation, "deactivate", method);
                                                continue;
                                            }
                                            if (this.errorLevel.isIgnore()) continue;
                                            this.problemReporter.reportProblem(methodAnnotation, null, Messages.AnnotationProcessor_duplicateDeactivateMethod, method.getName().getIdentifier());
                                            if (deactivateAnnotation == null) continue;
                                            this.problemReporter.reportProblem(deactivateAnnotation, null, Messages.AnnotationProcessor_duplicateDeactivateMethod, deactivate);
                                            deactivateAnnotation = null;
                                            continue;
                                        }
                                        if (MODIFIED_ANNOTATION.equals(annotationName2)) {
                                            if (modified == null) {
                                                modified = method.getName().getIdentifier();
                                                if (this.specVersion == DSAnnotationVersion.V1_3) {
                                                    modifiedMethod = method.resolveBinding();
                                                }
                                                modifiedAnnotation = methodAnnotation;
                                                this.validateLifeCycleMethod(methodAnnotation, "modified", method);
                                                continue;
                                            }
                                            if (this.errorLevel.isIgnore()) continue;
                                            this.problemReporter.reportProblem(methodAnnotation, null, Messages.AnnotationProcessor_duplicateModifiedMethod, method.getName().getIdentifier());
                                            if (modifiedAnnotation == null) continue;
                                            this.problemReporter.reportProblem(modifiedAnnotation, null, Messages.AnnotationProcessor_duplicateModifiedMethod, modified);
                                            modifiedAnnotation = null;
                                            continue;
                                        }
                                        if (!REFERENCE_ANNOTATION.equals(annotationName2)) continue;
                                        IMethodBinding methodBinding = method.resolveBinding();
                                        if (methodBinding == null) {
                                            if (!debug.isDebugging()) continue;
                                            debug.trace(String.format("Unable to resolve binding for method: %s", method));
                                            continue;
                                        }
                                        HashMap<String, Object> annotationParams2 = new HashMap<String, Object>();
                                        IMemberValuePairBinding[] iMemberValuePairBindingArray = methodAnnotationBinding.getDeclaredMemberValuePairs();
                                        int n14 = iMemberValuePairBindingArray.length;
                                        int n15 = 0;
                                        while (n15 < n14) {
                                            IMemberValuePairBinding pair = iMemberValuePairBindingArray[n15];
                                            annotationParams2.put(pair.getName(), pair.getValue());
                                            ++n15;
                                        }
                                        ReferenceProcessor referenceProcessor = new ReferenceProcessor(this, this.specVersion, requiredVersion, this.errorLevel, this.state.getMissingUnbindMethodLevel(), this.problemReporter);
                                        String referenceName4 = referenceProcessor.getReferenceName(methodBinding.getName(), annotationParams2);
                                        IDSReference reference = (IDSReference)refMap.remove(referenceName4);
                                        if (reference == null) {
                                            reference = this.createReference(dsFactory);
                                        }
                                        references.add(reference);
                                        requiredVersion = requiredVersion.max(referenceProcessor.processReference(reference, method, methodBinding, methodAnnotation, methodAnnotationBinding, annotationParams2, referenceNames));
                                    }
                                    ++fragment;
                                }
                                if (activate != null) break block155;
                                if (!"activate".equals(component.getActivateMethod())) break block156;
                                lookedForActivateMethod = true;
                                if (!true || (activateMethod = this.findLifeCycleMethod(typeBinding, "activate")) != null) break block157;
                            }
                            this.removeAttribute((IDSObject)component, "activate", null);
                            break block157;
                        }
                        component.setActivateMethod(activate);
                    }
                    if (deactivate != null) break block158;
                    if (!"deactivate".equals(component.getDeactivateMethod())) break block159;
                    lookedForDeactivateMethod = true;
                    if (!true || (deactivateMethod = this.findLifeCycleMethod(typeBinding, "deactivate")) != null) break block160;
                }
                this.removeAttribute((IDSObject)component, "deactivate", null);
                break block160;
            }
            component.setDeactivateMethod(deactivate);
        }
        if (modified == null) {
            this.removeAttribute((IDSObject)component, "modified", null);
        } else {
            component.setModifiedeMethod(modified);
        }
        LinkedHashMap<String, IDSProperty> newPropMap = new LinkedHashMap<String, IDSProperty>();
        if (this.specVersion == DSAnnotationVersion.V1_3) {
            if (activateMethod == null && !lookedForActivateMethod) {
                activateMethod = this.findLifeCycleMethod(typeBinding, "activate");
            }
            if (deactivateMethod == null && !lookedForDeactivateMethod) {
                deactivateMethod = this.findLifeCycleMethod(typeBinding, "deactivate");
            }
            HashSet<ITypeBinding> cptClosure = new HashSet<ITypeBinding>();
            if (activateMethod != null) {
                this.collectProperties(activateMethod, dsFactory, newPropMap, cptClosure);
            }
            if (modifiedMethod != null) {
                this.collectProperties(modifiedMethod, dsFactory, newPropMap, cptClosure);
            }
            if (deactivateMethod != null) {
                this.collectProperties(deactivateMethod, dsFactory, newPropMap, cptClosure);
            }
            if (!cptClosure.isEmpty()) {
                requiredVersion = DSAnnotationVersion.V1_3;
            }
        }
        IDSProperty[] propElements = component.getPropertyElements();
        if (newPropMap.isEmpty() && properties.length == 0) {
            this.removeChildren((IDSObject)component, Arrays.asList(propElements));
        } else {
            Object propertyName;
            LinkedHashMap<IDSProperty[], IDSProperty> map = new LinkedHashMap<IDSProperty[], IDSProperty>(properties.length);
            int i = 0;
            while (i < properties.length) {
                String propertyType;
                String propertyStr = properties[i];
                String[] pair = propertyStr.split("=", 2);
                int colon = pair[0].indexOf(58);
                if (colon == -1) {
                    propertyName = pair[0];
                    propertyType = null;
                } else {
                    propertyName = pair[0].substring(0, colon);
                    propertyType = pair[0].substring(colon + 1);
                }
                String propertyValue = pair.length > 1 ? pair[1].trim() : null;
                IDSProperty property = (IDSProperty)map.get(propertyName);
                if (property == null) {
                    property = dsFactory.createProperty();
                    map.put((IDSProperty[])propertyName, property);
                    property.setPropertyName((String)propertyName);
                    if (propertyType == null) {
                        this.removeAttribute((IDSObject)property, "type", null);
                    } else {
                        property.setPropertyType(propertyType);
                    }
                    property.setPropertyValue(propertyValue);
                    this.validateComponentProperty(annotation, (String)propertyName, propertyType, propertyValue, i);
                } else {
                    String content = property.getPropertyElemBody();
                    if (content == null) {
                        content = property.getPropertyValue();
                        property.setPropertyElemBody(content);
                        this.removeAttribute((IDSObject)property, "value", null);
                    }
                    if (!this.errorLevel.isIgnore()) {
                        String actual;
                        String expected = property.getPropertyType() == null || property.getPropertyType().length() == 0 || "String".equals(property.getPropertyType()) ? Messages.AnnotationProcessor_stringOrEmpty : property.getPropertyType();
                        String string = actual = propertyType == null || "String".equals(propertyType) ? Messages.AnnotationProcessor_stringOrEmpty : propertyType;
                        if (!actual.equals(expected)) {
                            this.problemReporter.reportProblem(annotation, "property", i, NLS.bind((String)Messages.AnnotationProcessor_inconsistentComponentPropertyType, (Object)actual, (Object)expected), actual);
                        } else {
                            this.validateComponentProperty(annotation, (String)propertyName, propertyType, propertyValue, i);
                        }
                    }
                    if (propertyValue != null) {
                        property.setPropertyElemBody(String.valueOf(content) + "\n" + pair[1]);
                    }
                }
                ++i;
            }
            HashMap<String, IDSProperty> propMap = new HashMap<String, IDSProperty>(propElements.length);
            propertyName = propElements;
            int colon = propElements.length;
            int pair = 0;
            while (pair < colon) {
                IDSProperty propElement = propertyName[pair];
                propMap.put(propElement.getPropertyName(), propElement);
                ++pair;
            }
            newPropMap.keySet().removeAll(map.keySet());
            newPropMap.putAll(map);
            ArrayList<IDSProperty> propList = new ArrayList<IDSProperty>(newPropMap.values());
            ListIterator<IDSProperty> i3 = propList.listIterator();
            while (i3.hasNext()) {
                String newContent;
                IDSProperty newProperty = i3.next();
                IDSProperty property = (IDSProperty)propMap.remove(newProperty.getPropertyName());
                if (property == null) continue;
                i3.set(property);
                String newPropertyType = newProperty.getPropertyType();
                if (newPropertyType != null || !"String".equals(property.getPropertyType())) {
                    property.setPropertyType(newPropertyType);
                }
                if ((newContent = newProperty.getPropertyElemBody()) == null) {
                    property.setPropertyValue(newProperty.getPropertyValue());
                    IDocumentTextNode textNode = property.getTextNode();
                    if (textNode == null) continue;
                    property.removeTextNode();
                    if (!property.isInTheModel() || !property.isEditable()) continue;
                    model.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)model, 2, new Object[]{textNode}, null));
                    continue;
                }
                this.removeAttribute((IDSObject)property, "value", null);
                String content = property.getPropertyElemBody();
                if (content != null && newContent.equals(this.normalizePropertyElemBody(content))) continue;
                property.setPropertyElemBody(newContent);
            }
            int firstPos = propElements.length == 0 ? 0 : component.indexOf((IDocumentElementNode)propElements[0]);
            this.removeChildren((IDSObject)component, propMap.values());
            this.addOrMoveChildren((IDSObject)component, propList, firstPos);
        }
        IDSProperties[] propFileElements = component.getPropertiesElements();
        if (propertyFiles.length == 0) {
            this.removeChildren((IDSObject)component, Arrays.asList(propFileElements));
        } else {
            HashMap<String, IDSProperties> propFileMap = new HashMap<String, IDSProperties>(propFileElements.length);
            IDSProperties[] iDSPropertiesArray = propFileElements;
            int n = propFileElements.length;
            int firstPos = 0;
            while (firstPos < n) {
                IDSProperties propFileElement = iDSPropertiesArray[firstPos];
                propFileMap.put(propFileElement.getEntry(), propFileElement);
                ++firstPos;
            }
            ArrayList<IDSProperties> propFileList = new ArrayList<IDSProperties>(propertyFiles.length);
            String[] stringArray = propertyFiles;
            int n16 = propertyFiles.length;
            n = 0;
            while (n < n16) {
                String propertyFile = stringArray[n];
                IDSProperties propertiesElement = (IDSProperties)propFileMap.remove(propertyFile);
                if (propertiesElement == null) {
                    propertiesElement = dsFactory.createProperties();
                    propertiesElement.setInTheModel(false);
                    propertiesElement.setEntry(propertyFile);
                }
                propFileList.add(propertiesElement);
                ++n;
            }
            firstPos = propFileElements.length == 0 ? ((propElements = component.getPropertyElements()).length == 0 ? 0 : component.indexOf((IDocumentElementNode)propElements[propElements.length - 1]) + 1) : component.indexOf((IDocumentElementNode)propFileElements[0]);
            this.removeChildren((IDSObject)component, propFileMap.values());
            this.addOrMoveChildren((IDSObject)component, propFileList, firstPos);
        }
        if (references.isEmpty()) {
            this.removeChildren((IDSObject)component, Arrays.asList(refElements));
        } else {
            Collections.sort(references, REF_NAME_COMPARATOR);
            int firstPos = refElements.length == 0 ? ((service = component.getService()) == null ? Math.max(0, this.indexOfLastPropertyOrProperties(component)) : component.indexOf((IDocumentElementNode)service) + 1) : component.indexOf((IDocumentElementNode)refElements[0]);
            this.removeChildren((IDSObject)component, refMap.values());
            this.addOrMoveChildren((IDSObject)component, references, firstPos);
        }
        IDSImplementation impl = component.getImplementation();
        if (impl == null) {
            impl = dsFactory.createImplementation();
            component.setImplementation(impl);
        }
        impl.setClassName(implClass);
        String xmlns = requiredVersion.getNamespace();
        value = params.get("xmlns");
        if (value instanceof String) {
            xmlns = (String)value;
            this.validateComponentXMLNS(annotation, xmlns, requiredVersion);
        }
        component.setNamespace(xmlns);
    }

    private IDSReference createReference(IDSDocumentFactory dsFactory) {
        IDSReference reference = dsFactory.createReference();
        this.removeAttribute((IDSObject)reference, "cardinality", null);
        this.removeAttribute((IDSObject)reference, "policy", null);
        return reference;
    }

    private void removeChildren(IDSObject parent, Collection<? extends IDocumentElementNode> children) {
        for (IDocumentElementNode iDocumentElementNode : children) {
            parent.removeChildNode(iDocumentElementNode, true);
        }
    }

    void removeAttribute(IDSObject obj, String name, String defaultValue) {
        IDocumentAttributeNode attrNode = obj.getDocumentAttribute(name);
        if (attrNode != null) {
            String value = attrNode.getAttributeValue();
            if (value != null && value.equals(defaultValue)) {
                return;
            }
            obj.removeDocumentAttribute(attrNode);
            if (obj.isInTheModel() && obj.isEditable()) {
                obj.getModel().fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)obj.getModel(), 2, new Object[]{attrNode}, null));
            }
        }
    }

    private void addOrMoveChildren(IDSObject parent, List<? extends IDSObject> children, int firstPos) {
        int i = 0;
        int n = children.size();
        while (i < n) {
            IDSObject child = children.get(i);
            if (child.isInTheModel()) {
                int pos = parent.indexOf((IDocumentElementNode)child);
                if (i == 0) {
                    if (firstPos < pos) {
                        this.moveChildNode((IDocumentObject)parent, (IDocumentElementNode)child, firstPos - pos, true);
                    }
                } else {
                    int prevPos = parent.indexOf((IDocumentElementNode)children.get(i - 1));
                    if (prevPos > pos) {
                        this.moveChildNode((IDocumentObject)parent, (IDocumentElementNode)child, prevPos - pos, true);
                    }
                }
            } else if (i == 0) {
                if (firstPos == -1) {
                    parent.addChildNode((IDocumentElementNode)child, true);
                } else {
                    parent.addChildNode((IDocumentElementNode)child, firstPos, true);
                }
            } else {
                parent.addChildNode((IDocumentElementNode)child, parent.indexOf((IDocumentElementNode)children.get(i - 1)) + 1, true);
            }
            ++i;
        }
    }

    private void moveChildNode(IDocumentObject obj, IDocumentElementNode node, int newRelativeIndex, boolean fireEvent) {
        if (newRelativeIndex == 1 || newRelativeIndex == -1) {
            obj.moveChildNode(node, newRelativeIndex, fireEvent);
            return;
        }
        int currentIndex = obj.indexOf(node);
        if (currentIndex == -1) {
            return;
        }
        int newIndex = newRelativeIndex + currentIndex;
        if (newIndex < 0 || newIndex >= obj.getChildCount()) {
            return;
        }
        obj.removeChildNode(node, fireEvent);
        IDocumentElementNode clone = this.clone(obj, node);
        obj.addChildNode(clone, newIndex, fireEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IDocumentElementNode clone(IDocumentObject obj, IDocumentElementNode node) {
        IDocumentElementNode clone = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                block30: {
                    Throwable throwable2 = null;
                    Throwable throwable3 = null;
                    try (ObjectOutputStream out = new ObjectOutputStream(bout);){
                        out.writeObject(node);
                        out.flush();
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                    byte[] bytes = bout.toByteArray();
                    throwable3 = null;
                    Object var9_15 = null;
                    try {
                        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
                        try {
                            try (ObjectInputStream in = new ObjectInputStream(bin);){
                                clone = (IDocumentElementNode)in.readObject();
                            }
                            if (bin == null) break block30;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            if (bin == null) throw throwable3;
                            bin.close();
                            throw throwable3;
                        }
                        bin.close();
                    }
                    catch (Throwable throwable6) {
                        if (throwable3 == null) {
                            throwable3 = throwable6;
                            throw throwable3;
                        }
                        if (throwable3 == throwable6) throw throwable3;
                        throwable3.addSuppressed(throwable6);
                        throw throwable3;
                    }
                }
                clone.reconnect((IDocumentElementNode)obj, obj.getSharedModel());
                return clone;
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            if (!debug.isDebugging()) return clone;
            debug.trace("Error cloning element.", e);
        }
        return clone;
    }

    private int indexOfLastPropertyOrProperties(IDSComponent component) {
        int lastPos;
        int pos = -1;
        IDSProperty[] propElements = component.getPropertyElements();
        IDSProperties[] propFileElements = component.getPropertiesElements();
        if (propElements.length > 0) {
            pos = component.indexOf((IDocumentElementNode)propElements[propElements.length - 1]) + 1;
        }
        if (propFileElements.length > 0 && (lastPos = component.indexOf((IDocumentElementNode)propFileElements[propFileElements.length - 1]) + 1) > pos) {
            pos = lastPos;
        }
        return pos;
    }

    private String normalizePropertyElemBody(String content) {
        StringBuilder buf;
        block13: {
            buf = new StringBuilder(content.length());
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader reader = new BufferedReader(new StringReader(content));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String trimmed = line.trim();
                        if (trimmed.length() == 0) continue;
                        if (buf.length() > 0) {
                            buf.append('\n');
                        }
                        buf.append(trimmed);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (!debug.isDebugging()) break block13;
                debug.trace("Error reading property element body.", e);
            }
        }
        return buf.toString();
    }

    private void collectProperties(IMethodBinding method, IDSDocumentFactory factory, Map<String, IDSProperty> properties, Collection<ITypeBinding> visited) {
        ITypeBinding[] iTypeBindingArray = method.getParameterTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding paramTypeBinding = iTypeBindingArray[n2];
            if (paramTypeBinding.isAnnotation() && visited.add(paramTypeBinding)) {
                IMethodBinding[] iMethodBindingArray = paramTypeBinding.getDeclaredMethods();
                int n3 = iMethodBindingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding returnType;
                    Object value;
                    IMethodBinding methodBinding = iMethodBindingArray[n4];
                    if (methodBinding.isAnnotationMember() && (value = methodBinding.getDefaultValue()) != null && !((returnType = methodBinding.getReturnType()).isArray() ? returnType.getElementType().isAnnotation() : returnType.isAnnotation())) {
                        IDSProperty property = factory.createProperty();
                        property.setPropertyName(this.createPropertyName(methodBinding.getName()));
                        property.setPropertyType(this.getPropertyType(returnType));
                        if (returnType.isArray()) {
                            StringBuilder body = new StringBuilder();
                            Object[] objectArray = (Object[])value;
                            int n5 = objectArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Object item = objectArray[n6];
                                String itemValue = this.getPropertyValue(item);
                                if (itemValue != null && !(itemValue = itemValue.trim()).isEmpty()) {
                                    if (body.length() > 0) {
                                        body.append('\n');
                                    }
                                    body.append(itemValue);
                                }
                                ++n6;
                            }
                            this.removeAttribute((IDSObject)property, "value", null);
                            property.setPropertyElemBody(body.toString());
                        } else {
                            property.setPropertyValue(this.getPropertyValue(value));
                        }
                        properties.remove(property.getName());
                        properties.put(property.getName(), property);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private String createPropertyName(String name) {
        StringBuilder buf = new StringBuilder(name.length());
        char[] chars = name.toCharArray();
        int i = 0;
        int n = chars.length;
        while (i < n) {
            block5: {
                block6: {
                    block4: {
                        if (chars[i] != '$') break block4;
                        if (i == n - 1 || chars[i + 1] != '$') break block5;
                        ++i;
                        break block6;
                    }
                    if (chars[i] == '_') {
                        if (i == n - 1 || chars[i + 1] != '_') {
                            chars[i] = 46;
                        } else {
                            ++i;
                        }
                    }
                }
                buf.append(chars[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    private String getPropertyType(ITypeBinding type) {
        String name;
        String result;
        if (type.isArray()) {
            return this.getPropertyType(type.getElementType());
        }
        if (type.isPrimitive() && (result = PRIMITIVE_TYPE_MAP.get(name = type.getQualifiedName())) != null) {
            return result;
        }
        return "String";
    }

    private String getPropertyValue(Object value) {
        if (value instanceof IVariableBinding) {
            return ((IVariableBinding)value).getName();
        }
        if (value instanceof ITypeBinding) {
            return ((ITypeBinding)value).getQualifiedName();
        }
        return String.valueOf(value);
    }

    private void validateComponentName(Annotation annotation, String name) {
        if (!this.errorLevel.isIgnore() && !PID_PATTERN.matcher(name).matches()) {
            this.problemReporter.reportProblem(annotation, "name", NLS.bind((String)Messages.AnnotationProcessor_invalidComponentName, (Object)name), name);
        }
    }

    private void validateComponentService(Annotation annotation, ITypeBinding componentType, ITypeBinding serviceType, int index) {
        if (!this.errorLevel.isIgnore() && !componentType.isAssignmentCompatible(serviceType)) {
            this.problemReporter.reportProblem(annotation, "service", NLS.bind((String)Messages.AnnotationProcessor_invalidComponentService, (Object)serviceType.getName()), serviceType.getName());
        }
    }

    private void validateComponentFactory(Annotation annotation, String factory) {
        if (!this.errorLevel.isIgnore() && !PID_PATTERN.matcher(factory).matches()) {
            this.problemReporter.reportProblem(annotation, "factory", NLS.bind((String)Messages.AnnotationProcessor_invalidComponentFactoryName, (Object)factory), factory);
        }
    }

    private void validateComponentProperty(Annotation annotation, String name, String type, String value, int index) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        if (PROPERTY_TYPES.contains(type)) {
            if (name == null || name.trim().length() == 0) {
                this.problemReporter.reportProblem(annotation, "property", index, Messages.AnnotationProcessor_invalidComponentProperty_nameRequired, name);
            }
            if (value == null) {
                this.problemReporter.reportProblem(annotation, "property", index, Messages.AnnotationProcessor_invalidComponentProperty_valueRequired, name);
            } else {
                try {
                    if ("Long".equals(type)) {
                        Long.valueOf(value);
                    } else if ("Double".equals(type)) {
                        Double.valueOf(value);
                    } else if ("Float".equals(type)) {
                        Float.valueOf(value);
                    } else if ("Integer".equals(type) || "Character".equals(type)) {
                        Integer.valueOf(value);
                    } else if ("Byte".equals(type)) {
                        Byte.valueOf(value);
                    } else if ("Short".equals(type)) {
                        Short.valueOf(value);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.problemReporter.reportProblem(annotation, "property", index, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentPropertyValue, (Object)type, (Object)value), String.valueOf(value));
                }
            }
        } else {
            this.problemReporter.reportProblem(annotation, "property", index, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentPropertyType, (Object)type), String.valueOf(type));
        }
    }

    private void validateComponentPropertyFiles(Annotation annotation, IProject project, String[] files) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            IFile wsFile = PDEProject.getBundleRelativeFile((IProject)project, (IPath)new Path(file));
            if (!wsFile.exists()) {
                this.problemReporter.reportProblem(annotation, "properties", i, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentPropertyFile, (Object)file), file);
            }
            ++i;
        }
    }

    private void validateComponentXMLNS(Annotation annotation, String xmlns, DSAnnotationVersion requiredVersion) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        DSAnnotationVersion specifiedVersion = DSAnnotationVersion.fromNamespace(xmlns);
        if (specifiedVersion == null || requiredVersion.compareTo(specifiedVersion) > 0) {
            this.problemReporter.reportProblem(annotation, "xmlns", NLS.bind((String)Messages.AnnotationProcessor_invalidComponentDescriptorNamespace, (Object)xmlns), xmlns);
        }
    }

    private void validateComponentConfigPID(Annotation annotation, String configPid, int index) {
        if (!this.errorLevel.isIgnore() && !PID_PATTERN.matcher(configPid).matches()) {
            this.problemReporter.reportProblem(annotation, "configurationPid", index, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentConfigurationPid, (Object)configPid), configPid);
        }
    }

    private void validateLifeCycleMethod(Annotation annotation, String methodName, MethodDeclaration method) {
        ITypeBinding[] paramTypeBindings;
        if (this.errorLevel.isIgnore()) {
            return;
        }
        IMethodBinding methodBinding = method.resolveBinding();
        if (methodBinding == null) {
            if (debug.isDebugging()) {
                debug.trace(String.format("Unable to resolve binding for method: %s", method));
            }
            return;
        }
        if (Modifier.isStatic((int)methodBinding.getModifiers())) {
            this.problemReporter.reportProblem(annotation, methodName, Messages.AnnotationProcessor_invalidLifecycleMethod_static, new String[0]);
        }
        String returnTypeName = methodBinding.getReturnType().getName();
        if (!Void.TYPE.getName().equals(returnTypeName)) {
            this.problemReporter.reportProblem(annotation, methodName, NLS.bind((String)Messages.AnnotationProcessor_invalidLifeCycleMethodReturnType, (Object)methodName, (Object)returnTypeName), returnTypeName);
        }
        if ((paramTypeBindings = methodBinding.getParameterTypes()).length == 0) {
            return;
        }
        boolean hasMap = false;
        boolean hasCompCtx = false;
        boolean hasBundleCtx = false;
        boolean hasInt = false;
        HashSet<ITypeBinding> annotationParams = new HashSet<ITypeBinding>(1);
        ITypeBinding[] iTypeBindingArray = paramTypeBindings;
        int n = paramTypeBindings.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding paramTypeBinding = iTypeBindingArray[n2];
            ITypeBinding paramTypeErasure = paramTypeBinding.getErasure();
            String paramTypeName = paramTypeErasure.isMember() ? paramTypeErasure.getBinaryName() : paramTypeErasure.getQualifiedName();
            boolean isDuplicate = false;
            if (paramTypeBinding.isAnnotation() && this.specVersion == DSAnnotationVersion.V1_3) {
                if (!annotationParams.add(paramTypeBinding)) {
                    isDuplicate = true;
                }
            } else if (Map.class.getName().equals(paramTypeName)) {
                if (hasMap) {
                    isDuplicate = true;
                } else {
                    hasMap = true;
                }
            } else if (COMPONENT_CONTEXT.equals(paramTypeName)) {
                if (hasCompCtx) {
                    isDuplicate = true;
                } else {
                    hasCompCtx = true;
                }
            } else if (BundleContext.class.getName().equals(paramTypeName)) {
                if (hasBundleCtx) {
                    isDuplicate = true;
                } else {
                    hasBundleCtx = true;
                }
            } else if ("deactivate".equals(methodName) && (Integer.class.getName().equals(paramTypeName) || Integer.TYPE.getName().equals(paramTypeName))) {
                if (hasInt) {
                    isDuplicate = true;
                } else {
                    hasInt = true;
                }
            } else {
                this.problemReporter.reportProblem(annotation, methodName, NLS.bind((String)Messages.AnnotationProcessor_invalidLifeCycleMethodParameterType, (Object)methodName, (Object)paramTypeName), paramTypeName);
            }
            if (isDuplicate) {
                this.problemReporter.reportProblem(annotation, methodName, NLS.bind((String)Messages.AnnotationProcessor_duplicateLifeCycleMethodParameterType, (Object)methodName, (Object)paramTypeName), paramTypeName);
            }
            ++n2;
        }
    }

    private IMethodBinding findLifeCycleMethod(ITypeBinding componentClass, String methodName) {
        IMethodBinding[] iMethodBindingArray = componentClass.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodBinding = iMethodBindingArray[n2];
            if (methodName.equals(methodBinding.getName()) && Void.TYPE.getName().equals(methodBinding.getReturnType().getName())) {
                ITypeBinding[] paramTypeBindings = methodBinding.getParameterTypes();
                boolean hasMap = false;
                boolean hasCompCtx = false;
                boolean hasBundleCtx = false;
                boolean hasInt = false;
                boolean isInvalid = false;
                HashSet<ITypeBinding> annotationParams = new HashSet<ITypeBinding>(1);
                ITypeBinding[] iTypeBindingArray = paramTypeBindings;
                int n3 = paramTypeBindings.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding paramTypeBinding = iTypeBindingArray[n4];
                    if (paramTypeBinding.isAnnotation()) {
                        if (this.specVersion != DSAnnotationVersion.V1_3 || !annotationParams.add(paramTypeBinding)) {
                            isInvalid = true;
                            break;
                        }
                    } else {
                        String paramTypeName;
                        ITypeBinding paramTypeErasure = paramTypeBinding.getErasure();
                        String string = paramTypeName = paramTypeErasure.isMember() ? paramTypeErasure.getBinaryName() : paramTypeErasure.getQualifiedName();
                        if (Map.class.getName().equals(paramTypeName)) {
                            if (hasMap) {
                                isInvalid = true;
                            } else {
                                hasMap = true;
                            }
                        } else if (COMPONENT_CONTEXT.equals(paramTypeName)) {
                            if (hasCompCtx) {
                                isInvalid = true;
                            } else {
                                hasCompCtx = true;
                            }
                        } else if (BundleContext.class.getName().equals(paramTypeName)) {
                            if (hasBundleCtx) {
                                isInvalid = true;
                            } else {
                                hasBundleCtx = true;
                            }
                        } else if ("deactivate".equals(methodName) && (Integer.class.getName().equals(paramTypeName) || Integer.TYPE.getName().equals(paramTypeName))) {
                            if (hasInt) {
                                isInvalid = true;
                            } else {
                                hasInt = true;
                            }
                        } else {
                            isInvalid = true;
                        }
                        if (isInvalid) break;
                    }
                    ++n4;
                }
                if (!isInvalid) {
                    return methodBinding;
                }
            }
            ++n2;
        }
        return null;
    }
}

