/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.Set;
import org.eclipse.comma.monitoring.lib.CComponentTypeDescriptor;
import org.eclipse.comma.monitoring.lib.CFactory;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitoringContext;
import org.eclipse.comma.monitoring.lib.CMonitoringContext;

public class CComponentMonitoringContext
extends CMonitoringContext {
    protected String componentType;
    protected String componentInstanceName;
    protected Set<String> singletonPorts;
    protected CComponentTypeDescriptor componentDescriptor;

    public CComponentMonitoringContext(CFactory factory, String resultsDir) {
        super(factory, resultsDir);
    }

    public boolean isSingletonPort(String port) {
        return this.componentDescriptor.singletonPorts.contains(port);
    }

    public String getComponentInstanceName() {
        return this.componentInstanceName;
    }

    public CComponentMonitoringContext setComponentInstanceName(String name) {
        this.componentInstanceName = name;
        return this;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public CComponentMonitoringContext setComponentDescriptor(CComponentTypeDescriptor d) {
        this.componentType = d.componentType;
        this.componentDescriptor = d;
        return this;
    }

    public CInterfaceMonitoringContext createComponentTimeDataContext() {
        CInterfaceMonitoringContext context = new CInterfaceMonitoringContext("", false, null, this.resultsDir).setConnectionName(this.componentInstanceName).setLocalDir(String.valueOf(this.componentInstanceName) + "/" + "time_data/");
        context.skipTimeConstraints(this.timeConstraintsSkipped);
        context.skipDataConstraints(this.dataConstraintsSkipped);
        return context;
    }

    public String getResultsFile(String constraintName) {
        return String.valueOf(this.resultsDir) + this.componentInstanceName + "/" + constraintName + "/" + this.componentInstanceName + "_" + constraintName + "_results.txt";
    }

    public String getTraceFile(String constraintName) {
        return String.valueOf(this.resultsDir) + this.componentInstanceName + "/" + constraintName + "/" + this.componentInstanceName + "_" + constraintName + "_trace.txt";
    }

    public String getErrorUMLFile(String constraintName) {
        return String.valueOf(this.resultsDir) + this.componentInstanceName + "/" + constraintName + "/" + this.componentInstanceName + "_" + constraintName + "_error_sequence_diagram.plantuml";
    }
}

