/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Vector;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public class InputStreamMonitor {
    private OutputStream fStream;
    private Vector<byte[]> fQueue;
    private Thread fThread;
    private Object fLock;
    private boolean fClosed = false;
    private Charset fCharset;

    public InputStreamMonitor(OutputStream stream) {
        this(stream, (Charset)null);
    }

    public InputStreamMonitor(OutputStream stream, Charset charset) {
        this.fStream = stream;
        this.fQueue = new Vector();
        this.fLock = new Object();
        this.fCharset = charset;
    }

    @Deprecated
    public InputStreamMonitor(OutputStream stream, String encoding) {
        this(stream, Charset.forName(encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String text) {
        Object object = this.fLock;
        synchronized (object) {
            this.fQueue.add(this.fCharset == null ? text.getBytes() : text.getBytes(this.fCharset));
            this.fLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] data, int offset, int length) {
        Object object = this.fLock;
        synchronized (object) {
            byte[] copy = new byte[length];
            System.arraycopy(data, offset, copy, 0, length);
            this.fQueue.add(copy);
            this.fLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoring() {
        InputStreamMonitor inputStreamMonitor = this;
        synchronized (inputStreamMonitor) {
            if (this.fThread == null) {
                this.fThread = new Thread(this::write, DebugCoreMessages.InputStreamMonitor_label);
                this.fThread.setDaemon(true);
                this.fThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Thread thread = null;
        InputStreamMonitor inputStreamMonitor = this;
        synchronized (inputStreamMonitor) {
            thread = this.fThread;
            this.fThread = null;
        }
        if (thread != null) {
            thread.interrupt();
        }
    }

    protected void write() {
        while (this.fThread != null) {
            this.writeNext();
        }
        if (!this.fClosed) {
            try {
                this.fStream.close();
            }
            catch (IOException e) {
                DebugPlugin.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeNext() {
        while (!this.fQueue.isEmpty() && !this.fClosed) {
            byte[] data = this.fQueue.firstElement();
            this.fQueue.removeElementAt(0);
            try {
                this.fStream.write(data);
                this.fStream.flush();
            }
            catch (IOException e) {
                DebugPlugin.log(e);
            }
        }
        try {
            Object object = this.fLock;
            synchronized (object) {
                if (this.fQueue.isEmpty()) {
                    this.fLock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public void closeInputStream() throws IOException {
        if (this.fClosed) {
            throw new IOException();
        }
        this.fClosed = true;
        this.fStream.close();
    }
}

