/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.PrimitiveComparisonFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class PrimitiveComparisonCleanUpCore
extends AbstractCleanUpCore {
    public PrimitiveComparisonCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public PrimitiveComparisonCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        return new CleanUpRequirementsCore(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.primitive_comparison");
    }

    @Override
    public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.primitive_comparison")) {
            return null;
        }
        return PrimitiveComparisonFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.primitive_comparison")) {
            result.add(MultiFixMessages.PrimitiveComparisonCleanUp_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.primitive_comparison")) {
            return "int comparison = Integer.compare(number, anotherNumber);";
        }
        return "int comparison = Integer.valueOf(number).compareTo(anotherNumber);";
    }
}

