/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.core.DelegatingEngineExecutionListener;

class OutcomeDelayingEngineExecutionListener
extends DelegatingEngineExecutionListener {
    private final TestDescriptor engineDescriptor;
    private volatile boolean engineStarted;
    private volatile Outcome outcome;
    private volatile String skipReason;
    private volatile TestExecutionResult executionResult;

    OutcomeDelayingEngineExecutionListener(EngineExecutionListener delegate, TestDescriptor engineDescriptor) {
        super(delegate);
        this.engineDescriptor = engineDescriptor;
    }

    @Override
    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        if (testDescriptor == this.engineDescriptor) {
            this.outcome = Outcome.SKIPPED;
            this.skipReason = reason;
        } else {
            super.executionSkipped(testDescriptor, reason);
        }
    }

    @Override
    public void executionStarted(TestDescriptor testDescriptor) {
        if (testDescriptor == this.engineDescriptor) {
            this.engineStarted = true;
        }
        super.executionStarted(testDescriptor);
    }

    @Override
    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult executionResult) {
        if (testDescriptor == this.engineDescriptor) {
            this.outcome = Outcome.FINISHED;
            this.executionResult = executionResult;
        } else {
            super.executionFinished(testDescriptor, executionResult);
        }
    }

    void reportEngineOutcome() {
        if (this.outcome == Outcome.FINISHED) {
            super.executionFinished(this.engineDescriptor, this.executionResult);
        } else if (this.outcome == Outcome.SKIPPED) {
            super.executionSkipped(this.engineDescriptor, this.skipReason);
        }
    }

    void reportEngineFailure(Throwable throwable) {
        if (!this.engineStarted) {
            super.executionStarted(this.engineDescriptor);
        }
        if (this.executionResult != null && this.executionResult.getThrowable().isPresent()) {
            throwable.addSuppressed((Throwable)this.executionResult.getThrowable().get());
        }
        super.executionFinished(this.engineDescriptor, TestExecutionResult.failed((Throwable)throwable));
    }

    private static enum Outcome {
        SKIPPED,
        FINISHED;

    }
}

