/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.Collection;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.impldep.javax.annotation.Nullable;

public class MultipleBuildOperationFailures
extends DefaultMultiCauseException {
    private static final int MAX_CAUSES = 10;

    public MultipleBuildOperationFailures(Collection<? extends Throwable> causes, @Nullable String logLocation) {
        super(MultipleBuildOperationFailures.format(MultipleBuildOperationFailures.getFailureMessage(causes), causes, logLocation), causes);
    }

    private static String getFailureMessage(Collection<? extends Throwable> failures) {
        if (failures.size() == 1) {
            return "A build operation failed.";
        }
        return "Multiple build operations failed.";
    }

    private static String format(String message, Iterable<? extends Throwable> causes, @Nullable String logLocation) {
        StringBuilder sb = new StringBuilder(message);
        int count = 0;
        for (Throwable throwable : causes) {
            if (count++ >= 10) continue;
            sb.append(String.format("%n    %s", throwable.getMessage()));
        }
        int suppressedFailureCount = count - 10;
        if (suppressedFailureCount == 1) {
            sb.append(String.format("%n    ...and %d more failure.", suppressedFailureCount));
        } else if (suppressedFailureCount > 1) {
            sb.append(String.format("%n    ...and %d more failures.", suppressedFailureCount));
        }
        if (logLocation != null) {
            sb.append(String.format("%nSee the complete log at: ", new Object[0])).append(logLocation);
        }
        return sb.toString();
    }
}

