/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.buildship.core.internal.util.gradle.PublishedGradleVersions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public final class PublishedGradleVersionsWrapper {
    private final AtomicReference<PublishedGradleVersions> publishedGradleVersions = new AtomicReference();

    public PublishedGradleVersionsWrapper() {
        new LoadVersionsJob().schedule();
    }

    public List<GradleVersion> getVersions() {
        PublishedGradleVersions versions = this.publishedGradleVersions.get();
        return versions != null ? versions.getVersions() : ImmutableList.of((Object)GradleVersion.current());
    }

    private final class LoadVersionsJob
    extends Job {
        public LoadVersionsJob() {
            super("Loading available Gradle versions");
            this.setSystem(true);
            this.setRule(new ISchedulingRule(){

                public boolean isConflicting(ISchedulingRule rule) {
                    return rule == this;
                }

                public boolean contains(ISchedulingRule rule) {
                    return rule == this;
                }
            });
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                PublishedGradleVersions versions = PublishedGradleVersions.create(PublishedGradleVersions.LookupStrategy.REMOTE_IF_NOT_CACHED);
                PublishedGradleVersionsWrapper.this.publishedGradleVersions.set(versions);
            }
            catch (RuntimeException e) {
                CorePlugin.logger().warn("Could not load Gradle version information", e);
            }
            return Status.OK_STATUS;
        }

        protected void canceling() {
            Thread.currentThread().interrupt();
        }
    }
}

