/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.profiler.internal;

import org.eclipse.acceleo.aql.profiler.ProfileEntry;
import org.eclipse.acceleo.aql.profiler.ProfileResource;
import org.eclipse.acceleo.aql.profiler.ProfilerFactory;
import org.eclipse.acceleo.aql.profiler.internal.AbstractProfiler;
import org.eclipse.acceleo.aql.profiler.internal.Context;
import org.eclipse.emf.ecore.EObject;

public final class TreeProfiler
extends AbstractProfiler {
    private Context<? extends ProfileEntry> currentContext;
    private final ProfilerFactory profilerFactory;
    private final String startResource;
    private ProfileResource resource;

    public TreeProfiler(ProfilerFactory profilerFactory, String startResource) {
        this.profilerFactory = profilerFactory;
        this.startResource = startResource;
    }

    @Override
    public void reset() {
        this.currentContext = null;
        this.resource = null;
    }

    @Override
    public <L extends ProfileEntry> L start(EObject monitored) {
        Context<Object> nextContext;
        if (this.currentContext != null) {
            nextContext = this.currentContext.getChildContext(monitored, this.profilerFactory);
            nextContext.getcurrentEntry().start();
            this.currentContext.getcurrentEntry().getCallees().add(nextContext.getcurrentEntry());
        } else {
            ProfileEntry entry = this.profilerFactory.createProfileEntry();
            entry.setMonitored(monitored);
            if (this.resource == null) {
                this.resource = this.profilerFactory.createProfileResource();
                this.resource.setStartResource(this.startResource);
            }
            this.resource.setEntry(entry);
            entry.start();
            nextContext = new Context<ProfileEntry>(null, entry);
        }
        this.currentContext = nextContext;
        return (L)nextContext.getcurrentEntry();
    }

    @Override
    public <L extends ProfileEntry> L stop() {
        this.currentContext.getcurrentEntry().stop();
        ProfileEntry res = this.currentContext.getcurrentEntry();
        this.currentContext = this.currentContext.getParent();
        return (L)res;
    }

    @Override
    public ProfileResource getResource() {
        return this.resource;
    }
}

