/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.interpreter;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;

public final class IInterpreterContextUtils {
    private IInterpreterContextUtils() {
    }

    public static void configureInterpreter(IInterpreter interpreter, IInterpreterContext context) {
        Set<String> projectsOrBundleInScope = IInterpreterContextUtils.collectProjectsOrPlugins(context);
        interpreter.setProperty("files", projectsOrBundleInScope);
        LinkedHashSet<MetamodelDescriptor> availableMetamodels = new LinkedHashSet<MetamodelDescriptor>();
        for (EPackage pak : context.getAvailableEPackages()) {
            if (pak == null || pak.eResource() == null) continue;
            availableMetamodels.add((MetamodelDescriptor)new EcoreMetamodelDescriptor(pak));
        }
        interpreter.activateMetamodels(availableMetamodels);
        interpreter.clearImports();
        for (String dependency : context.getDependencies()) {
            interpreter.addImport(dependency);
        }
    }

    static Set<String> collectProjectsOrPlugins(IInterpreterContext context) {
        EObject vsmElement = context.getElement();
        LinkedHashSet<String> projectsOrBundleInScope = new LinkedHashSet<String>();
        if (vsmElement != null && vsmElement.eResource() != null) {
            IInterpreterContextUtils.collectProjectName(vsmElement.eResource(), projectsOrBundleInScope);
            if (vsmElement.eResource().getResourceSet() != null) {
                for (Resource other : vsmElement.eResource().getResourceSet().getResources()) {
                    if (other == vsmElement.eResource()) continue;
                    IInterpreterContextUtils.collectProjectName(other, projectsOrBundleInScope);
                }
            }
        }
        return projectsOrBundleInScope;
    }

    private static void collectProjectName(Resource eResource, Set<String> projectsOrBundleInScope) {
        String bundleOrProjectName;
        URI vsmURI;
        if (eResource.getURI() != null && eResource.getURI().segmentCount() >= 2 && (vsmURI = eResource.getURI()).isPlatform() && !StringUtil.isEmpty(bundleOrProjectName = vsmURI.segment(1))) {
            projectsOrBundleInScope.add(bundleOrProjectName);
        }
    }

    public static boolean haveSameScopeDefinition(IInterpreterContext a, IInterpreterContext b) {
        LinkedHashSet aDependencies = Sets.newLinkedHashSet(a.getDependencies());
        LinkedHashSet bDependencies = Sets.newLinkedHashSet(b.getDependencies());
        Set<String> aNSURI = IInterpreterContextUtils.collectNSUris(a);
        Set<String> bNSURI = IInterpreterContextUtils.collectNSUris(b);
        Set<String> aProjects = IInterpreterContextUtils.collectProjectsOrPlugins(a);
        Set<String> bProjects = IInterpreterContextUtils.collectProjectsOrPlugins(b);
        return aDependencies.equals(bDependencies) && aNSURI.equals(bNSURI) && aProjects.equals(bProjects);
    }

    private static Set<String> collectNSUris(IInterpreterContext a) {
        LinkedHashSet<String> aNSURI = new LinkedHashSet<String>();
        for (EPackage pak : a.getAvailableEPackages()) {
            String nsURI = pak.getNsURI();
            if (StringUtil.isEmpty(nsURI)) continue;
            aNSURI.add(nsURI);
        }
        return aNSURI;
    }
}

