/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.copy.FordiacCopyProcessor;
import org.eclipse.fordiac.ide.typemanagement.refactoring.copy.ICopyRefactoringQueries;
import org.eclipse.fordiac.ide.typemanagement.refactoring.copy.UserCopyRefactoringQueries;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.part.ResourceTransfer;

class SystemExplorerPasteAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.PasteAction";
    private final Shell shell;
    private final Clipboard clipboard;

    public SystemExplorerPasteAction(Shell shell, Clipboard clipboard) {
        super(WorkbenchNavigatorMessages.PasteAction_Past_);
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText(WorkbenchNavigatorMessages.PasteAction_Paste_selected_resource_s_);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "HelpId");
    }

    private IResource getTarget(IResource[] clipboardContent) {
        List selectedResources = this.getSelectedResources();
        if (clipboardContent != null && SystemExplorerPasteAction.areEqualsUnordered(selectedResources, Arrays.asList(clipboardContent))) {
            return ((IResource)selectedResources.get(0)).getParent();
        }
        for (IResource resource : selectedResources) {
            IProject proj;
            if (resource instanceof IProject && !(proj = (IProject)resource).isOpen()) {
                return null;
            }
            if (resource.getType() == 1) {
                resource = resource.getParent();
            }
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private static boolean areEqualsUnordered(Collection<? extends IResource> a, Collection<? extends IResource> b) {
        return b != null && a != null && !a.isEmpty() && a.size() == b.size() && a.containsAll(b);
    }

    private static boolean isLinked(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.isLinked()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void run() {
        ResourceTransfer resTransfer = ResourceTransfer.getInstance();
        IResource[] resourceData = (IResource[])this.clipboard.getContents((Transfer)resTransfer);
        if (resourceData == null || resourceData.length == 0) {
            return;
        }
        if (resourceData[0].getType() == 4) {
            this.pasteProjects(resourceData);
            return;
        }
        IContainer container = this.getContainer(resourceData);
        SystemExplorerPasteAction.startCopyRefactoring(resourceData, container, this.shell);
    }

    private void pasteProjects(IResource[] resourceData) {
        IResource[] iResourceArray = resourceData;
        int n = resourceData.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project;
            IResource res = iResourceArray[n2];
            if (res instanceof IProject && (project = (IProject)res).isOpen()) {
                String newName = this.queryNewProjectName(project);
                if (newName == null) {
                    return;
                }
                try {
                    NullProgressMonitor pm = new NullProgressMonitor();
                    IProjectDescription desc = project.getDescription();
                    desc.setName(newName);
                    desc.setLocation(null);
                    project.copy(desc, true, (IProgressMonitor)pm);
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)e.getStatus());
                    return;
                }
            }
            ++n2;
        }
    }

    private String queryNewProjectName(IProject project) {
        String base = project.getName();
        String initial = SystemExplorerPasteAction.suggestProjectCopyName(base);
        InputDialog dialog = new InputDialog(this.shell, Messages.SystemExplorerPasteAction_CopyProject, Messages.SystemExplorerPasteAction_newProjectName, initial, name -> {
            if (name == null || name.isBlank()) {
                return Messages.SystemExplorerPasteAction_nonEmptyProject;
            }
            IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 4);
            if (!status.isOK()) {
                return status.getMessage();
            }
            if (Objects.equals(name, base) || ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
                return Messages.SystemExplorerPasteAction_projectExists;
            }
            return null;
        });
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    private static String suggestProjectCopyName(String base) {
        String candidate = base + Messages.SystemExplorerPasteAction_copy;
        int i = 2;
        while (ResourcesPlugin.getWorkspace().getRoot().getProject(candidate).exists()) {
            candidate = base + Messages.SystemExplorerPasteAction_copy + i;
            ++i;
        }
        return candidate;
    }

    private static void startCopyRefactoring(IResource[] files, IContainer destination, Shell shell) {
        UserCopyRefactoringQueries refactorQueries = new UserCopyRefactoringQueries(shell);
        FordiacCopyProcessor processor = new FordiacCopyProcessor(files, destination, (ICopyRefactoringQueries)refactorQueries);
        ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
        CheckConditionsOperation checkOp = new CheckConditionsOperation((Refactoring)refactoring, 6);
        CreateChangeOperation changeOp = new CreateChangeOperation(checkOp, 3);
        try {
            NullProgressMonitor pm = new NullProgressMonitor();
            changeOp.run((IProgressMonitor)pm);
            Change change = changeOp.getChange();
            if (change != null) {
                change.perform((IProgressMonitor)pm);
            } else {
                FordiacLogHelper.logWarning((String)"copy refactoring change could not be created");
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)shell, null, null, (IStatus)e.getStatus());
        }
    }

    private IContainer getContainer(IResource[] clipboardContent) {
        List selection = this.getSelectedResources();
        if (clipboardContent != null && SystemExplorerPasteAction.areEqualsUnordered(selection, Arrays.asList(clipboardContent))) {
            return ((IResource)selection.get(0)).getParent();
        }
        if (selection.get(0) instanceof IFile) {
            return ((IResource)selection.get(0)).getParent();
        }
        return (IContainer)selection.get(0);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean isProjectRes;
        if (!super.updateSelection(selection)) {
            return false;
        }
        IResource[][] clipboardData = new IResource[1][];
        this.shell.getDisplay().syncExec(() -> {
            ResourceTransfer resTransfer = ResourceTransfer.getInstance();
            iResourceArray[0] = (IResource[])this.clipboard.getContents((Transfer)resTransfer);
        });
        IResource[] resourceData = clipboardData[0];
        boolean bl = isProjectRes = resourceData != null && resourceData.length > 0 && resourceData[0].getType() == 4;
        if (isProjectRes) {
            IResource[] iResourceArray = resourceData;
            int n = resourceData.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() != 4 || !((IProject)resource).isOpen()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (!this.getSelectedNonResources().isEmpty()) {
            return false;
        }
        IResource targetResource = this.getTarget(resourceData);
        if (targetResource == null) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() > 1) {
            if (!this.selectionIsOfType(3)) {
                return false;
            }
            for (IResource resource : selectedResources) {
                if (targetResource.equals((Object)resource.getParent())) continue;
                return false;
            }
        }
        if (resourceData != null) {
            return !SystemExplorerPasteAction.isLinked(resourceData) || targetResource.getType() == 4 || targetResource.getType() == 2;
        }
        TransferData[] transfers = this.clipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        TransferData[] transferDataArray = transfers;
        int n = transfers.length;
        int n3 = 0;
        while (n3 < n) {
            TransferData transfer = transferDataArray[n3];
            if (fileTransfer.isSupportedType(transfer)) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

