/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.formatting2;

import com.google.inject.Inject;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.KeywordCaseTextReplacer;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.KeywordTextReplacer;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.QualifiedNameReplacer;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreAutowrapFormatter;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreMultilineCommentReplacer;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreSinglelineCommentReplacer;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreTextReplacerContext;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreWhitespaceReplacer;
import org.eclipse.fordiac.ide.structuredtextcore.services.STCoreGrammarAccess;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAttribute;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallNamedInputArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallNamedOutputArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallUnnamedArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseCases;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCoreSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElementaryInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElseIfPart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElsePart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STImport;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMemberAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMultibitPartialExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STPragma;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSingleArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInOutDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarOutputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarPlainDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarTempDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ISubFormatter;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.resource.XtextResource;

public class STCoreFormatter
extends AbstractFormatter2 {
    @Inject
    private STCoreGrammarAccess grammarAccess;

    protected void _format(STCoreSource source, IFormattableDocument document) {
        this.formatSource((STSource)source, document);
        for (STStatement statement : source.getStatements()) {
            document.format((Object)statement);
        }
    }

    protected void formatSource(STSource source, IFormattableDocument document) {
        StreamSupport.stream(this.textRegionExtensions.allSemanticRegions((EObject)source).spliterator(), false).filter(it -> {
            boolean bl;
            EObject eObject;
            EObject eObject2 = it.getGrammarElement();
            Objects.requireNonNull(eObject2);
            EObject eObject3 = eObject = eObject2;
            int n = 0;
            block11: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Keyword.class, RuleCall.class, RuleCall.class, RuleCall.class, RuleCall.class, RuleCall.class, RuleCall.class, RuleCall.class, RuleCall.class}, (Object)eObject3, n)) {
                    case 0: {
                        Keyword element = (Keyword)eObject;
                        if (!element.getValue().matches("[_a-zA-Z]+")) {
                            eObject3 = eObject;
                            n = 1;
                            continue block11;
                        }
                        bl = true;
                        break block11;
                    }
                    case 1: {
                        RuleCall element = (RuleCall)eObject;
                        if (element.getRule() != this.grammarAccess.getNumericRule()) {
                            eObject3 = eObject;
                            n = 2;
                            continue block11;
                        }
                        bl = true;
                        break block11;
                    }
                    case 2: {
                        RuleCall element = (RuleCall)eObject;
                        if (element.getRule() != this.grammarAccess.getSignedNumericRule()) {
                            eObject3 = eObject;
                            n = 3;
                            continue block11;
                        }
                        bl = true;
                        break block11;
                    }
                    case 3: {
                        RuleCall element = (RuleCall)eObject;
                        if (element.getRule() != this.grammarAccess.getSTNumericLiteralTypeRule()) {
                            eObject3 = eObject;
                            n = 4;
                            continue block11;
                        }
                        bl = true;
                        break block11;
                    }
                    case 4: {
                        RuleCall element = (RuleCall)eObject;
                        if (element.getRule() != this.grammarAccess.getSTDateLiteralTypeRule()) {
                            eObject3 = eObject;
                            n = 5;
                            continue block11;
                        }
                        bl = true;
                        break block11;
                    }
                    case 5: {
                        RuleCall element = (RuleCall)eObject;
                        if (element.getRule() != this.grammarAccess.getSTTimeLiteralTypeRule()) {
                            eObject3 = eObject;
                            n = 6;
                            continue block11;
                        }
                        bl = true;
                        break block11;
                    }
                    case 6: {
                        RuleCall element = (RuleCall)eObject;
                        if (element.getRule() != this.grammarAccess.getOrOperatorRule()) {
                            eObject3 = eObject;
                            n = 7;
                            continue block11;
                        }
                        bl = true;
                        break block11;
                    }
                    case 7: {
                        RuleCall element = (RuleCall)eObject;
                        if (element.getRule() != this.grammarAccess.getXorOperatorRule()) {
                            eObject3 = eObject;
                            n = 8;
                            continue block11;
                        }
                        bl = true;
                        break block11;
                    }
                    case 8: {
                        RuleCall element = (RuleCall)eObject;
                        if (element.getRule() != this.grammarAccess.getUnaryOperatorRule()) {
                            eObject3 = eObject;
                            n = 9;
                            continue block11;
                        }
                        bl = true;
                        break block11;
                    }
                    default: {
                        bl = false;
                    }
                }
                break;
            }
            return bl;
        }).forEach(it -> document.addReplacer((ITextReplacer)new KeywordCaseTextReplacer((ITextSegment)it)));
        this.textRegionExtensions.allRegionsFor((EObject)source).keywords(new Keyword[]{this.grammarAccess.getSTPrimaryExpressionAccess().getLeftParenthesisKeyword_0_0()}).forEach(it -> {
            ISemanticRegion iSemanticRegion = document.append(it, IHiddenRegionFormatter::noSpace);
        });
        this.textRegionExtensions.allRegionsFor((EObject)source).keywords(new Keyword[]{this.grammarAccess.getSTPrimaryExpressionAccess().getRightParenthesisKeyword_0_2()}).forEach(it -> {
            ISemanticRegion iSemanticRegion = document.prepend(it, IHiddenRegionFormatter::noSpace);
        });
    }

    protected void formatPackage(STSource source, IFormattableDocument document) {
        ISemanticRegion packageKeyword = this.textRegionExtensions.regionFor((EObject)source).keyword("PACKAGE");
        ISemanticRegion semicolonKeyword = this.textRegionExtensions.regionFor((EObject)source).keyword(";");
        document.append(document.prepend(packageKeyword, IHiddenRegionFormatter::noSpace), IHiddenRegionFormatter::oneSpace);
        document.append(document.prepend(semicolonKeyword, IHiddenRegionFormatter::noSpace), it -> it.setNewLines(2));
    }

    protected void formatImports(EList<STImport> imports, IFormattableDocument document) {
        imports.forEach(it -> {
            document.format(it);
            if (it == imports.getLast()) {
                document.append(this.textRegionExtensions.regionFor((EObject)it).keyword(";"), format -> format.setNewLines(2, 2, 2));
            } else {
                document.append(this.textRegionExtensions.regionFor((EObject)it).keyword(";"), format -> format.setNewLines(1, 1, 2));
            }
        });
    }

    protected void _format(STImport imp, IFormattableDocument document) {
        ISemanticRegion importKeyword = this.textRegionExtensions.regionFor((EObject)imp).keyword(this.grammarAccess.getSTImportAccess().getIMPORTKeyword_0());
        document.prepend(importKeyword, IHiddenRegionFormatter::noIndentation);
        document.append(importKeyword, IHiddenRegionFormatter::oneSpace);
        ISemanticRegion semicolonKeyword = this.textRegionExtensions.regionFor((EObject)imp).keyword(this.grammarAccess.getSTImportAccess().getSemicolonKeyword_2());
        document.prepend(semicolonKeyword, IHiddenRegionFormatter::noSpace);
    }

    protected void formatVarDeclarationBlocks(EList<? extends STVarDeclarationBlock> varDeclarations, IFormattableDocument document) {
        varDeclarations.forEach(it -> {
            document.format(it);
            if (it == varDeclarations.getLast()) {
                document.append(this.textRegionExtensions.regionFor((EObject)it).keyword("END_VAR"), format -> format.setNewLines(1, 2, 2));
            } else {
                document.append(this.textRegionExtensions.regionFor((EObject)it).keyword("END_VAR"), format -> format.setNewLines(1, 1, 2));
            }
        });
    }

    protected void _format(STVarPlainDeclarationBlock varDeclarationBlock, IFormattableDocument document) {
        this.formatVarDeclarationBlock((STVarDeclarationBlock)varDeclarationBlock, document, "VAR");
    }

    protected void _format(STVarTempDeclarationBlock varDeclarationBlock, IFormattableDocument document) {
        this.formatVarDeclarationBlock((STVarDeclarationBlock)varDeclarationBlock, document, "VAR_TEMP");
    }

    protected void _format(STVarInputDeclarationBlock varDeclarationBlock, IFormattableDocument document) {
        this.formatVarDeclarationBlock((STVarDeclarationBlock)varDeclarationBlock, document, "VAR_INPUT");
    }

    protected void _format(STVarOutputDeclarationBlock varDeclarationBlock, IFormattableDocument document) {
        this.formatVarDeclarationBlock((STVarDeclarationBlock)varDeclarationBlock, document, "VAR_OUTPUT");
    }

    protected void _format(STVarInOutDeclarationBlock varDeclarationBlock, IFormattableDocument document) {
        this.formatVarDeclarationBlock((STVarDeclarationBlock)varDeclarationBlock, document, "VAR_IN_OUT");
    }

    protected void formatVarDeclarationBlock(STVarDeclarationBlock varDeclarationBlock, IFormattableDocument document, String begin) {
        ISemanticRegion varKeyword = this.textRegionExtensions.regionFor((EObject)varDeclarationBlock).keyword(begin);
        if (varDeclarationBlock.isConstant()) {
            ISemanticRegion constantKeyword = this.textRegionExtensions.regionFor((EObject)varDeclarationBlock).keyword("CONSTANT");
            document.prepend(constantKeyword, IHiddenRegionFormatter::oneSpace);
            document.append(constantKeyword, IHiddenRegionFormatter::newLine);
        } else {
            document.append(varKeyword, IHiddenRegionFormatter::newLine);
        }
        ISemanticRegion endVarKeyword = this.textRegionExtensions.regionFor((EObject)varDeclarationBlock).keyword("END_VAR");
        document.interior(varKeyword, endVarKeyword, IHiddenRegionFormatter::indent);
        varDeclarationBlock.getVarDeclarations().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
    }

    protected void _format(STVarDeclaration varDeclaration, IFormattableDocument document) {
        this.textRegionExtensions.regionFor((EObject)varDeclaration).keywords(new String[]{","}).forEach(it -> {
            document.prepend(it, IHiddenRegionFormatter::noSpace);
            document.append(it, IHiddenRegionFormatter::oneSpace);
        });
        this.textRegionExtensions.regionFor((EObject)varDeclaration).keywords(new String[]{":", ":="}).forEach(it -> {
            document.surround(it, IHiddenRegionFormatter::oneSpace);
            document.append(it, format -> {
                format.autowrap();
                format.setOnAutowrap((IAutowrapFormatter)new STCoreAutowrapFormatter(this.textRegionExtensions.nextHiddenRegion((EObject)varDeclaration)));
            });
        });
        ISemanticRegion typeRegion = this.textRegionExtensions.regionFor((EObject)varDeclaration).assignment(this.grammarAccess.getSTVarDeclarationAccess().getTypeAssignment_5());
        if (typeRegion != null) {
            document.addReplacer((ITextReplacer)new QualifiedNameReplacer((ITextSegment)typeRegion, (INamedElement)varDeclaration.getType()));
        }
        if (varDeclaration.isArray()) {
            document.prepend(this.textRegionExtensions.regionFor((EObject)varDeclaration).keyword("["), IHiddenRegionFormatter::noSpace);
            document.append(this.textRegionExtensions.regionFor((EObject)varDeclaration).keyword("]"), IHiddenRegionFormatter::oneSpace);
            this.formatList((List<? extends EObject>)varDeclaration.getRanges(), document);
        }
        document.format((Object)varDeclaration.getDefaultValue());
        document.prepend((EObject)varDeclaration.getPragma(), IHiddenRegionFormatter::oneSpace);
        document.format((Object)varDeclaration.getPragma());
        this.formatSemicolon((EObject)varDeclaration, document);
    }

    protected void _format(STPragma pragma, IFormattableDocument document) {
        this.formatBlock((EObject)pragma, (List<? extends EObject>)pragma.getAttributes(), this.textRegionExtensions.regionFor((EObject)pragma).keyword("{"), this.textRegionExtensions.regionFor((EObject)pragma).keyword("}"), document);
    }

    protected void _format(STAttribute attribute, IFormattableDocument document) {
        document.surround(this.textRegionExtensions.regionFor((EObject)attribute).keyword(":="), IHiddenRegionFormatter::oneSpace);
        document.format((Object)attribute.getValue());
    }

    protected void _format(STIfStatement ifStatement, IFormattableDocument document) {
        ISemanticRegion ifKeyword = this.textRegionExtensions.regionFor((EObject)ifStatement).keyword("IF");
        ISemanticRegion thenKeyword = this.textRegionExtensions.regionFor((EObject)ifStatement).keyword("THEN");
        ISemanticRegion endKeyword = !ifStatement.getElseifs().isEmpty() ? this.textRegionExtensions.regionFor((EObject)ifStatement.getElseifs().get(0)).keyword("ELSIF") : (ifStatement.getElse() != null ? this.textRegionExtensions.regionFor((EObject)ifStatement.getElse()).keyword("ELSE") : this.textRegionExtensions.regionFor((EObject)ifStatement).keyword("END_IF"));
        document.interior(thenKeyword, endKeyword, IHiddenRegionFormatter::indent);
        this.formatCondition((EObject)ifStatement.getCondition(), ifKeyword, thenKeyword, document);
        ifStatement.getStatements().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
        ifStatement.getElseifs().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
        document.format((Object)ifStatement.getElse());
        this.formatSemicolon((EObject)ifStatement, document);
    }

    protected void _format(STElseIfPart elseIfStatement, IFormattableDocument document) {
        this.formatCondition((EObject)elseIfStatement.getCondition(), this.textRegionExtensions.regionFor((EObject)elseIfStatement).keyword("ELSIF"), this.textRegionExtensions.regionFor((EObject)elseIfStatement).keyword("THEN"), document);
        elseIfStatement.getStatements().forEach(it -> {
            document.surround((EObject)it, IHiddenRegionFormatter::indent);
            document.format(it);
        });
    }

    protected void _format(STElsePart elseStatement, IFormattableDocument document) {
        document.append(this.textRegionExtensions.regionFor((EObject)elseStatement).keyword("ELSE"), IHiddenRegionFormatter::newLine);
        elseStatement.getStatements().forEach(it -> {
            document.surround((EObject)it, IHiddenRegionFormatter::indent);
            document.format(it);
        });
    }

    protected void _format(STForStatement forStatement, IFormattableDocument document) {
        ISemanticRegion doKeyword = this.textRegionExtensions.regionFor((EObject)forStatement).keyword("DO");
        ISemanticRegion endKeyword = this.textRegionExtensions.regionFor((EObject)forStatement).keyword("END_FOR");
        document.append(doKeyword, IHiddenRegionFormatter::newLine);
        document.interior(doKeyword, endKeyword, IHiddenRegionFormatter::indent);
        STCoreAutowrapFormatter autowrapFormatter = new STCoreAutowrapFormatter(doKeyword.getPreviousHiddenRegion());
        this.textRegionExtensions.regionFor((EObject)forStatement).keywords(new String[]{":="}).forEach(keyword -> {
            document.surround(keyword, IHiddenRegionFormatter::oneSpace);
            document.append(keyword, it -> {
                it.autowrap();
                it.setOnAutowrap((IAutowrapFormatter)autowrapFormatter);
            });
        });
        this.textRegionExtensions.regionFor((EObject)forStatement).keywords(new String[]{"TO", "BY"}).forEach(keyword -> {
            document.surround(keyword, IHiddenRegionFormatter::oneSpace);
            document.prepend(keyword, it -> {
                it.autowrap();
                it.setOnAutowrap((IAutowrapFormatter)autowrapFormatter);
            });
        });
        forStatement.getStatements().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
        this.formatSemicolon((EObject)forStatement, document);
    }

    protected void _format(STWhileStatement whileStatement, IFormattableDocument document) {
        ISemanticRegion beginKeyword = this.textRegionExtensions.regionFor((EObject)whileStatement).keyword("WHILE");
        ISemanticRegion doKeyword = this.textRegionExtensions.regionFor((EObject)whileStatement).keyword("DO");
        ISemanticRegion endKeyword = this.textRegionExtensions.regionFor((EObject)whileStatement).keyword("END_WHILE");
        document.append(doKeyword, IHiddenRegionFormatter::newLine);
        document.interior(doKeyword, endKeyword, IHiddenRegionFormatter::indent);
        this.formatCondition((EObject)whileStatement.getCondition(), beginKeyword, doKeyword, document);
        whileStatement.getStatements().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
        this.formatSemicolon((EObject)whileStatement, document);
    }

    protected void _format(STRepeatStatement repeatStatement, IFormattableDocument document) {
        ISemanticRegion beginKeyword = this.textRegionExtensions.regionFor((EObject)repeatStatement).keyword("REPEAT");
        ISemanticRegion untilKeyword = this.textRegionExtensions.regionFor((EObject)repeatStatement).keyword("UNTIL");
        ISemanticRegion endKeyword = this.textRegionExtensions.regionFor((EObject)repeatStatement).keyword("END_REPEAT");
        document.append(beginKeyword, IHiddenRegionFormatter::newLine);
        document.interior(beginKeyword, untilKeyword, IHiddenRegionFormatter::indent);
        document.format((Object)repeatStatement.getCondition());
        document.prepend(endKeyword, format -> {
            format.newLine();
            format.noSpace();
        });
        repeatStatement.getStatements().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
        this.formatSemicolon((EObject)repeatStatement, document);
    }

    protected void _format(STCaseStatement caseStatement, IFormattableDocument document) {
        ISemanticRegion beginKeyword = this.textRegionExtensions.regionFor((EObject)caseStatement).keyword("OF");
        ISemanticRegion endKeyword = this.textRegionExtensions.regionFor((EObject)caseStatement).keyword("END_CASE");
        document.append(beginKeyword, IHiddenRegionFormatter::newLine);
        document.interior(beginKeyword, endKeyword, IHiddenRegionFormatter::indent);
        caseStatement.getCases().forEach(arg_0 -> ((IFormattableDocument)document).format(arg_0));
        document.format((Object)caseStatement.getElse());
        this.formatSemicolon((EObject)caseStatement, document);
    }

    protected void _format(STCaseCases stCase, IFormattableDocument document) {
        ISemanticRegion colonKeyword = this.textRegionExtensions.regionFor((EObject)stCase).keyword(":");
        this.formatList((List<? extends EObject>)stCase.getConditions(), document);
        document.prepend(colonKeyword, IHiddenRegionFormatter::oneSpace);
        document.append(colonKeyword, IHiddenRegionFormatter::newLine);
        stCase.getStatements().forEach(it -> {
            document.surround((EObject)it, IHiddenRegionFormatter::indent);
            document.format(it);
        });
    }

    protected void _format(STAssignment assignment, IFormattableDocument document) {
        ISemanticRegion assignKeyword = this.textRegionExtensions.regionFor((EObject)assignment).keyword(":=");
        document.format((Object)assignment.getLeft());
        document.surround(assignKeyword, IHiddenRegionFormatter::oneSpace);
        document.append(assignKeyword, it -> {
            it.autowrap();
            it.setOnAutowrap((IAutowrapFormatter)new STCoreAutowrapFormatter(this.textRegionExtensions.nextHiddenRegion((EObject)assignment)));
        });
        document.format((Object)assignment.getRight());
        this.formatSemicolon((EObject)assignment, document);
    }

    protected void _format(STStatement statement, IFormattableDocument document) {
        this.formatSemicolon((EObject)statement, document);
    }

    protected static void _format(STElementaryInitializerExpression initExpression, IFormattableDocument document) {
        document.format((Object)initExpression.getValue());
    }

    protected void _format(STArrayInitializerExpression arrayInitExpression, IFormattableDocument document) {
        document.append(this.textRegionExtensions.regionFor((EObject)arrayInitExpression).keyword(this.grammarAccess.getSTArrayInitializerExpressionAccess().getLeftSquareBracketKeyword_0()), IHiddenRegionFormatter::noSpace);
        document.prepend(this.textRegionExtensions.regionFor((EObject)arrayInitExpression).keyword(this.grammarAccess.getSTArrayInitializerExpressionAccess().getRightSquareBracketKeyword_3()), IHiddenRegionFormatter::noSpace);
        this.formatList((List<? extends EObject>)arrayInitExpression.getValues(), document);
    }

    protected static void _format(STSingleArrayInitElement element, IFormattableDocument document) {
        document.format((Object)element.getInitExpression());
    }

    protected void _format(STRepeatArrayInitElement element, IFormattableDocument document) {
        document.surround(this.textRegionExtensions.regionFor((EObject)element).keyword(this.grammarAccess.getSTRepeatArrayInitElementAccess().getLeftParenthesisKeyword_1()), IHiddenRegionFormatter::noSpace);
        this.formatList((List<? extends EObject>)element.getInitExpressions(), document);
        document.prepend(this.textRegionExtensions.regionFor((EObject)element).keyword(this.grammarAccess.getSTRepeatArrayInitElementAccess().getRightParenthesisKeyword_4()), IHiddenRegionFormatter::noSpace);
    }

    protected void _format(STStructInitializerExpression structInitializerExpression, IFormattableDocument document) {
        document.surround(this.textRegionExtensions.regionFor((EObject)structInitializerExpression).keyword("#"), IHiddenRegionFormatter::noSpace);
        document.append(this.textRegionExtensions.regionFor((EObject)structInitializerExpression).keyword(this.grammarAccess.getSTStructInitializerExpressionAccess().getLeftParenthesisKeyword_1()), IHiddenRegionFormatter::noSpace);
        this.formatList((List<? extends EObject>)structInitializerExpression.getValues(), document);
        document.prepend(this.textRegionExtensions.regionFor((EObject)structInitializerExpression).keyword(this.grammarAccess.getSTStructInitializerExpressionAccess().getRightParenthesisKeyword_4()), IHiddenRegionFormatter::noSpace);
    }

    protected void _format(STStructInitElement element, IFormattableDocument document) {
        ISemanticRegion assignmentKeyword = this.textRegionExtensions.regionFor((EObject)element).keyword(":=");
        document.surround(assignmentKeyword, IHiddenRegionFormatter::oneSpace);
        document.append(assignmentKeyword, format -> {
            format.autowrap();
            format.setOnAutowrap((IAutowrapFormatter)new STCoreAutowrapFormatter(this.textRegionExtensions.nextHiddenRegion((EObject)element)));
        });
        document.format((Object)element.getValue());
    }

    protected void _format(STBinaryExpression binaryExpression, IFormattableDocument document) {
        ISemanticRegion opRegion = this.textRegionExtensions.regionFor((EObject)binaryExpression).feature((EStructuralFeature)STCorePackage.Literals.ST_BINARY_EXPRESSION__OP);
        if (opRegion != null) {
            if (binaryExpression.getOp() != STBinaryOperator.RANGE) {
                document.surround(opRegion, IHiddenRegionFormatter::oneSpace);
                document.prepend(opRegion, format -> {
                    format.autowrap(opRegion.getLength() + this.textRegionExtensions.regionForEObject((EObject)binaryExpression.getRight()).getLength());
                    format.setOnAutowrap((IAutowrapFormatter)new STCoreAutowrapFormatter(this.textRegionExtensions.nextHiddenRegion((EObject)binaryExpression)));
                });
            }
            switch (binaryExpression.getOp()) {
                case AMPERSAND: {
                    document.addReplacer((ITextReplacer)new KeywordTextReplacer((ITextSegment)opRegion, STBinaryOperator.AND.toString()));
                    break;
                }
                case AND: {
                    document.addReplacer((ITextReplacer)new KeywordCaseTextReplacer((ITextSegment)opRegion));
                    break;
                }
            }
        }
        document.format((Object)binaryExpression.getLeft());
        document.format((Object)binaryExpression.getRight());
        this.formatSemicolon((EObject)binaryExpression, document);
    }

    protected void _format(STUnaryExpression unaryExpression, IFormattableDocument document) {
        ISemanticRegion opRange = this.textRegionExtensions.regionFor((EObject)unaryExpression).feature((EStructuralFeature)STCorePackage.Literals.ST_UNARY_EXPRESSION__OP);
        if (unaryExpression.getOp() == STUnaryOperator.NOT) {
            document.append(opRange, IHiddenRegionFormatter::oneSpace);
        } else {
            document.append(opRange, IHiddenRegionFormatter::noSpace);
        }
        document.format((Object)unaryExpression.getExpression());
        this.formatSemicolon((EObject)unaryExpression, document);
    }

    protected void _format(STMemberAccessExpression mExpression, IFormattableDocument document) {
        ISemanticRegion dotKeyword = this.textRegionExtensions.regionFor((EObject)mExpression).keyword(".");
        document.surround(dotKeyword, IHiddenRegionFormatter::noSpace);
        document.prepend(dotKeyword, format -> {
            format.autowrap(this.textRegionExtensions.regionForEObject((EObject)mExpression.getMember()).getLength());
            format.setOnAutowrap((IAutowrapFormatter)new STCoreAutowrapFormatter(this.textRegionExtensions.nextHiddenRegion((EObject)mExpression)));
        });
        document.format((Object)mExpression.getMember());
        document.format((Object)mExpression.getReceiver());
        this.formatSemicolon((EObject)mExpression, document);
    }

    protected void _format(STFeatureExpression featureExpression, IFormattableDocument document) {
        document.surround(this.textRegionExtensions.regionFor((EObject)featureExpression).keyword(this.grammarAccess.getSTFeatureExpressionAccess().getCallLeftParenthesisKeyword_2_0_0()), IHiddenRegionFormatter::noSpace);
        document.prepend(this.textRegionExtensions.regionFor((EObject)featureExpression).keyword(this.grammarAccess.getSTFeatureExpressionAccess().getRightParenthesisKeyword_2_2()), IHiddenRegionFormatter::noSpace);
        this.formatList((List<? extends EObject>)featureExpression.getParameters(), document);
        this.formatSemicolon((EObject)featureExpression, document);
    }

    protected void _format(STBuiltinFeatureExpression featureExpression, IFormattableDocument document) {
        document.surround(this.textRegionExtensions.regionFor((EObject)featureExpression).keyword(this.grammarAccess.getSTBuiltinFeatureExpressionAccess().getCallLeftParenthesisKeyword_2_0_0()), IHiddenRegionFormatter::noSpace);
        document.prepend(this.textRegionExtensions.regionFor((EObject)featureExpression).keyword(this.grammarAccess.getSTBuiltinFeatureExpressionAccess().getRightParenthesisKeyword_2_2()), IHiddenRegionFormatter::noSpace);
        this.formatList((List<? extends EObject>)featureExpression.getParameters(), document);
        this.formatSemicolon((EObject)featureExpression, document);
    }

    protected void _format(STMultibitPartialExpression mBPExpression, IFormattableDocument document) {
        document.surround(this.textRegionExtensions.regionFor((EObject)mBPExpression).assignment(this.grammarAccess.getSTMultibitPartialExpressionAccess().getSpecifierAssignment_1()), IHiddenRegionFormatter::noSpace);
        document.append(this.textRegionExtensions.regionFor((EObject)mBPExpression).keyword(this.grammarAccess.getSTMultibitPartialExpressionAccess().getLeftParenthesisKeyword_2_1_0()), IHiddenRegionFormatter::noSpace);
        document.prepend(this.textRegionExtensions.regionFor((EObject)mBPExpression).keyword(this.grammarAccess.getSTMultibitPartialExpressionAccess().getRightParenthesisKeyword_2_1_2()), IHiddenRegionFormatter::noSpace);
        document.format((Object)mBPExpression.getExpression());
        this.formatSemicolon((EObject)mBPExpression, document);
    }

    protected static void _format(STCallUnnamedArgument unnamedArgument, IFormattableDocument document) {
        document.format((Object)unnamedArgument.getArgument());
    }

    protected void _format(STCallNamedInputArgument namedInputArgument, IFormattableDocument document) {
        ISemanticRegion assignmentKeyword = this.textRegionExtensions.regionFor((EObject)namedInputArgument).keyword(":=");
        document.surround(assignmentKeyword, IHiddenRegionFormatter::oneSpace);
        document.append(assignmentKeyword, format -> {
            format.autowrap();
            format.setOnAutowrap((IAutowrapFormatter)new STCoreAutowrapFormatter(this.textRegionExtensions.nextHiddenRegion((EObject)namedInputArgument)));
        });
        document.format((Object)namedInputArgument.getArgument());
    }

    protected void _format(STCallNamedOutputArgument namedOutputArgument, IFormattableDocument document) {
        ISemanticRegion assignmentKeyword = this.textRegionExtensions.regionFor((EObject)namedOutputArgument).keyword("=>");
        if (namedOutputArgument.isNot()) {
            document.append(this.textRegionExtensions.regionFor((EObject)namedOutputArgument).keyword("NOT"), IHiddenRegionFormatter::oneSpace);
        }
        document.surround(assignmentKeyword, IHiddenRegionFormatter::oneSpace);
        document.append(assignmentKeyword, it -> {
            it.autowrap();
            it.setOnAutowrap((IAutowrapFormatter)new STCoreAutowrapFormatter(this.textRegionExtensions.nextHiddenRegion((EObject)namedOutputArgument)));
        });
        document.format((Object)namedOutputArgument.getArgument());
    }

    protected void _format(STArrayAccessExpression arrayAccessExpression, IFormattableDocument document) {
        document.format((Object)arrayAccessExpression.getReceiver());
        document.append(this.textRegionExtensions.regionFor((EObject)arrayAccessExpression).keyword(this.grammarAccess.getSTAccessExpressionAccess().getLeftSquareBracketKeyword_1_1_1()), IHiddenRegionFormatter::noSpace);
        document.prepend(this.textRegionExtensions.regionFor((EObject)arrayAccessExpression).keyword(this.grammarAccess.getSTAccessExpressionAccess().getRightSquareBracketKeyword_1_1_4()), IHiddenRegionFormatter::noSpace);
        this.formatList((List<? extends EObject>)arrayAccessExpression.getIndex(), document);
        this.formatSemicolon((EObject)arrayAccessExpression, document);
    }

    protected void formatBlock(EObject blockElement, List<? extends EObject> listElements, ISemanticRegion begin, ISemanticRegion end, IFormattableDocument document) {
        if (this.textRegionExtensions.isMultiline(blockElement)) {
            this.formatBlockMultiline(listElements, begin, end, document);
        } else {
            document.formatConditionally(begin.getOffset(), end.getEndOffset() - begin.getOffset(), new ISubFormatter[]{subDocument -> this.formatBlockSingleline(listElements, begin, end, (IFormattableDocument)subDocument.requireFitsInLine()), subDocument -> this.formatBlockMultiline(listElements, begin, end, (IFormattableDocument)subDocument)});
        }
    }

    protected void formatBlockSingleline(List<? extends EObject> listElements, ISemanticRegion begin, ISemanticRegion end, IFormattableDocument document) {
        document.append(begin, IHiddenRegionFormatter::noSpace);
        document.prepend(end, IHiddenRegionFormatter::noSpace);
        this.formatList(listElements, document);
    }

    protected void formatBlockMultiline(List<? extends EObject> listElements, ISemanticRegion begin, ISemanticRegion end, IFormattableDocument document) {
        document.append(begin, IHiddenRegionFormatter::newLine);
        document.interior(begin, end, IHiddenRegionFormatter::indent);
        document.prepend(end, IHiddenRegionFormatter::newLine);
        this.formatListMultiline(listElements, document);
    }

    protected void formatList(List<? extends EObject> semanticElements, IFormattableDocument document) {
        if (!semanticElements.isEmpty()) {
            STCoreAutowrapFormatter autowrapFormatter = new STCoreAutowrapFormatter(this.textRegionExtensions.nextHiddenRegion(semanticElements.getLast()));
            semanticElements.forEach(it -> {
                int autowrapLength = this.textRegionExtensions.regionForEObject(it).getLength();
                ISemanticRegion commaKeyword = this.textRegionExtensions.immediatelyPreceding(it).keyword(",");
                document.prepend(commaKeyword, IHiddenRegionFormatter::noSpace);
                document.append(commaKeyword, format -> {
                    format.oneSpace();
                    format.autowrap(autowrapLength);
                    format.setOnAutowrap((IAutowrapFormatter)autowrapFormatter);
                });
                document.format(it);
            });
        }
    }

    protected void formatListMultiline(List<? extends EObject> semanticElements, IFormattableDocument document) {
        semanticElements.forEach(it -> {
            ISemanticRegion commaKeyword = this.textRegionExtensions.immediatelyPreceding(it).keyword(",");
            document.prepend(commaKeyword, IHiddenRegionFormatter::noSpace);
            document.append(commaKeyword, IHiddenRegionFormatter::newLine);
            document.format(it);
        });
    }

    protected void formatCondition(EObject semanticElement, ISemanticRegion begin, ISemanticRegion end, IFormattableDocument document) {
        if (this.textRegionExtensions.isMultiline(semanticElement)) {
            document.format((Object)semanticElement);
            document.prepend(end, IHiddenRegionFormatter::newLine);
        } else {
            document.formatConditionally(begin.getOffset(), end.getEndOffset() - begin.getOffset(), new ISubFormatter[]{subDocument -> STCoreFormatter.formatSinglelineCondition(semanticElement, end, (IFormattableDocument)subDocument.requireFitsInLine()), subDocument -> STCoreFormatter.formatMultilineCondition(semanticElement, end, (IFormattableDocument)subDocument)});
        }
        document.append(end, IHiddenRegionFormatter::newLine);
    }

    protected static void formatSinglelineCondition(EObject semanticElement, ISemanticRegion end, IFormattableDocument document) {
        document.format((Object)semanticElement);
        document.prepend(end, IHiddenRegionFormatter::oneSpace);
    }

    protected static void formatMultilineCondition(EObject semanticElement, ISemanticRegion end, IFormattableDocument document) {
        document.format((Object)semanticElement);
        document.prepend(end, IHiddenRegionFormatter::newLine);
    }

    protected void formatSemicolon(EObject semanticElement, IFormattableDocument document) {
        ISemanticRegion semicolonKeyword = this.textRegionExtensions.regionFor(semanticElement).keyword(";");
        document.surround(semicolonKeyword, IHiddenRegionFormatter::noSpace);
        document.append(semicolonKeyword, it -> it.setNewLines(1, 1, 2));
    }

    public ITextReplacer createCommentReplacer(IComment comment) {
        EObject grammarElement = comment.getGrammarElement();
        if (grammarElement instanceof AbstractRule) {
            AbstractRule rule = (AbstractRule)grammarElement;
            String ruleName = rule.getName();
            if (ruleName.startsWith("ML")) {
                return new STCoreMultilineCommentReplacer(comment, '*');
            }
            if (ruleName.startsWith("SL")) {
                return new STCoreSinglelineCommentReplacer(comment, "//");
            }
        }
        return super.createCommentReplacer(comment);
    }

    public ITextReplacerContext createTextReplacerContext(IFormattableDocument document) {
        return new STCoreTextReplacerContext(document);
    }

    public ITextReplacer createWhitespaceReplacer(ITextSegment hiddens, IHiddenRegionFormatting formatting) {
        return new STCoreWhitespaceReplacer(hiddens, formatting);
    }

    public void format(Object object, IFormattableDocument document) {
        Object object2 = object;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STArrayAccessExpression.class, STAssignment.class, STBinaryExpression.class, STBuiltinFeatureExpression.class, STFeatureExpression.class, STMemberAccessExpression.class, STMultibitPartialExpression.class, STUnaryExpression.class, STVarDeclaration.class, STArrayInitializerExpression.class, STCallNamedInputArgument.class, STCallNamedOutputArgument.class, STCallUnnamedArgument.class, STCaseStatement.class, STCoreSource.class, STElementaryInitializerExpression.class, STForStatement.class, STIfStatement.class, STImport.class, STRepeatArrayInitElement.class, STRepeatStatement.class, STSingleArrayInitElement.class, STStructInitializerExpression.class, STVarInOutDeclarationBlock.class, STVarInputDeclarationBlock.class, STVarOutputDeclarationBlock.class, STVarPlainDeclarationBlock.class, STVarTempDeclarationBlock.class, STWhileStatement.class, STAttribute.class, STCaseCases.class, STElseIfPart.class, STElsePart.class, STPragma.class, STStatement.class, STStructInitElement.class, STVarDeclarationBlock.class, EObject.class, XtextResource.class}, (Object)object2, 0)) {
            case 0: {
                STArrayAccessExpression element = (STArrayAccessExpression)object2;
                this._format(element, document);
                break;
            }
            case 1: {
                STAssignment element = (STAssignment)object2;
                this._format(element, document);
                break;
            }
            case 2: {
                STBinaryExpression element = (STBinaryExpression)object2;
                this._format(element, document);
                break;
            }
            case 3: {
                STBuiltinFeatureExpression element = (STBuiltinFeatureExpression)object2;
                this._format(element, document);
                break;
            }
            case 4: {
                STFeatureExpression element = (STFeatureExpression)object2;
                this._format(element, document);
                break;
            }
            case 5: {
                STMemberAccessExpression element = (STMemberAccessExpression)object2;
                this._format(element, document);
                break;
            }
            case 6: {
                STMultibitPartialExpression element = (STMultibitPartialExpression)object2;
                this._format(element, document);
                break;
            }
            case 7: {
                STUnaryExpression element = (STUnaryExpression)object2;
                this._format(element, document);
                break;
            }
            case 8: {
                STVarDeclaration element = (STVarDeclaration)object2;
                this._format(element, document);
                break;
            }
            case 9: {
                STArrayInitializerExpression element = (STArrayInitializerExpression)object2;
                this._format(element, document);
                break;
            }
            case 10: {
                STCallNamedInputArgument element = (STCallNamedInputArgument)object2;
                this._format(element, document);
                break;
            }
            case 11: {
                STCallNamedOutputArgument element = (STCallNamedOutputArgument)object2;
                this._format(element, document);
                break;
            }
            case 12: {
                STCallUnnamedArgument element = (STCallUnnamedArgument)object2;
                STCoreFormatter._format(element, document);
                break;
            }
            case 13: {
                STCaseStatement element = (STCaseStatement)object2;
                this._format(element, document);
                break;
            }
            case 14: {
                STCoreSource element = (STCoreSource)object2;
                this._format(element, document);
                break;
            }
            case 15: {
                STElementaryInitializerExpression element = (STElementaryInitializerExpression)object2;
                STCoreFormatter._format(element, document);
                break;
            }
            case 16: {
                STForStatement element = (STForStatement)object2;
                this._format(element, document);
                break;
            }
            case 17: {
                STIfStatement element = (STIfStatement)object2;
                this._format(element, document);
                break;
            }
            case 18: {
                STImport element = (STImport)object2;
                this._format(element, document);
                break;
            }
            case 19: {
                STRepeatArrayInitElement element = (STRepeatArrayInitElement)object2;
                this._format(element, document);
                break;
            }
            case 20: {
                STRepeatStatement element = (STRepeatStatement)object2;
                this._format(element, document);
                break;
            }
            case 21: {
                STSingleArrayInitElement element = (STSingleArrayInitElement)object2;
                STCoreFormatter._format(element, document);
                break;
            }
            case 22: {
                STStructInitializerExpression element = (STStructInitializerExpression)object2;
                this._format(element, document);
                break;
            }
            case 23: {
                STVarInOutDeclarationBlock element = (STVarInOutDeclarationBlock)object2;
                this._format(element, document);
                break;
            }
            case 24: {
                STVarInputDeclarationBlock element = (STVarInputDeclarationBlock)object2;
                this._format(element, document);
                break;
            }
            case 25: {
                STVarOutputDeclarationBlock element = (STVarOutputDeclarationBlock)object2;
                this._format(element, document);
                break;
            }
            case 26: {
                STVarPlainDeclarationBlock element = (STVarPlainDeclarationBlock)object2;
                this._format(element, document);
                break;
            }
            case 27: {
                STVarTempDeclarationBlock element = (STVarTempDeclarationBlock)object2;
                this._format(element, document);
                break;
            }
            case 28: {
                STWhileStatement element = (STWhileStatement)object2;
                this._format(element, document);
                break;
            }
            case 29: {
                STAttribute element = (STAttribute)object2;
                this._format(element, document);
                break;
            }
            case 30: {
                STCaseCases element = (STCaseCases)object2;
                this._format(element, document);
                break;
            }
            case 31: {
                STElseIfPart element = (STElseIfPart)object2;
                this._format(element, document);
                break;
            }
            case 32: {
                STElsePart element = (STElsePart)object2;
                this._format(element, document);
                break;
            }
            case 33: {
                STPragma element = (STPragma)object2;
                this._format(element, document);
                break;
            }
            case 34: {
                STStatement element = (STStatement)object2;
                this._format(element, document);
                break;
            }
            case 35: {
                STStructInitElement element = (STStructInitElement)object2;
                this._format(element, document);
                break;
            }
            case 36: {
                STVarDeclarationBlock element = (STVarDeclarationBlock)object2;
                this._format((EObject)element, document);
                break;
            }
            case 37: {
                EObject element = (EObject)object2;
                this._format(element, document);
                break;
            }
            case 38: {
                XtextResource element = (XtextResource)object2;
                this._format(element, document);
                break;
            }
            default: {
                this._format(object, document);
            }
        }
    }
}

