/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.embedded;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.resource.STAlgorithmResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

public final class STAlgorithmEmbeddedEditorUtil {
    private static final URI SYNTHETIC_URI = URI.createURI((String)"__synthetic.stalg");
    private static final IResourceServiceProvider SERVICE_PROVIDER = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(SYNTHETIC_URI);

    private STAlgorithmEmbeddedEditorUtil() {
    }

    public static EmbeddedEditorFactory getEmbeddedEditorFactory() {
        return (EmbeddedEditorFactory)SERVICE_PROVIDER.get(EmbeddedEditorFactory.class);
    }

    public static void updateEditor(EmbeddedEditor editor, INamedElement element) {
        EObject _rootContainer;
        URI _elvis = null;
        Resource _eResource = null;
        if (element != null) {
            _eResource = element.eResource();
        }
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        _elvis = _uRI != null ? _uRI : SYNTHETIC_URI;
        LibraryElement _switchResult = null;
        EObject root = _rootContainer = EcoreUtil.getRootContainer((EObject)element);
        boolean _matched = false;
        if (root instanceof LibraryElement) {
            _matched = true;
            _switchResult = (LibraryElement)root;
        }
        STAlgorithmEmbeddedEditorUtil.updateEditor(editor, _elvis, _switchResult, null, STCoreUtil.getFeatureType((INamedElement)element));
    }

    public static void updateEditor(EmbeddedEditor editor, URI uri, LibraryElement type, Collection<? extends EObject> additionalContent, INamedElement expectedType) {
        Pair _mappedTo = Pair.of((Object)STResource.OPTION_EXPECTED_TYPE, (Object)expectedType);
        STAlgorithmEmbeddedEditorUtil.updateEditor(editor, uri, type, additionalContent, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
    }

    public static void updateEditor(EmbeddedEditor editor, URI uri, LibraryElement type, Collection<? extends EObject> additionalContent, Map<?, ?> loadOptions) {
        XtextDocument _document = editor.getDocument();
        if (_document != null) {
            IUnitOfWork _function = resource -> {
                Object _xblockexpression = null;
                if (uri != null) {
                    resource.setURI(uri);
                } else {
                    resource.setURI(SYNTHETIC_URI);
                }
                if (resource instanceof STAlgorithmResource) {
                    ((STAlgorithmResource)resource).setLibraryElement(type);
                    ((STAlgorithmResource)resource).setIncludeInternalLibraryElement(type instanceof BaseFBType);
                    ((STAlgorithmResource)resource).getAdditionalContent().clear();
                    if (additionalContent != null) {
                        ((STAlgorithmResource)resource).getAdditionalContent().addAll(additionalContent);
                    }
                    if (loadOptions != null) {
                        ((STAlgorithmResource)resource).getDefaultLoadOptions().putAll(loadOptions);
                        ResourceSet _resourceSet = ((STAlgorithmResource)resource).getResourceSet();
                        Map _loadOptions = null;
                        if (_resourceSet != null) {
                            _loadOptions = _resourceSet.getLoadOptions();
                        }
                        if (_loadOptions != null) {
                            _loadOptions.putAll(loadOptions);
                        }
                    }
                }
                _xblockexpression = null;
                return _xblockexpression;
            };
            _document.internalModify(_function);
        }
    }
}

