/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.osgi.service.prefs.BackingStoreException;

public class MostRecentlyUsedTracker {
    private static final String PREF_NODE = "org.eclipse.fordiac.ide.gef";
    private static final String PREF_KEY = "mru_fb_types";
    private static final String DELIMITER = ";";
    private static final int MAX_MRU_ITEMS = 5;
    private IEclipsePreferences preferences;
    private IProject currentProject;
    private LinkedList<String> mruList;
    private boolean disposed = false;

    public MostRecentlyUsedTracker(IProject project) {
        this.currentProject = project;
        if (project != null && project.exists()) {
            ProjectScope projectScope = new ProjectScope(project);
            this.preferences = projectScope.getNode(PREF_NODE);
            this.loadFromPreferences();
            System.out.println("[MRU] Initialized for project: " + project.getName());
            System.out.println("[MRU] Loaded " + this.mruList.size() + " items: " + String.valueOf(this.mruList));
        } else {
            this.preferences = null;
            this.mruList = new LinkedList();
        }
    }

    public synchronized void recordUsage(TypeEntry typeEntry) {
        if (this.disposed || typeEntry == null) {
            return;
        }
        if (this.currentProject == null || !this.currentProject.exists()) {
            return;
        }
        String fbTypeName = typeEntry.getFullTypeName();
        if (fbTypeName == null || fbTypeName.isEmpty()) {
            return;
        }
        this.mruList.remove(fbTypeName);
        this.mruList.addFirst(fbTypeName);
        while (this.mruList.size() > 5) {
            this.mruList.removeLast();
        }
        this.saveToPreferences();
        System.out.println("[MRU] Recorded usage: " + fbTypeName);
        System.out.println("[MRU] Current list: " + String.valueOf(this.mruList));
    }

    public synchronized List<String> getMRUList() {
        if (this.disposed || this.currentProject == null || !this.currentProject.exists()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.mruList);
    }

    public synchronized void clear() {
        if (this.disposed) {
            return;
        }
        this.mruList.clear();
        this.saveToPreferences();
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.preferences = null;
        this.currentProject = null;
        this.mruList.clear();
    }

    private void loadFromPreferences() {
        this.mruList = new LinkedList();
        if (this.preferences == null || this.disposed) {
            return;
        }
        try {
            String stored = this.preferences.get(PREF_KEY, "");
            if (stored != null && !stored.isEmpty()) {
                String[] items;
                String[] stringArray = items = stored.split(DELIMITER);
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (!item.isEmpty()) {
                        this.mruList.add(item);
                    }
                    ++n2;
                }
            }
        }
        catch (IllegalStateException e) {
            System.out.println("[MRU] Preference node removed, cannot load");
        }
        catch (Exception e) {
            System.err.println("[MRU] Failed to load preferences: " + e.getMessage());
        }
    }

    private void saveToPreferences() {
        if (this.preferences == null || this.disposed) {
            return;
        }
        if (this.currentProject == null || !this.currentProject.exists()) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.mruList.size()) {
                if (i > 0) {
                    sb.append(DELIMITER);
                }
                sb.append(this.mruList.get(i));
                ++i;
            }
            this.preferences.put(PREF_KEY, sb.toString());
            this.preferences.flush();
        }
        catch (IllegalStateException e) {
            System.out.println("[MRU] Preference node removed, cannot save");
            this.disposed = true;
        }
        catch (BackingStoreException e) {
            System.err.println("[MRU] Failed to save preferences: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Unexpected error saving MRU: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public IProject getProject() {
        return this.currentProject;
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

