/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationChannel;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationMappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.MappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;

public class MappingAnnotations {
    public static MappingTarget getMappingTarget(FBNetworkElement el) {
        if (el instanceof CommunicationChannel) {
            return (MappingTarget)el.getMapping().getTo().eContainer();
        }
        return el.getResource();
    }

    public static List<MappingTarget> getPossibleMappingTargets(EObject obj) {
        if (obj instanceof CommunicationChannel) {
            CommunicationChannel commCh = (CommunicationChannel)obj;
            return MappingAnnotations.getContainedCommunicationMappingTargets(commCh.getFbNetwork().getAutomationSystem());
        }
        if (obj instanceof FBNetworkElement) {
            FBNetworkElement fbnEl = (FBNetworkElement)obj;
            return MappingAnnotations.getContainedMappingTargets(fbnEl.getFbNetwork().getAutomationSystem());
        }
        if (obj instanceof FBNetwork) {
            FBNetwork network = (FBNetwork)obj;
            return MappingAnnotations.getContainedMappingTargets(network.getAutomationSystem());
        }
        return Collections.emptyList();
    }

    public static List<MappingTarget> getContainedMappingTargets(EObject obj) {
        if (obj instanceof AutomationSystem) {
            AutomationSystem system = (AutomationSystem)obj;
            return system.getSystemConfiguration().getDevices().stream().flatMap(dev -> dev.getResource().stream()).collect(Collectors.toList());
        }
        if (obj instanceof Device) {
            Device dev2 = (Device)obj;
            return new ArrayList<MappingTarget>((Collection<MappingTarget>)dev2.getResource());
        }
        return Collections.emptyList();
    }

    public static List<MappingTarget> getContainedCommunicationMappingTargets(EObject obj) {
        Segment segment;
        CommunicationConfiguration communication;
        if (obj instanceof AutomationSystem) {
            AutomationSystem system = (AutomationSystem)obj;
            return system.getSystemConfiguration().getSegments().stream().map(Segment::getCommunication).filter(Objects::nonNull).flatMap(comm -> comm.getMappingTargets().stream()).collect(Collectors.toList());
        }
        if (obj instanceof Segment && (communication = (segment = (Segment)obj).getCommunication()) != null) {
            return new ArrayList<MappingTarget>((Collection<MappingTarget>)communication.getMappingTargets());
        }
        return Collections.emptyList();
    }

    public static boolean containsMappingTargets(EObject obj) {
        return obj instanceof Device || obj instanceof Segment || obj instanceof MappingTarget;
    }

    public static boolean isMapable(FBNetwork network) {
        return network != null && !network.isSubApplicationNetwork() && !network.isCFBTypeNetwork() && !(network.eContainer() instanceof MappingTarget);
    }

    public static String getHierarchicalName(MappingTarget target) {
        if (target instanceof Resource) {
            Resource res = (Resource)target;
            return res.getDevice().getName() + "." + res.getName();
        }
        if (target instanceof CommunicationMappingTarget && target.eContainer() != null) {
            return ((Segment)target.eContainer().eContainer()).getName() + "." + target.getName();
        }
        return target.toString();
    }

    public static String getHierarchicalName(FBNetworkElement element) {
        if (element instanceof CommunicationChannel) {
            EObject eObject = element.eContainer();
            if (eObject instanceof MappingTarget) {
                MappingTarget mt = (MappingTarget)eObject;
                return MappingAnnotations.getHierarchicalName(mt);
            }
            return MappingAnnotations.getHierarchicalName((MappingTarget)element.getOpposite().eContainer());
        }
        return MappingAnnotations.getHierarchicalName(element.getResource());
    }

    private MappingAnnotations() {
        throw new UnsupportedOperationException();
    }
}

