/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public class LibraryElementDependencyTracker
extends EContentAdapter {
    private final Map<TypeEntry, AtomicInteger> dependencies = new ConcurrentHashMap<TypeEntry, AtomicInteger>();

    public Set<TypeEntry> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies.keySet());
    }

    public void notifyChanged(Notification notification) {
        EStructuralFeature structuralFeature;
        Object object = notification.getFeature();
        if (object instanceof EStructuralFeature && LibraryElementDependencyTracker.isRelevant(structuralFeature = (EStructuralFeature)object)) {
            switch (notification.getEventType()) {
                case 1: {
                    this.setValue(notification.getOldValue(), notification.getNewValue());
                    break;
                }
                case 3: 
                case 5: {
                    this.addValue(notification.getNewValue());
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.removeValue(notification.getOldValue());
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void addAdapter(Notifier notifier) {
        super.addAdapter(notifier);
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            eObject.eClass().getEAllStructuralFeatures().stream().filter(LibraryElementDependencyTracker::isRelevant).map(arg_0 -> ((EObject)eObject).eGet(arg_0)).forEach(this::addValue);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            eObject.eClass().getEAllStructuralFeatures().stream().filter(LibraryElementDependencyTracker::isRelevant).map(arg_0 -> ((EObject)eObject).eGet(arg_0)).forEach(this::removeValue);
        }
        super.removeAdapter(notifier);
    }

    protected void setValue(Object oldValue, Object newValue) {
        this.addValue(newValue);
        this.removeValue(oldValue);
    }

    protected void addValue(Object object) {
        Object object2 = object;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Collection.class, LibraryElement.class, TypeEntry.class}, (Object)object2, 0)) {
            case 0: {
                Collection collection = (Collection)object2;
                collection.forEach(this::addValue);
                break;
            }
            case 1: {
                LibraryElement libraryElement = (LibraryElement)object2;
                this.addDependency(libraryElement.getTypeEntry());
                break;
            }
            case 2: {
                TypeEntry typeEntry = (TypeEntry)object2;
                this.addDependency(typeEntry);
                break;
            }
        }
    }

    protected void removeValue(Object object) {
        Object object2 = object;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Collection.class, LibraryElement.class, TypeEntry.class}, (Object)object2, 0)) {
            case 0: {
                Collection collection = (Collection)object2;
                collection.forEach(this::removeValue);
                break;
            }
            case 1: {
                LibraryElement libraryElement = (LibraryElement)object2;
                this.removeDependency(libraryElement.getTypeEntry());
                break;
            }
            case 2: {
                TypeEntry typeEntry = (TypeEntry)object2;
                this.removeDependency(typeEntry);
                break;
            }
        }
    }

    protected boolean addDependency(TypeEntry typeEntry) {
        return typeEntry != null && this.dependencies.computeIfAbsent(typeEntry, unused -> new AtomicInteger()).getAndIncrement() == 0;
    }

    protected boolean removeDependency(TypeEntry typeEntry) {
        return typeEntry != null && this.dependencies.computeIfPresent(typeEntry, (unused, old) -> old.decrementAndGet() == 0 ? null : old) == null;
    }

    protected static boolean isRelevant(EStructuralFeature structuralFeature) {
        boolean bl;
        EStructuralFeature eStructuralFeature;
        EStructuralFeature eStructuralFeature2 = structuralFeature;
        Objects.requireNonNull(eStructuralFeature2);
        EStructuralFeature eStructuralFeature3 = eStructuralFeature = eStructuralFeature2;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EAttribute.class, EReference.class}, (Object)eStructuralFeature3, n)) {
                case 0: {
                    EAttribute attribute = (EAttribute)eStructuralFeature;
                    if (attribute.getEAttributeType() == LibraryElementPackage.Literals.TYPE_ENTRY) {
                        bl = true;
                        break block4;
                    }
                    bl = false;
                    break block4;
                }
                case 1: {
                    EReference reference = (EReference)eStructuralFeature;
                    if (reference.isContainment()) {
                        eStructuralFeature3 = eStructuralFeature;
                        n = 2;
                        continue block4;
                    }
                    bl = LibraryElementPackage.Literals.LIBRARY_ELEMENT.isSuperTypeOf(reference.getEReferenceType());
                    break block4;
                }
                default: {
                    bl = false;
                }
            }
            break;
        }
        return bl;
    }

    protected boolean useRecursion() {
        return false;
    }
}

