/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.widgets;

import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public final class OpenStructMenu {
    public static void addTo(final TableViewer viewer) {
        final Menu menu = new Menu(viewer.getControl());
        final MenuItem openItem = OpenStructMenu.createMenuItem(viewer, menu);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                TableItem[] selection = viewer.getTable().getSelection();
                if (selection.length > 0 && !(selection[0].getData() instanceof Event) && !(selection[0].getData() instanceof AdapterDeclaration)) {
                    StructuredType type = OpenStructMenu.getSelectedStructuredType((Item[])selection);
                    openItem.setEnabled(type != null && type != IecTypes.GenericTypes.ANY_STRUCT);
                } else {
                    openItem.setEnabled(false);
                    menu.setVisible(false);
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        viewer.getControl().setMenu(menu);
    }

    private static MenuItem createMenuItem(final TableViewer viewer, Menu menu) {
        MenuItem openItem = new MenuItem(menu, 0);
        openItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredType sel = OpenStructMenu.getSelectedStructuredType((Item[])viewer.getTable().getSelection());
                if (sel != null) {
                    OpenStructMenu.openStructEditor(sel.getTypeEntry().getFile());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        openItem.setText(FordiacMessages.OPEN_TYPE_EDITOR_MESSAGE);
        return openItem;
    }

    private static StructuredType getSelectedStructuredType(Item[] selected) {
        VarDeclaration varDecl;
        if (selected.length > 0 && selected[0].getData() instanceof VarDeclaration && (varDecl = (VarDeclaration)selected[0].getData()).getType() instanceof StructuredType) {
            return (StructuredType)varDecl.getType();
        }
        return null;
    }

    public static void openStructEditor(IFile file) {
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            try {
                activePage.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            }
            catch (PartInitException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void addTo(Control control, MenuListener listener, SelectionListener selectionListener) {
        Menu menu = new Menu(control);
        MenuItem openItem = new MenuItem(menu, 0);
        openItem.addSelectionListener(selectionListener);
        openItem.setText(FordiacMessages.OPEN_TYPE_EDITOR_MESSAGE);
        menu.addMenuListener(listener);
        control.setMenu(menu);
    }

    private OpenStructMenu() {
        throw new UnsupportedOperationException();
    }
}

