/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.types;

import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class SearchChildrenProviderHelper {
    private SearchChildrenProviderHelper() {
    }

    public static Stream<? extends EObject> getFBTypeChildren(FBType fbType) {
        Stream<? extends EObject> retval = SearchChildrenProviderHelper.getInterfaceListChildren(fbType.getInterfaceList());
        retval = Stream.concat(retval, fbType.getAttributes().stream());
        if (fbType instanceof BaseFBType) {
            BaseFBType baseFBType = (BaseFBType)fbType;
            retval = Stream.concat(retval, baseFBType.getInternalVars().stream());
            retval = Stream.concat(retval, baseFBType.getInternalConstVars().stream());
        }
        if (fbType instanceof SubAppType) {
            SubAppType subappType = (SubAppType)fbType;
            retval = Stream.concat(retval, subappType.getFBNetwork().getNetworkElements().stream());
            retval = Stream.concat(retval, subappType.getFBNetwork().getAdapterConnections().stream());
            retval = Stream.concat(retval, subappType.getFBNetwork().getDataConnections().stream());
            retval = Stream.concat(retval, subappType.getFBNetwork().getEventConnections().stream());
        }
        return retval;
    }

    public static Stream<? extends EObject> getUntypedSubappChildren(UntypedSubApp untypedSubapp) {
        Stream<? extends EObject> retval = SearchChildrenProviderHelper.getInterfaceListChildren(untypedSubapp.getInterface());
        retval = Stream.concat(retval, untypedSubapp.getSubAppNetwork().getNetworkElements().stream());
        retval = Stream.concat(retval, untypedSubapp.getAttributes().stream());
        return retval;
    }

    public static Stream<? extends EObject> getInterfaceListChildren(InterfaceList interfaceList) {
        Stream retval = Stream.concat(interfaceList.getInputVars().stream(), interfaceList.getOutputVars().stream());
        retval = Stream.concat(retval, interfaceList.getInOutVars().stream());
        return retval;
    }

    public static Stream<? extends EObject> getAttributeDeclChildren(AttributeDeclaration attrdecl) {
        Stream<VarDeclaration> retval = attrdecl.getAttributes().stream();
        AnyDerivedType anyDerivedType = attrdecl.getType();
        if (anyDerivedType instanceof StructuredType) {
            StructuredType structType = (StructuredType)anyDerivedType;
            retval = Stream.concat(retval, SearchChildrenProviderHelper.getStructChildren(structType));
        } else {
            AnyDerivedType anyDerivedType2 = attrdecl.getType();
            if (anyDerivedType2 instanceof DirectlyDerivedType) {
                DirectlyDerivedType directType = (DirectlyDerivedType)anyDerivedType2;
                retval = Stream.concat(retval, Stream.of(directType.getBaseType()));
            }
        }
        return retval;
    }

    public static Stream<VarDeclaration> getStructChildren(StructuredType structType) {
        return structType.getMemberVariables().stream();
    }
}

