/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.text.MessageFormat;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.search.Match;
import org.eclipse.fordiac.ide.model.search.Messages;

public class TextMatch
extends Match {
    private final int line;
    private final int offset;
    private final int length;

    public TextMatch(URI uri, int line, int offset, int length, String type) {
        super(uri, MessageFormat.format(Messages.TextMatch_Location, line, offset, length), type);
        this.line = line;
        this.offset = offset;
        this.length = length;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.offset + this.length + this.line;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextMatch other = (TextMatch)obj;
        return this.length == other.length && this.line == other.line && this.offset == other.offset;
    }

    @Override
    public String toString() {
        return String.format("%s [uri=%s, location=%s, type=%s, line=%s, offset=%s, length=%s]", this.getClass().getName(), this.getUri(), this.getLocation(), this.getType(), this.line, this.offset, this.length);
    }
}

