/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.search.ISearchContext;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractLiveSearchContext
implements ISearchContext {
    private final TypeLibrary typelib;

    protected AbstractLiveSearchContext(TypeLibrary typelib) {
        this.typelib = typelib;
    }

    protected AbstractLiveSearchContext(IProject project) {
        this(Objects.requireNonNull(TypeLibraryManager.INSTANCE.getTypeLibrary(project)));
    }

    @Override
    public EObject mapTypes(URI uri) {
        TypeEntry typeEntry = Objects.requireNonNull(TypeLibraryManager.INSTANCE.getTypeEntryForURI(uri));
        return AbstractLiveSearchContext.getLiveType(typeEntry);
    }

    public static void executeAndSave(Command cmd, EObject modelObj, IProgressMonitor pm) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)EcoreUtil.getRootContainer((EObject)modelObj));
        if (rootContainer instanceof LibraryElement) {
            LibraryElement elem = (LibraryElement)rootContainer;
            TypeEntry entry = elem.getTypeEntry();
            IEditorPart editor = AbstractLiveSearchContext.getEditor(entry);
            AbstractLiveSearchContext.execute(cmd, editor);
            AbstractLiveSearchContext.save(entry, elem, editor, pm);
        }
    }

    public static void execute(Command cmd, TypeEntry typeEntry) {
        IEditorPart editor = AbstractLiveSearchContext.getEditor(typeEntry);
        AbstractLiveSearchContext.execute(cmd, editor);
    }

    public static void save(TypeEntry typeEntry) {
        IEditorPart editor = AbstractLiveSearchContext.getEditor(typeEntry);
        AbstractLiveSearchContext.save(typeEntry, AbstractLiveSearchContext.getLiveType(typeEntry), editor, (IProgressMonitor)new NullProgressMonitor());
    }

    protected TypeLibrary getTypelib() {
        return this.typelib;
    }

    private static LibraryElement getLiveType(TypeEntry typeEntry) {
        IEditorPart editor = AbstractLiveSearchContext.getEditor(typeEntry);
        if (editor == null) {
            return typeEntry.getType();
        }
        LibraryElement libElement = (LibraryElement)editor.getAdapter(LibraryElement.class);
        if (libElement != null) {
            return libElement;
        }
        FordiacLogHelper.logError((String)("It was not possible to find a type for the typeEntry: " + typeEntry.getFullTypeName()));
        return null;
    }

    private static IEditorPart getEditor(TypeEntry typeEntry) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        return (IEditorPart)Display.getDefault().syncCall(() -> {
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                IWorkbenchWindow[] workbenchWindows = workbench.getWorkbenchWindows();
                if (workbench.getWorkbenchWindows().length > 0 && workbenchWindows[0].getActivePage() != null) {
                    IWorkbenchPage activePage = workbenchWindows[0].getActivePage();
                    IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
                    int n = iEditorReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference ref = iEditorReferenceArray[n2];
                        try {
                            FileEditorInput fileInput;
                            IEditorInput editorInput = ref.getEditorInput();
                            if (editorInput instanceof FileEditorInput && (fileInput = (FileEditorInput)editorInput).getFile().equals((Object)typeEntry.getFile())) {
                                return ref.getEditor(true);
                            }
                        }
                        catch (PartInitException e) {
                            FordiacLogHelper.logWarning((String)"Could not open Editor for type entry in search", (Exception)((Object)e));
                        }
                        ++n2;
                    }
                }
                return null;
            }
            return activeWorkbenchWindow.getActivePage().findEditor((IEditorInput)new FileEditorInput(typeEntry.getFile()));
        });
    }

    private static void execute(Command cmd, IEditorPart editor) {
        if (editor != null) {
            Display.getDefault().syncExec(() -> ((CommandStack)editor.getAdapter(CommandStack.class)).execute(cmd));
        } else if (cmd.canExecute()) {
            cmd.execute();
        }
    }

    private static void save(TypeEntry typeEntry, LibraryElement libraryElement, IEditorPart editor, IProgressMonitor pm) {
        try {
            typeEntry.save(libraryElement, pm);
            if (editor != null) {
                Display.getDefault().syncExec(() -> ((CommandStack)editor.getAdapter(CommandStack.class)).markSaveLocation());
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)("Saving TypeEntry " + typeEntry.getFullTypeName() + " failed"), (Throwable)e);
        }
    }
}

