/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.st;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.search.st.StructuredTextSearchSupport;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.STAlgorithmParseUtil;
import org.eclipse.xtext.parser.IParseResult;

public class DirectlyDerivedTypeSearchSupport
extends StructuredTextSearchSupport {
    private final DirectlyDerivedType directlyDerivedType;
    private IParseResult parseResult;

    public DirectlyDerivedTypeSearchSupport(DirectlyDerivedType directlyDerivedType) {
        this.directlyDerivedType = directlyDerivedType;
    }

    @Override
    public Set<String> getImportedNamespaces() {
        Set<String> result = super.getImportedNamespaces();
        if (!PackageNameHelper.getPackageName((LibraryElement)this.directlyDerivedType.getBaseType()).isEmpty()) {
            result.add(PackageNameHelper.getFullTypeName((LibraryElement)this.directlyDerivedType.getBaseType()));
        }
        return result;
    }

    @Override
    public Stream<EObject> prepare() {
        return Optional.ofNullable(this.prepareInitialValue()).map(IParseResult::getRootASTElement).stream();
    }

    protected IParseResult prepareInitialValue() {
        if (this.parseResult == null && this.directlyDerivedType.getInitialValue() != null && !this.directlyDerivedType.getInitialValue().isBlank()) {
            this.parseResult = STAlgorithmParseUtil.parseInitializerExpression((String)this.directlyDerivedType.getInitialValue(), (INamedElement)this.directlyDerivedType.getBaseType(), (EObject)this.directlyDerivedType);
        }
        return this.parseResult;
    }

    public boolean isIncompleteResult() {
        return this.parseResult != null && this.parseResult.hasSyntaxErrors();
    }
}

