/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.provider;

import java.util.function.Supplier;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.TextualAnnotationStyles;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;

public class PackageLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final Supplier<GraphicalAnnotationModel> annotationModelSupplier;

    public PackageLabelProvider(Supplier<GraphicalAnnotationModel> annotationModelSupplier) {
        this.annotationModelSupplier = annotationModelSupplier;
    }

    public StyledString getStyledText(Object element) {
        GraphicalAnnotationModel annotationModel = this.annotationModelSupplier.get();
        if (element instanceof Import) {
            Import imp = (Import)element;
            if (annotationModel != null) {
                return new StyledString(imp.getImportedNamespace(), TextualAnnotationStyles.getAnnotationStyle(annotationModel.getAnnotations(imp)));
            }
            return new StyledString(imp.getImportedNamespace());
        }
        return null;
    }
}

