/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.editparts.FigureCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.InitialValueDirectEditManager;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.figures.ValueToolTipFigure;
import org.eclipse.fordiac.ide.gef.policies.ValueEditPartChangeEditPolicy;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueRefreshJob;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.ui.IEditorPart;

public class ValueEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
AnnotableGraphicalEditPart {
    private InterfaceEditPart parentPart;
    private InitialValueRefreshJob refreshJob;
    private final Adapter contentAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getValue_Value().equals(feature) || LibraryElementPackage.eINSTANCE.getIInterfaceElement_Type().equals(feature)) {
                ValueEditPart.this.refreshValue();
                ValueEditPart.this.refreshPosition();
            }
            super.notifyChanged(notification);
        }
    };

    public int getMaxWidth() {
        int maxLabelSize = ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getMaxValueLabelSize();
        FontMetrics fm = FigureUtilities.getFontMetrics((Font)JFaceResources.getFontRegistry().get("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
        return (int)((double)(maxLabelSize + 2) * fm.getAverageCharacterWidth());
    }

    public void activate() {
        super.activate();
        this.getModel().eAdapters().add((Object)this.contentAdapter);
        this.getModel().getParentIE().eAdapters().add((Object)this.contentAdapter);
        EditPart editPart = this.getViewer().getEditPartForModel((Object)this.getModel().getParentIE());
        if (editPart instanceof InterfaceEditPart) {
            InterfaceEditPart iep;
            this.parentPart = iep = (InterfaceEditPart)editPart;
            final IFigure parentFigure = this.parentPart.getFigure();
            parentFigure.addAncestorListener(new AncestorListener(){

                public void ancestorRemoved(IFigure ancestor) {
                }

                public void ancestorMoved(IFigure ancestor) {
                    if (parentFigure == ancestor) {
                        ValueEditPart.this.refreshVisuals();
                    }
                }

                public void ancestorAdded(IFigure ancestor) {
                }
            });
        }
        this.refreshVisuals();
        this.refreshValue();
    }

    protected Point calculatePos() {
        if (this.parentPart != null) {
            Rectangle bounds = this.parentPart.getFigure().getBounds();
            int x = 0;
            x = this.isInput() ? bounds.x - 2 - this.calculateWidth() : bounds.x + bounds.width + 2;
            int y = bounds.y;
            return new Point(x, y);
        }
        return new Point(0, 0);
    }

    protected void refreshPosition() {
        if (this.getParent() != null) {
            Rectangle bounds = null;
            Point p = this.calculatePos();
            bounds = new Rectangle(p.x, p.y, this.calculateWidth(), -1);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getFigure(), (Object)bounds);
        }
    }

    private int calculateWidth() {
        int width = this.getFigure().getPreferredSize().width;
        width = Math.max(40, width);
        width = Math.min(width, this.getMaxWidth());
        return width;
    }

    public void deactivate() {
        super.deactivate();
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
            this.refreshJob = null;
        }
        this.getModel().eAdapters().remove((Object)this.contentAdapter);
        if (this.getModel().getParentIE() != null) {
            this.getModel().getParentIE().eAdapters().remove((Object)this.contentAdapter);
        }
    }

    @Override
    public void updateAnnotations(GraphicalAnnotationModelEvent event) {
        GraphicalAnnotationStyles.updateAnnotationFeedback((IFigure)this.getFigure(), this.getModel(), event);
        this.getFigure().setToolTip((IFigure)new ValueToolTipFigure(this.getIInterfaceElement(), this.getModel(), event.getModel()));
        this.refreshValue();
    }

    void refreshValue() {
        if (this.getModel().getValue() != null) {
            this.setVisible(true);
            if (this.getOuterConnections().isEmpty() || this.valueHasAnnotation()) {
                if (!this.getModel().getValue().isBlank()) {
                    this.getFigure().setText(this.getModel().getValue());
                    this.getFigure().setFont(null);
                    this.getFigure().setForegroundColor(ColorConstants.menuForeground);
                } else {
                    this.getFigure().setText(FordiacMessages.ComputingPlaceholderValue);
                    InitialValueRefreshJob valueRefresh = this.getRefreshJob();
                    if (valueRefresh != null) {
                        valueRefresh.refresh();
                    }
                    this.getFigure().setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
                    this.getFigure().setForegroundColor(ColorConstants.gray);
                }
            } else {
                this.getFigure().setText("");
            }
        } else {
            this.setVisible(false);
        }
        this.getFigure().setToolTip((IFigure)new ValueToolTipFigure(this.getIInterfaceElement(), this.getModel(), FordiacAnnotationUtil.getAnnotationModel((EditPart)this)));
    }

    private boolean valueHasAnnotation() {
        return this.getFigure().getBorder() instanceof GraphicalAnnotationStyles.AnnotationBorder;
    }

    protected void updateDefaultValue(String value) {
        if (this.isActive() && FordiacMessages.ComputingPlaceholderValue.equals(this.getFigure().getText())) {
            if (value.length() <= ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getMaxDefaultValueLength()) {
                this.getFigure().setText(value);
            } else {
                this.getFigure().setText(FordiacMessages.ValueTooLarge);
            }
        }
    }

    protected IInterfaceElement getDefaultValueContext() {
        return this.getIInterfaceElement();
    }

    private EList<Connection> getOuterConnections() {
        IInterfaceElement model = this.getIInterfaceElement();
        if (model.isIsInput()) {
            return model.getInputConnections();
        }
        return model.getOutputConnections();
    }

    public void refresh() {
        super.refresh();
        this.refreshValue();
        this.refreshPosition();
    }

    public Label getFigure() {
        return (Label)super.getFigure();
    }

    public void setVisible(boolean visible) {
        this.getFigure().setVisible(visible);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshPosition();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ValueEditPartChangeEditPolicy());
    }

    public Value getModel() {
        return (Value)super.getModel();
    }

    public boolean isInput() {
        IInterfaceElement interfaceElement = this.getIInterfaceElement();
        if (interfaceElement != null) {
            return interfaceElement.isIsInput();
        }
        return false;
    }

    private IInterfaceElement getIInterfaceElement() {
        return this.getModel().getParentIE();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new FixedAnchor((IFigure)this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new FixedAnchor((IFigure)this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new FixedAnchor((IFigure)this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new FixedAnchor((IFigure)this.getFigure(), this.isInput());
    }

    protected IFigure createFigure() {
        return new ValueFigure(this.isInput());
    }

    public DirectEditManager createDirectEditManager() {
        IInterfaceElement interfaceElement = this.getIInterfaceElement();
        if (interfaceElement instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)interfaceElement;
            return new InitialValueDirectEditManager(this, new FigureCellEditorLocator((IFigure)this.getFigure()), varDecl, this.getDirectEditInitialValue());
        }
        return new LabelDirectEditManager((GraphicalEditPart)this, this.getFigure());
    }

    protected String getDirectEditInitialValue() {
        String text = this.getFigure().getText();
        if (FordiacMessages.ComputingPlaceholderValue.equals(text) || FordiacMessages.ValueTooLarge.equals(text)) {
            return "";
        }
        return text;
    }

    public void performDirectEdit() {
        this.createDirectEditManager().show();
    }

    public void performRequest(Request request) {
        FBNetworkElement fb = this.getModel().getParentIE().getFBNetworkElement();
        IEditorPart editor = EditorUtils.getCurrentActiveEditor();
        if (!(ValueEditPart.isTypedInstance(fb) || editor.getAdapter(FBNetwork.class) == null || request.getType() != "direct edit" && request.getType() != "open")) {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    private static boolean isTypedInstance(FBNetworkElement fb) {
        return fb != null && fb.isContainedInTypedInstance();
    }

    private InitialValueRefreshJob getRefreshJob() {
        if (this.refreshJob == null && this.isActive()) {
            this.refreshJob = new InitialValueRefreshJob(this.getDefaultValueContext(), this::updateDefaultValue);
        }
        return this.refreshJob;
    }

    private static class ValueFigure
    extends Label {
        public ValueFigure(boolean input) {
            this.setOpaque(false);
            if (input) {
                this.setLabelAlignment(4);
                this.setTextAlignment(2);
                this.setTextPlacement(16);
            } else {
                this.setLabelAlignment(1);
                this.setTextAlignment(1);
            }
        }

        protected String getTruncationString() {
            return "\u2026";
        }
    }
}

