/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.IExportFilter;
import org.eclipse.fordiac.ide.export.Messages;
import org.eclipse.fordiac.ide.export.utils.ExportFilterUtil;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.CMakeListsMarker;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class Exporter {
    private final String outputDirectory;
    private final IConfigurationElement filterConfig;
    private boolean overwriteWithoutWarning;
    private boolean enableCMakeLists;
    private final IExportFilter filter;

    public Exporter(IConfigurationElement filterConfig, String outputDirectory, boolean overwriteWithoutWarning, boolean enableCMakeLists) {
        this.filterConfig = filterConfig;
        this.outputDirectory = outputDirectory;
        this.overwriteWithoutWarning = overwriteWithoutWarning;
        this.enableCMakeLists = enableCMakeLists;
        this.filter = ExportFilterUtil.createExportFilter(Optional.of(filterConfig));
    }

    public void exportElements(IProgressMonitor monitor, List<IFile> exportees) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.FordiacExporter_ExportingSelectedTypesUsingExporter, this.filterConfig.getAttribute("name")), (int)exportees.size());
        if (this.filter == null) {
            return;
        }
        for (IFile file : exportees) {
            try {
                this.exportElement(progress.split(1), this.filter, file, null);
            }
            catch (ExportException.OverwriteAll e) {
                this.overwriteWithoutWarning = true;
            }
            catch (ExportException.CancelAll e) {
                this.enableCMakeLists = false;
                this.filter.getWarnings().add(Messages.FordiacExporter_EXPORT_CANCELED);
                break;
            }
            catch (ExportException.UserInteraction userInteraction) {
                // empty catch block
            }
        }
        if (this.enableCMakeLists) {
            try {
                this.exportElement(progress.split(1), this.filter, null, (EObject)new CMakeListsMarker(exportees.getFirst().getProject(), Path.of(this.outputDirectory, new String[0])));
            }
            catch (ExportException.UserInteraction userInteraction) {
                // empty catch block
            }
        }
    }

    public IExportFilter getExportFilter() {
        return this.filter;
    }

    private void exportElement(SubMonitor monitor, IExportFilter filter, IFile file, EObject source) throws ExportException.UserInteraction {
        try {
            if (source instanceof CMakeListsMarker) {
                monitor.subTask(Messages.FordiacExporter_ExportingCMakeLists);
                filter.export(null, this.outputDirectory, this.overwriteWithoutWarning, source);
            } else {
                monitor.subTask(MessageFormat.format(Messages.FordiacExporter_ExportingType, Exporter.getExportElementName(source, file)));
                filter.export(file, this.outputDirectory, this.overwriteWithoutWarning, source);
            }
        }
        catch (ExportException.UserInteraction e) {
            throw e;
        }
        catch (ExportException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    private static String getExportElementName(EObject element, IFile file) {
        String name = "anonymous";
        if (element instanceof INamedElement) {
            INamedElement ne = (INamedElement)element;
            name = ne.getName();
        } else if (file != null) {
            name = file.getFullPath().removeFileExtension().lastSegment();
        }
        return name;
    }
}

