/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499.executors;

import java.io.EOFException;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.DevResponseFactory;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.iec61499.Messages;
import org.eclipse.fordiac.ide.deployment.iec61499.ResponseMapping;
import org.eclipse.fordiac.ide.deployment.iec61499.handlers.EthernetDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.interactors.AbstractDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.interactors.ForteTypeNameCreator;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.GlobalConstantsEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.util.LibraryElementHashException;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.xml.sax.InputSource;

public class DeploymentExecutor
extends AbstractDeviceManagementInteractor {
    public static final String CREATE_RESOURCE_INSTANCE = "<Request ID=\"{0}\" Action=\"CREATE\"><FB Name=\"{1}\" Type=\"{2}\" /></Request>";
    public static final String CREATE_FB_INSTANCE = "<Request ID=\"{0}\" Action=\"CREATE\"><FB Name=\"{1}\" Type=\"{2}\" /></Request>";
    public static final String CREATE_CONNECTION = "<Request ID=\"{0}\" Action=\"CREATE\"><Connection Source=\"{1}\" Destination=\"{2}\" /></Request>";
    public static final String WRITE_PARAMETER = "<Request ID=\"{0}\" Action=\"WRITE\"><Connection Source=\"{1}\" Destination=\"{2}\" /></Request>";
    public static final String START = "<Request ID=\"{0}\" Action=\"START\"/>";
    public static final String STOP = "<Request ID=\"{0}\" Action=\"STOP\"/>";
    public static final String START_FB = "<Request ID=\"{0}\" Action=\"START\"><FB Name=\"{1}\" Type=\"{2}\"/></Request>";
    public static final String KILL_FB = "<Request ID=\"{0}\" Action=\"KILL\"><FB Name=\"{1}\" Type=\"\"/></Request>";
    public static final String KILL_DEVICE = "<Request ID=\"{0}\" Action=\"KILL\"></Request>";
    public static final String STOP_FB = "<Request ID=\"{0}\" Action=\"STOP\"><FB Name=\"{1}\" Type=\"\"/></Request>";
    public static final String DELETE_FB = "<Request ID=\"{0}\" Action=\"DELETE\"><FB Name=\"{1}\" Type=\"\"/></Request>";
    public static final String DELETE_CONNECTION = "<Request ID=\"{0}\" Action=\"DELETE\"><Connection Source=\"{1}\" Destination=\"{2}\"/></Request>";
    public static final String QUERY_FB_INSTANCES = "<Request ID=\"{0}\" Action=\"QUERY\"><FB Name=\"*\" Type=\"*\"/></Request>";
    public static final String QUERY_FB_TYPE = "<Request ID=\"{0}\" Action=\"QUERY\"><FBType Name=\"{1}\" /></Request>";
    public static final String QUERY_DATA_TYPE = "<Request ID=\"{0}\" Action=\"QUERY\"><DataType Name=\"{1}\" /></Request>";
    public static final String QUERY_GLOBAL_CONST_TYPE = "<Request ID=\"{0}\" Action=\"QUERY\"><GlobalConstType Name=\"{1}\" /></Request>";
    public static final String READ_WATCHES = "<Request ID=\"{0}\" Action=\"READ\"><Watches/></Request>";
    public static final String ADD_WATCH = "<Request ID=\"{0}\" Action=\"CREATE\"><Watch Source=\"{1}\" Destination=\"{2}\" /></Request>";
    public static final String DELETE_WATCH = "<Request ID=\"{0}\" Action=\"DELETE\"><Watch Source=\"{1}\" Destination=\"{2}\" /></Request>";
    public static final String FORCE_VALUE = "<Request ID=\"{0}\" Action=\"WRITE\"><Connection Source=\"{1}\" Destination=\"{2}\" force=\"{3}\" /></Request>";
    public static final String RESET_RESOURCE = "<Request ID=\"{0}\" Action=\"RESET\"><FB Name=\"{1}\" Type=\"\"/></Request>";
    public static final Response EMPTY_RESPONSE = DevResponseFactory.eINSTANCE.createResponse();
    private final Set<String> genFBs = new HashSet<String>();
    private int id = 0;
    private final ResponseMapping respMapping = new ResponseMapping();

    static {
        EMPTY_RESPONSE.setFblist(DevResponseFactory.eINSTANCE.createFBList());
        EMPTY_RESPONSE.setID("0");
        EMPTY_RESPONSE.setWatches(DevResponseFactory.eINSTANCE.createWatches());
    }

    String getNextId() {
        return Integer.toString(this.id++);
    }

    public DeploymentExecutor(Device dev) {
        this(dev, null);
    }

    public DeploymentExecutor(Device dev, IDeviceManagementCommunicationHandler overrideHandler) {
        super(dev, overrideHandler);
        this.genFBs.add("PUBLISH");
        this.genFBs.add("SUBSCRIBE");
        this.genFBs.add("PUBL");
        this.genFBs.add("SUBL");
        this.genFBs.add("SERVER");
        this.genFBs.add("CLIENT");
    }

    protected IDeviceManagementCommunicationHandler createCommunicationHandler(Device dev) {
        return new EthernetDeviceManagementCommunicationHandler();
    }

    public void createResource(Resource resource) throws DeploymentException {
        String request = MessageFormat.format("<Request ID=\"{0}\" Action=\"CREATE\"><FB Name=\"{1}\" Type=\"{2}\" /></Request>", this.getNextId(), resource.getName(), ForteTypeNameCreator.getForteTypeName((TypeEntry)resource.getTypeEntry()));
        try {
            this.sendREQ("", request);
        }
        catch (EOFException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_DeviceConnectionClosed, resource.getName()), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_CreateResourceFailed, resource.getName()), (Throwable)e);
        }
    }

    public void writeResourceParameter(Resource resource, String parameter, String value) throws DeploymentException {
        String encodedValue = DeploymentExecutor.encodeXMLChars(value);
        String request = this.generateWriteParamRequest(resource.getName(), parameter, encodedValue);
        try {
            this.sendREQ("", request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_WriteResourceParameterFailed, resource.getName(), parameter), (Throwable)e);
        }
    }

    protected String generateWriteParamRequest(String targetElementName, String parameter, String value) {
        return this.generateWriteParamRequest(targetElementName + "." + parameter, value);
    }

    protected String generateWriteParamRequest(String name, String value) {
        return MessageFormat.format(this.getWriteParameterMessage(), this.getNextId(), value, name);
    }

    protected String getWriteParameterMessage() {
        return WRITE_PARAMETER;
    }

    private static String encodeXMLChars(String value) {
        String retVal = value;
        retVal = retVal.replace("\"", "&quot;");
        retVal = retVal.replace("'", "&apos;");
        retVal = retVal.replace("<", "&lt;");
        retVal = retVal.replace(">", "&gt;");
        return retVal;
    }

    public void writeFBParameter(Resource resource, String name, String value) throws DeploymentException {
        String encodedValue = DeploymentExecutor.encodeXMLChars(value);
        String request = this.generateWriteParamRequest(name, encodedValue);
        try {
            this.sendREQ(resource.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_WriteFBParameterFailed, resource.getName(), name), (Throwable)e);
        }
    }

    public void writeFBParameter(Resource resource, String value, FBDeploymentData fbData, VarDeclaration varDecl) throws DeploymentException {
        String encodedValue = DeploymentExecutor.encodeXMLChars(value);
        String request = this.generateWriteParamRequest(fbData.getPrefix() + fbData.getFb().getName(), varDecl.getName(), encodedValue);
        try {
            this.sendREQ(resource.getName(), request);
        }
        catch (IOException e) {
            FordiacLogHelper.logWarning((String)("Could not send request.\nDestionation: " + resource.getName() + "\nRequest:\n" + request + "\nPin: " + varDecl.getQualifiedName()));
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_WriteFBParameterFailed, resource.getName(), varDecl.getName()), (Throwable)e);
        }
    }

    public void createConnection(Resource resource, ConnectionDeploymentData connData) throws DeploymentException {
        IInterfaceElement source = connData.source();
        IInterfaceElement destination = connData.destination();
        if (source == null || destination == null || source.getBlockFBNetworkElement() == null || destination.getBlockFBNetworkElement() == null) {
            throw new DeploymentException(Messages.DeploymentExecutor_CreateConnectionFailed);
        }
        BlockFBNetworkElement sourceFB = source.getBlockFBNetworkElement();
        BlockFBNetworkElement destFB = destination.getBlockFBNetworkElement();
        String request = MessageFormat.format(CREATE_CONNECTION, this.getNextId(), connData.sourcePrefix() + sourceFB.getName() + "." + source.getName() + connData.sourceSuffix(), connData.destinationPrefix() + destFB.getName() + "." + destination.getName());
        try {
            this.sendREQ(resource.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(Messages.DeploymentExecutor_CreateConnectionFailed, (Throwable)e);
        }
    }

    public void startResource(Resource res) throws DeploymentException {
        String request = MessageFormat.format(START, this.getNextId());
        try {
            this.sendREQ(res.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_StartingResourceFailed, res.getName()), (Throwable)e);
        }
    }

    public void stopResource(Resource res) throws DeploymentException {
        String request = MessageFormat.format(STOP, this.getNextId());
        try {
            this.sendREQ(res.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_StartingResourceFailed, res.getName()), (Throwable)e);
        }
    }

    public void startDevice(Device dev) throws DeploymentException {
        String request = MessageFormat.format(START, this.getNextId());
        try {
            this.sendREQ("", request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_StartingDeviceFailed, dev.getName()), (Throwable)e);
        }
    }

    public void writeDeviceParameter(Device device, String parameter, String value) throws DeploymentException {
        String encodedValue = DeploymentExecutor.encodeXMLChars(value);
        String request = MessageFormat.format(this.getWriteParameterMessage(), this.getNextId(), encodedValue, parameter);
        try {
            this.sendREQ("", request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_WriteDeviceParameterFailed, device.getName(), parameter), (Throwable)e);
        }
    }

    public void deleteResource(String resName) throws DeploymentException {
        String delete = MessageFormat.format(DELETE_FB, this.getNextId(), resName);
        try {
            this.killResource(resName);
            this.sendREQ("", delete);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_DeleteFBFailed, resName), (Throwable)e);
        }
    }

    public void resetResource(String resName) throws DeploymentException {
        String reset = MessageFormat.format(RESET_RESOURCE, this.getNextId(), resName);
        try {
            this.sendREQ("", reset);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_DeleteFBFailed, resName), (Throwable)e);
        }
    }

    public void killResource(String resName) throws DeploymentException {
        String kill = MessageFormat.format(KILL_FB, this.getNextId(), resName);
        try {
            this.sendREQ("", kill);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_KillFBFailed, resName), (Throwable)e);
        }
    }

    public void deleteConnection(Resource res, ConnectionDeploymentData conData) throws DeploymentException {
    }

    public void deleteFB(Resource res, FBDeploymentData fbData) throws DeploymentException {
    }

    public void startFB(Resource res, FBDeploymentData fbData) throws DeploymentException {
        String fullFbInstanceName = fbData.getPrefix() + fbData.getFb().getName();
        String request = MessageFormat.format(START_FB, this.getNextId(), fullFbInstanceName, fbData.getFb().getFullTypeName());
        try {
            this.sendREQ(res.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_StartingFBFailed, fullFbInstanceName), (Throwable)e);
        }
    }

    public void createFBInstance(FBDeploymentData fbData, Resource res) throws DeploymentException {
        String fbType = ForteTypeNameCreator.getForteTypeName((FBNetworkElement)fbData.getFb());
        String fullFbInstanceName = fbData.getPrefix() + fbData.getFb().getName();
        if (fbType.isEmpty()) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_CreateFBInstanceFailedNoTypeFound, fullFbInstanceName));
        }
        String request = MessageFormat.format("<Request ID=\"{0}\" Action=\"CREATE\"><FB Name=\"{1}\" Type=\"{2}\" /></Request>", this.getNextId(), fullFbInstanceName, fbType);
        try {
            this.sendREQ(res.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_CreateFBInstanceFailed, fullFbInstanceName), (Throwable)e);
        }
    }

    public void killDevice(Device dev) throws DeploymentException {
        String kill = MessageFormat.format(KILL_DEVICE, this.getNextId());
        try {
            try {
                this.sendREQ("", kill);
            }
            catch (EOFException eOFException) {
                this.resetTypes();
            }
            catch (IOException e) {
                throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_KillDeviceFailed, dev.getName()), (Throwable)e);
            }
        }
        finally {
            this.resetTypes();
        }
    }

    public List<org.eclipse.fordiac.ide.deployment.devResponse.Resource> queryResources() throws DeploymentException {
        try {
            String result = this.sendREQ("", MessageFormat.format(QUERY_FB_INSTANCES, this.getNextId()));
            Response resp = this.parseResponse(result);
            if (resp.getFblist() != null && resp.getFblist().getFbs() != null) {
                return resp.getFblist().getFbs().stream().map(fb -> {
                    org.eclipse.fordiac.ide.deployment.devResponse.Resource res = DevResponseFactory.eINSTANCE.createResource();
                    res.setName(fb.getName());
                    res.setType(fb.getType());
                    return res;
                }).toList();
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_QueryResourcesFailed, this.getDevice().getName()), (Throwable)e);
        }
    }

    public Response queryFBType(FBTypeEntry entry) throws DeploymentException {
        try {
            String request = MessageFormat.format(QUERY_FB_TYPE, this.getNextId(), DeploymentExecutor.getTypeNameWithHash((TypeEntry)entry));
            return this.parseResponse(this.sendREQ("", request));
        }
        catch (IOException | LibraryElementHashException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_QueryFBTypeFailed, entry.getFullTypeName()), e);
        }
    }

    public Response queryDataType(DataTypeEntry entry) throws DeploymentException {
        try {
            String request = MessageFormat.format(QUERY_DATA_TYPE, this.getNextId(), DeploymentExecutor.getTypeNameWithHash((TypeEntry)entry));
            return this.parseResponse(this.sendREQ("", request));
        }
        catch (IOException | LibraryElementHashException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_QueryDataTypeFailed, entry.getFullTypeName()), e);
        }
    }

    public Response queryGlobalConstType(GlobalConstantsEntry entry) throws DeploymentException {
        try {
            String request = MessageFormat.format(QUERY_GLOBAL_CONST_TYPE, this.getNextId(), DeploymentExecutor.getTypeNameWithHash((TypeEntry)entry));
            return this.parseResponse(this.sendREQ("", request));
        }
        catch (IOException | LibraryElementHashException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_QueryGlobalConstTypeFailed, entry.getFullTypeName()), e);
        }
    }

    private static String getTypeNameWithHash(TypeEntry entry) throws LibraryElementHashException {
        String hash = entry.getTypeHash();
        if (hash.isEmpty()) {
            return ForteTypeNameCreator.getForteTypeName((TypeEntry)entry);
        }
        return ForteTypeNameCreator.getForteTypeName((TypeEntry)entry) + "#" + hash;
    }

    protected Response parseResponse(String result) throws IOException {
        if (result != null) {
            InputSource source = new InputSource(new StringReader(result));
            XMLResourceImpl xmlResource = new XMLResourceImpl();
            xmlResource.load(source, this.respMapping.getLoadOptions());
            for (EObject object : xmlResource.getContents()) {
                if (!(object instanceof Response)) continue;
                Response response = (Response)object;
                return response;
            }
        }
        return EMPTY_RESPONSE;
    }

    public Response readWatches() throws DeploymentException {
        String request = MessageFormat.format(READ_WATCHES, this.getNextId());
        try {
            return this.parseResponse(this.sendREQ("", request));
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_ReadWatchesFailed, this.getDevice().getName()), (Throwable)e);
        }
    }

    public boolean addWatch(Resource resource, String name) throws DeploymentException {
        String request = MessageFormat.format(ADD_WATCH, this.getNextId(), name, "*");
        try {
            String response = this.sendREQ(resource.getName(), request);
            return !response.isBlank();
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_AddWatchesFailed, name), (Throwable)e);
        }
    }

    public boolean removeWatch(Resource resource, String name) throws DeploymentException {
        String request = MessageFormat.format(DELETE_WATCH, this.getNextId(), name, "*");
        try {
            String response = this.sendREQ(resource.getName(), request);
            return !response.isBlank();
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_DeleteWatchesFailed, name), (Throwable)e);
        }
    }

    public void triggerEvent(Resource resource, String name) throws DeploymentException {
        String request = MessageFormat.format(this.getWriteParameterMessage(), this.getNextId(), "$e", name);
        try {
            this.sendREQ(resource.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_TriggerEventFailed, name), (Throwable)e);
        }
    }

    public void forceValue(Resource resource, String name, String value) throws DeploymentException {
        String encodedValue = DeploymentExecutor.encodeXMLChars(value);
        String request = MessageFormat.format(FORCE_VALUE, this.getNextId(), encodedValue, name, "true");
        try {
            this.sendREQ(resource.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_ForceValueFailed, name, value), (Throwable)e);
        }
    }

    public void clearForce(Resource resource, String name) throws DeploymentException {
        String request = MessageFormat.format(FORCE_VALUE, this.getNextId(), "*", name, "false");
        try {
            this.sendREQ(resource.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_ClearForceFailed, name), (Throwable)e);
        }
    }

    public void readTraces(Device device, String path) throws DeploymentException {
        throw new UnsupportedOperationException(Messages.DeploymentExecutor_ReadTracesNotSupported);
    }

    public Optional<String> replayNextEvent(Resource resource) throws DeploymentException {
        throw new UnsupportedOperationException(Messages.DeploymentExecutor_ReplayNextEventNotSupported);
    }
}

