/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.fordiac.ide.debug.CommonEvaluatorDebugger;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugElement;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugTarget;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugThread;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;

public class EvaluatorDebugStackFrame
extends EvaluatorDebugElement
implements IStackFrame {
    private final Evaluator evaluator;
    private final EvaluatorDebugThread thread;
    private final AtomicReference<Object> currentContext = new AtomicReference();

    public EvaluatorDebugStackFrame(Evaluator evaluator, EvaluatorDebugThread thread) {
        super(thread.getDebugTarget());
        this.evaluator = evaluator;
        this.thread = thread;
    }

    public Object getCurrentContext() {
        return this.currentContext.get();
    }

    public void setCurrentContext(Object context) {
        this.currentContext.set(context);
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public EvaluatorDebugStackFrame getParent() {
        Evaluator parent = this.evaluator.getParent();
        if (parent != null) {
            CommonEvaluatorDebugger debugger = this.getDebugTarget().getDebugger();
            return debugger.getStackFrame(parent, this.thread);
        }
        return null;
    }

    public boolean isAncestorOf(EvaluatorDebugStackFrame frame) {
        if (frame == this) {
            return true;
        }
        if (frame == null) {
            return false;
        }
        return this.isAncestorOf(frame.getParent());
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() {
        this.thread.resume();
    }

    public void suspend() {
        this.thread.suspend();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() {
        this.thread.request((Object)this, 1, 1);
    }

    public void stepOver() {
        this.thread.request((Object)this, 1, 2);
    }

    public void stepReturn() {
        this.thread.request((Object)this, 1, 4);
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() {
        this.thread.terminate();
    }

    public EvaluatorDebugVariable getVariable(String name) {
        Variable variable = (Variable)this.evaluator.getVariables().get(name);
        if (variable != null) {
            CommonEvaluatorDebugger debugger = this.getDebugTarget().getDebugger();
            return debugger.getVariable(variable);
        }
        return null;
    }

    public IVariable[] getVariables() {
        CommonEvaluatorDebugger debugger = this.getDebugTarget().getDebugger();
        List<EvaluatorDebugVariable> debugVars = this.evaluator.getVariables().values().stream().map(debugger::getVariable).toList();
        Stream<EvaluatorDebugVariable> thisVars = debugVars.stream().filter(variable -> "THIS".equals(variable.getName()));
        Stream<EvaluatorDebugVariable> otherVars = debugVars.stream().filter(variable -> !"THIS".equals(variable.getName())).sorted();
        return (IVariable[])Stream.concat(thisVars, otherVars).toArray(IVariable[]::new);
    }

    public boolean hasVariables() {
        return !this.evaluator.getVariables().isEmpty();
    }

    public int getLineNumber() {
        CommonEvaluatorDebugger debugger = this.getDebugTarget().getDebugger();
        Object context = this.getCurrentContext();
        return debugger.getLineNumber(context);
    }

    public int getCharStart() {
        return -1;
    }

    public int getCharEnd() {
        return -1;
    }

    public String getName() {
        return this.evaluator.getName();
    }

    public boolean hasRegisterGroups() {
        return false;
    }

    public IRegisterGroup[] getRegisterGroups() {
        return new IRegisterGroup[0];
    }

    public EvaluatorDebugThread getThread() {
        return this.thread;
    }

    public EvaluatorDebugTarget getDebugTarget() {
        return (EvaluatorDebugTarget)super.getDebugTarget();
    }
}

