/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.utils;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.fordiac.ide.contractSpec.ContractSpecFactory;
import org.eclipse.fordiac.ide.contractSpec.Port;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.scoping.ContractSpecScopeProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class ContractspecResourceProvider
implements IEditedResourceProvider {
    private static final URI SYNTHETIC_URI = URI.createURI((String)"__synthetic.contract");
    private static final URI SYNTHETIC_URI_INTERFACE = URI.createURI((String)"__synthetic_interface.contract");
    private static final IResourceServiceProvider SERVICE_PROVIDER = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(SYNTHETIC_URI);
    private final BlockFBNetworkElement fbElem;
    private final List<String> inPorts;
    private final List<String> outPorts;

    public ContractspecResourceProvider(BlockFBNetworkElement fbElem) {
        this.fbElem = fbElem;
        this.inPorts = null;
        this.outPorts = null;
    }

    public ContractspecResourceProvider(List<String> inPorts, List<String> outPorts) {
        this.fbElem = null;
        this.inPorts = inPorts;
        this.outPorts = outPorts;
    }

    public XtextResource createResource() {
        XtextResourceSet resourceSet = (XtextResourceSet)SERVICE_PROVIDER.get(ResourceSet.class);
        XtextResource resource = (XtextResource)SERVICE_PROVIDER.get(XtextResource.class);
        resource.setURI(SYNTHETIC_URI);
        resourceSet.getResources().add((Object)resource);
        Resource resInter = resourceSet.createResource(SYNTHETIC_URI_INTERFACE);
        ContractSpecScopeProvider.setInterfaceURI((URI)SYNTHETIC_URI_INTERFACE);
        if (this.fbElem != null) {
            ContractspecResourceProvider.addFBInterface(resInter, this.fbElem);
        } else {
            ContractspecResourceProvider.addFBInterface(resInter, this.inPorts, this.outPorts);
        }
        return resource;
    }

    public static EmbeddedEditorFactory.Builder getEmbeddedEditorBuilder(BlockFBNetworkElement fbElem) {
        ContractspecResourceProvider resourceProvider = new ContractspecResourceProvider(fbElem);
        return ((EmbeddedEditorFactory)SERVICE_PROVIDER.get(EmbeddedEditorFactory.class)).newEditor((IEditedResourceProvider)resourceProvider);
    }

    private static void addFBInterface(Resource res, BlockFBNetworkElement fbElem) {
        fbElem.getInterface().getAllInputs().forEach(ie -> ContractspecResourceProvider.createPort(res, ie.getName(), true));
        fbElem.getInterface().getAllOutputs().forEach(oe -> ContractspecResourceProvider.createPort(res, oe.getName(), false));
    }

    private static void addFBInterface(Resource res, List<String> inputs, List<String> outputs) {
        if (inputs != null) {
            for (String ie : inputs) {
                ContractspecResourceProvider.createPort(res, ie, true);
            }
        }
        if (outputs != null) {
            for (String oe : outputs) {
                ContractspecResourceProvider.createPort(res, oe, false);
            }
        }
    }

    private static void createPort(Resource res, String name, boolean isInput) {
        Port p = ContractSpecFactory.eINSTANCE.createPort();
        p.setName(name);
        p.setIsInput(isInput ? 1 : 0);
        res.getContents().add((Object)p);
    }
}

