/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.contracts.Messages;
import org.eclipse.fordiac.ide.contracts.exceptions.ContractExeption;
import org.eclipse.fordiac.ide.contracts.model.Assumption;
import org.eclipse.fordiac.ide.contracts.model.ContractConstants;
import org.eclipse.fordiac.ide.contracts.model.ContractElement;
import org.eclipse.fordiac.ide.contracts.model.Guarantee;
import org.eclipse.fordiac.ide.contracts.model.Interval;
import org.eclipse.fordiac.ide.contracts.model.helpers.ContractUtils;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public class Contract {
    private final EList<Assumption> assumptions = new BasicEList();
    private final EList<Guarantee> guarantees = new BasicEList();
    private FBNetworkElement owner;
    private Optional<String> error;
    private ContractConstants.ContractState state = ContractConstants.ContractState.UNKNOWN;

    Contract() {
    }

    public static Contract getContractFromComment(String comment) {
        Contract contract = new Contract();
        String[] lines = comment.split(System.lineSeparator());
        try {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith("ASSUMPTION")) {
                    toAdd = Assumption.createAssumption(line);
                    contract.add((Assumption)toAdd, contract);
                } else if (line.startsWith("GUARANTEE")) {
                    toAdd = Guarantee.createGuarantee(line);
                    contract.add((Guarantee)toAdd, contract);
                }
                ++n2;
            }
        }
        catch (ContractExeption e) {
            contract.state = ContractConstants.ContractState.INVALID;
            contract.addError(e.getMessage());
        }
        return contract;
    }

    public String getError() {
        return this.error.orElse("");
    }

    void addError(String error) {
        this.error = Optional.ofNullable(error);
    }

    public void setOwner(FBNetworkElement owner) {
        this.state = ContractConstants.ContractState.UNKNOWN;
        this.owner = owner;
    }

    public FBNetworkElement getOwner() {
        return this.owner;
    }

    public EList<Assumption> getAssumptions() {
        return this.assumptions;
    }

    public EList<Guarantee> getGuarantees() {
        return this.guarantees;
    }

    void add(Assumption assumption, Contract owner) {
        assumption.setContract(owner);
        this.state = ContractConstants.ContractState.UNKNOWN;
        this.assumptions.add((Object)assumption);
    }

    void add(Guarantee guarantee, Contract owner) {
        guarantee.setContract(owner);
        this.state = ContractConstants.ContractState.UNKNOWN;
        this.guarantees.add((Object)guarantee);
    }

    void removeAssumption(int index) {
        this.state = ContractConstants.ContractState.UNKNOWN;
        Assumption removedAssumption = (Assumption)this.assumptions.remove(index);
        removedAssumption.setContract(null);
    }

    void removeGuarantee(int index) {
        this.state = ContractConstants.ContractState.UNKNOWN;
        Guarantee removedGuarantee = (Guarantee)this.guarantees.remove(index);
        removedGuarantee.setContract(null);
    }

    public boolean isValid() {
        if (this.state == ContractConstants.ContractState.UNKNOWN) {
            this.checkValidity();
        }
        return this.state == ContractConstants.ContractState.VALID;
    }

    public Guarantee getGuaranteeWith(String inputEvent) {
        return this.guarantees.stream().filter(g -> g.getInputEvent().equals(inputEvent)).findAny().orElse(null);
    }

    public Assumption getAssumptionWith(String InputEvent) {
        return this.assumptions.stream().filter(a -> a.getInputEvent().equals(InputEvent)).findAny().orElse(null);
    }

    public void writeToOwner() {
        FBNetworkElement fBNetworkElement = this.owner;
        if (fBNetworkElement instanceof SubApp) {
            SubApp subapp = (SubApp)fBNetworkElement;
            if (!subapp.getName().startsWith("_CONTRACT")) {
                subapp.setName(NameRepository.createUniqueName((INamedElement)subapp, (String)("_CONTRACT_" + subapp.getName())));
            }
            subapp.setComment(this.getAsString());
        }
    }

    public String getAsString() {
        StringBuilder comment = new StringBuilder();
        for (Assumption assumption : this.assumptions) {
            comment.append(assumption.asString());
        }
        for (Guarantee guarantee : this.guarantees) {
            comment.append(guarantee.asString());
        }
        return comment.toString();
    }

    private void checkValidity() {
        if (!ContractUtils.isContractSubapp(this.owner)) {
            this.addError(Messages.Contract_ErrorName);
            this.state = ContractConstants.ContractState.INVALID;
            return;
        }
        if (this.assumptions.isEmpty() && this.guarantees.isEmpty()) {
            this.addError(Messages.Contract_ErrorElements);
            this.state = ContractConstants.ContractState.INVALID;
            return;
        }
        for (Assumption assumption : this.assumptions) {
            if (assumption.isValid()) continue;
            this.addError(Messages.Contract_ErrorAssumption + assumption.asString());
            this.state = ContractConstants.ContractState.INVALID;
            return;
        }
        for (Guarantee guarantee : this.guarantees) {
            if (guarantee.isValid()) continue;
            this.addError(Messages.Contract_ErrorGuarantee + guarantee.asString());
            this.state = ContractConstants.ContractState.INVALID;
            return;
        }
        if (!this.hasConsistentAssumptions()) {
            this.addError(Messages.Contract_ErrorIncosistentAssumptions);
            this.state = ContractConstants.ContractState.INVALID;
            return;
        }
        if (!this.hasConsistentGuarantees()) {
            this.addError(Messages.Contract_ErrorIncosistentGuarantees);
            this.state = ContractConstants.ContractState.INVALID;
            return;
        }
        if (!this.hasConsistentContract()) {
            this.addError(Messages.Contract_ErrorAssumptionsGuarantees);
            this.state = ContractConstants.ContractState.INVALID;
            return;
        }
        this.state = ContractConstants.ContractState.VALID;
    }

    private boolean hasConsistentContract() {
        HashMap<String, EList<ContractElement>> mapContractElements = new HashMap<String, EList<ContractElement>>();
        this.fillContractElementMap(mapContractElements);
        for (Map.Entry<String, EList<ContractElement>> entry : mapContractElements.entrySet()) {
            int guaranteeMax;
            if (!Contract.isAssumptionGuaranteePair(entry)) {
                return false;
            }
            int assumptionMin = ((ContractElement)entry.getValue().get(0)).getMin();
            if (assumptionMin >= (guaranteeMax = ((ContractElement)entry.getValue().get(1)).getMax())) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssumptionGuaranteePair(Map.Entry<String, EList<ContractElement>> entry) {
        return entry.getValue().size() == 2;
    }

    private void fillContractElementMap(Map<String, EList<ContractElement>> mapContractElements) {
        BasicEList toAdd;
        for (Assumption assumption : this.assumptions) {
            if (mapContractElements.containsKey(assumption.getInputEvent())) {
                mapContractElements.get(assumption.getInputEvent()).add((Object)assumption);
                continue;
            }
            toAdd = new BasicEList();
            toAdd.add((Object)assumption);
            mapContractElements.put(assumption.getInputEvent(), (EList<ContractElement>)toAdd);
        }
        for (Guarantee guarantee : this.guarantees) {
            if (mapContractElements.containsKey(guarantee.getInputEvent())) {
                mapContractElements.get(guarantee.getInputEvent()).add((Object)guarantee);
                continue;
            }
            toAdd = new BasicEList();
            toAdd.add((Object)guarantee);
            mapContractElements.put(guarantee.getInputEvent(), (EList<ContractElement>)toAdd);
        }
    }

    private boolean hasConsistentGuarantees() {
        HashMap<String, BasicEList> mapGuarantees = new HashMap<String, BasicEList>();
        for (Guarantee guarantee : this.guarantees) {
            if (mapGuarantees.containsKey(guarantee.getInputEvent())) {
                ((EList)mapGuarantees.get(guarantee.getInputEvent())).add((Object)guarantee);
                continue;
            }
            BasicEList toAdd = new BasicEList();
            toAdd.add((Object)guarantee);
            mapGuarantees.put(guarantee.getInputEvent(), toAdd);
        }
        for (Map.Entry entry : mapGuarantees.entrySet()) {
            if (((EList)entry.getValue()).size() == 1 || Guarantee.isCompatibleWith((Iterable)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean hasConsistentAssumptions() {
        HashMap<String, BasicEList> mapAssumptions = new HashMap<String, BasicEList>();
        for (Assumption assumption : this.assumptions) {
            if (mapAssumptions.containsKey(assumption.getInputEvent())) {
                ((EList)mapAssumptions.get(assumption.getInputEvent())).add((Object)assumption);
                continue;
            }
            BasicEList toAdd = new BasicEList();
            toAdd.add((Object)assumption);
            mapAssumptions.put(assumption.getInputEvent(), toAdd);
        }
        for (Map.Entry entry : mapAssumptions.entrySet()) {
            if (((EList)entry.getValue()).size() == 1 || Assumption.isCompatibleWith((EList<Assumption>)((EList)entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    static boolean isTimeConsistent(EList<? extends ContractElement> contractElements) {
        if (((ContractElement)contractElements.get(0)).getMax() == -1) {
            return Contract.isSingleAssumption(contractElements, 0);
        }
        int maximum = ((ContractElement)contractElements.get(0)).getMax();
        int minimum = ((ContractElement)contractElements.get(0)).getMin();
        int i = 1;
        while (i < contractElements.size()) {
            if (((ContractElement)contractElements.get(i)).getMax() == -1) {
                return Contract.isSingleAssumption(contractElements, i);
            }
            minimum = Math.max(minimum, ((ContractElement)contractElements.get(i)).getMin());
            if ((maximum = Math.min(maximum, ((ContractElement)contractElements.get(i)).getMax())) < minimum) {
                return false;
            }
            ++i;
        }
        Contract.simplifyContract(contractElements, minimum, maximum);
        return true;
    }

    private static boolean isSingleAssumption(EList<? extends ContractElement> contractElements, int pos) {
        for (ContractElement contractEl : contractElements.subList(pos + 1, contractElements.size())) {
            if (contractEl.getMax() != -1) continue;
            return false;
        }
        Contract.simplifyAssumption(((ContractElement)contractElements.get(pos)).getMin(), -1, ((ContractElement)contractElements.get(pos)).getContract(), (Assumption)contractElements.get(pos));
        return true;
    }

    private static void simplifyContract(EList<? extends ContractElement> contractElements, int minimum, int maximum) {
        Contract contract = ((ContractElement)contractElements.get(0)).getContract();
        ContractElement contractElement = (ContractElement)contractElements.get(0);
        if (contractElement instanceof Assumption) {
            Assumption toRemove = (Assumption)contractElement;
            Contract.simplifyAssumption(minimum, maximum, contract, toRemove);
        } else {
            ContractElement contractElement2 = (ContractElement)contractElements.get(0);
            if (contractElement2 instanceof Guarantee) {
                Guarantee toRemove = (Guarantee)contractElement2;
                Contract.simplifyGuarantee(minimum, maximum, contract, toRemove);
            }
        }
    }

    private static void simplifyGuarantee(int minimum, int maximum, Contract contract, Guarantee toRemove) {
        contract.getGuarantees().removeIf(g -> g.getInputEvent().equals(toRemove.getInputEvent()));
        Guarantee toAdd = new Guarantee(toRemove.getInputEvent(), toRemove.getOutputEvent(), new Interval(minimum, maximum));
        contract.add(toAdd, contract);
    }

    private static void simplifyAssumption(int minimum, int maximum, Contract contract, Assumption toRemove) {
        contract.getAssumptions().removeIf(a -> a.getInputEvent().equals(toRemove.getInputEvent()));
        Assumption toAdd = new Assumption(toRemove.getInputEvent(), new Interval(minimum, maximum));
        toAdd.setInputEvent(toRemove.getInputEvent());
        toAdd.setTime(new Interval(minimum, maximum));
        contract.add(toAdd, contract);
    }
}

