/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.properties.TypedInterfacePinFilter;
import org.eclipse.fordiac.ide.gef.editors.InitialValueEditor;
import org.eclipse.fordiac.ide.gef.properties.AbstractDoubleColumnSection;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.gef.widgets.ConnectionDisplayWidget;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeVarConfigurationCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueRefreshJob;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceStoreProvider;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class InterfaceElementSection
extends AbstractDoubleColumnSection {
    private TableViewer connectionsViewer;
    private Text typeText;
    private Text typeCommentText;
    private Text instanceCommentText;
    private Text parameterText;
    private InitialValueEditor currentParameterEditor;
    private CLabel parameterTextCLabel;
    private CLabel currentParameterTextCLabel;
    private CLabel currentVarConfigTextCLabel;
    private Button currentVarConfigCheckBox;
    private Button openEditorButton;
    private Section infoSection;
    private ConnectionDisplayWidget connectionDisplayWidget;
    private InitialValueRefreshJob refreshJob;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createInstanceInfoSection(this.getLeftComposite());
        this.createTypeInfoSection(this.getLeftComposite());
        this.createConnectionDisplaySection(this.getRightComposite());
    }

    private void createConnectionDisplaySection(Composite parent) {
        this.connectionDisplayWidget = new ConnectionDisplayWidget(this.getWidgetFactory(), parent, (AbstractSection)this);
    }

    private void createTypeInfoSection(Composite parent) {
        Section typeInfoSection = this.getWidgetFactory().createSection(parent, 322);
        typeInfoSection.setText(FordiacMessages.TypeInfo + ":");
        typeInfoSection.setLayout((Layout)new GridLayout(1, false));
        typeInfoSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = this.getWidgetFactory().createComposite((Composite)typeInfoSection);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, FordiacMessages.Comment + ":");
        this.typeCommentText = this.createGroupText(composite, false);
        this.typeCommentText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.getWidgetFactory().createCLabel(composite, FordiacMessages.Type + ":");
        this.typeText = this.createGroupText(composite, false);
        this.openEditorButton = new Button(this.typeText.getParent(), 8);
        this.openEditorButton.setText(FordiacMessages.OPEN_TYPE_EDITOR_MESSAGE);
        this.parameterTextCLabel = this.getWidgetFactory().createCLabel(composite, FordiacMessages.DefaultValue + ":");
        this.parameterText = this.createGroupText(composite, false);
        this.parameterText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.refreshJob = new InitialValueRefreshJob(null, this::updateTypeInitialValue, false);
        typeInfoSection.setClient((Control)composite);
    }

    private void createInstanceInfoSection(Composite parent) {
        this.infoSection = this.getWidgetFactory().createSection(parent, 322);
        this.infoSection.setLayout((Layout)new GridLayout(1, false));
        this.infoSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = this.getWidgetFactory().createComposite((Composite)this.infoSection);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, FordiacMessages.Comment + ":");
        this.instanceCommentText = this.createGroupText(composite, false);
        this.instanceCommentText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.instanceCommentText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getType(), this.instanceCommentText.getText()));
            this.instanceCommentText.setForeground(this.getForegroundColor());
            this.addContentAdapter();
        });
        this.currentParameterTextCLabel = this.getWidgetFactory().createCLabel(composite, FordiacMessages.InitialValue + ":");
        this.currentParameterEditor = new InitialValueEditor(composite, 2052);
        this.currentParameterEditor.setCommandExecutor(arg_0 -> ((InterfaceElementSection)this).executeCommand(arg_0));
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.currentParameterEditor.getControl());
        this.currentVarConfigTextCLabel = this.getWidgetFactory().createCLabel(composite, FordiacMessages.VarConfig + ":");
        this.currentVarConfigCheckBox = this.getWidgetFactory().createButton(composite, null, 32);
        this.currentVarConfigCheckBox.addListener(13, event -> this.executeCommand((Command)new ChangeVarConfigurationCommand((VarDeclaration)this.getType(), this.currentVarConfigCheckBox.getSelection())));
        this.infoSection.setClient((Control)composite);
    }

    protected void performRefresh() {
        this.refreshParameterVisibility();
        FBNetworkElement fb = this.getType().getFBNetworkElement();
        if (fb != null) {
            this.infoSection.setText(MessageFormat.format(Messages.InterfaceElementSection_Instance, fb.getName(), this.getPinName()));
        } else {
            this.infoSection.setText(Messages.InterfaceElementSection_InterfaceElement);
        }
        this.typeCommentText.setText(CommentHelper.getTypeComment((IInterfaceElement)this.getType()));
        this.configureOpenEditorButton();
        this.instanceCommentText.setText(CommentHelper.getInstanceComment((INamedElement)this.getType()));
        this.instanceCommentText.setForeground(this.getForegroundColor());
        this.refreshTypeInitialValue();
        this.currentParameterEditor.setInterfaceElement(this.getType());
        this.currentParameterEditor.refresh();
        this.typeText.setText(this.getPinTypeName());
        this.connectionDisplayWidget.refreshConnectionsViewer(this.getType());
        IInterfaceElement iInterfaceElement = this.getType();
        if (iInterfaceElement instanceof VarDeclaration) {
            VarDeclaration verDeclaration = (VarDeclaration)iInterfaceElement;
            this.currentVarConfigCheckBox.setSelection(verDeclaration.isVarConfig());
        }
        if (fb != null) {
            this.setEditable(!fb.isContainedInTypedInstance() && !InterfaceElementSection.containsCFB(this.getType().eContainer()));
        }
    }

    /*
     * Unable to fully structure code
     */
    static boolean containsCFB(EObject container) {
        if (container == null) {
            return false;
        }
        if (!(container instanceof CFBInstance)) ** GOTO lbl8
        return true;
lbl-1000:
        // 1 sources

        {
            if (container instanceof CFBInstance || container instanceof CompositeFBType) {
                return true;
            }
            container = container.eContainer();
lbl8:
            // 2 sources

            ** while (container != null)
        }
lbl9:
        // 1 sources

        return false;
    }

    private void configureOpenEditorButton() {
        DataType dtp = this.getDataType();
        if (dtp != null) {
            this.openEditorButton.addListener(13, ev -> OpenStructMenu.openStructEditor((IFile)dtp.getTypeEntry().getFile()));
            this.openEditorButton.setEnabled((dtp instanceof StructuredType || dtp instanceof AdapterType) && !IecTypes.GenericTypes.isAnyType((DataType)dtp));
        }
    }

    private DataType getDataType() {
        return this.getType().getType();
    }

    private String getPinTypeName() {
        DataType dataType;
        StringBuilder sb = new StringBuilder();
        String typeName = this.getType().getFullTypeName();
        if (typeName != null) {
            sb.append(typeName);
        }
        if ((dataType = this.getType().getType()) instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)dataType;
            InterfaceElementSection.appendStructTypes(sb, structuredType);
        }
        return sb.toString();
    }

    protected void refreshTypeInitialValue() {
        VarDeclaration varDeclaration;
        IInterfaceElement iInterfaceElement = this.getType();
        if (iInterfaceElement instanceof VarDeclaration && (varDeclaration = (VarDeclaration)iInterfaceElement).isIsInput() && varDeclaration.getFBNetworkElement() != null && varDeclaration.getFBNetworkElement().getType() != null) {
            this.parameterText.setText(FordiacMessages.ComputingPlaceholderValue);
            this.refreshJob.setInterfaceElement(varDeclaration.getFBNetworkElement().getType().getInterfaceList().getInterfaceElement(varDeclaration.getName()));
            this.refreshJob.refresh();
        } else {
            this.parameterText.setText("");
        }
    }

    private void updateTypeInitialValue(String value) {
        if (!this.parameterText.isDisposed() && FordiacMessages.ComputingPlaceholderValue.equals(this.parameterText.getText())) {
            if (value.length() <= PreferenceStoreProvider.getStore((String)"org.eclipse.fordiac.ide.gef", (IProject)this.getTypeLibrary().getProject()).getInt("MaxDefaultValueLength")) {
                this.parameterText.setText(value);
            } else {
                this.parameterText.setText(FordiacMessages.ValueTooLarge);
            }
        }
    }

    private Color getForegroundColor() {
        if (!CommentHelper.hasComment((INamedElement)this.getType())) {
            return Display.getCurrent().getSystemColor(16);
        }
        return null;
    }

    private String getPinName() {
        String string;
        IInterfaceElement iInterfaceElement = this.getType();
        if (iInterfaceElement instanceof MemberVarDeclaration) {
            MemberVarDeclaration memVar = (MemberVarDeclaration)iInterfaceElement;
            string = memVar.getDisplayName();
        } else {
            string = this.getType().getName();
        }
        String pinName = string;
        return pinName != null ? pinName : "";
    }

    private void refreshParameterVisibility() {
        boolean isDataIO = this.isDataIO();
        this.parameterTextCLabel.setVisible(isDataIO);
        this.parameterText.setVisible(isDataIO);
        this.currentParameterTextCLabel.setVisible(isDataIO && this.getType().isIsInput());
        this.currentParameterEditor.getControl().setVisible(isDataIO && this.getType().isIsInput());
        this.currentVarConfigTextCLabel.setVisible(isDataIO && this.getType().isIsInput() && this.getType() instanceof VarDeclaration);
        this.currentVarConfigCheckBox.setVisible(isDataIO && this.getType().isIsInput() && this.getType() instanceof VarDeclaration);
    }

    private boolean isDataIO() {
        if (this.getType() instanceof ErrorMarkerInterface) {
            return !(this.getType().getType() instanceof EventType) && !(this.getType().getType() instanceof AdapterType);
        }
        return this.getType() instanceof VarDeclaration;
    }

    private void setEditable(boolean editable) {
        this.currentParameterEditor.setEditable(editable);
        this.instanceCommentText.setEditable(editable);
        this.instanceCommentText.setEnabled(editable);
        this.connectionDisplayWidget.setEditable(editable);
        this.currentVarConfigCheckBox.setEnabled(editable);
    }

    private static String appendStructTypes(StringBuilder sb, StructuredType st) {
        EList list = st.getMemberVariables();
        sb.append(": (");
        boolean printString = false;
        for (VarDeclaration v : list) {
            if (v.getType() != null) {
                sb.append(v.getType().getName());
                printString = true;
            } else {
                sb.append("not set");
            }
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(')');
        return printString ? sb.toString() : "";
    }

    protected void setInputCode() {
        this.connectionsViewer.setInput(null);
    }

    protected IInterfaceElement getType() {
        return (IInterfaceElement)this.type;
    }

    protected Object getInputType(Object input) {
        return TypedInterfacePinFilter.getInterfaceElementFromSelectedElement(input);
    }

    protected void setInputInit() {
    }

    public void dispose() {
        super.dispose();
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
        }
    }
}

