/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.variables.ServerDiagnosticsSummaryType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class ServerDiagnosticsSummaryTypeNode
extends BaseDataVariableTypeNode
implements ServerDiagnosticsSummaryType {
    public ServerDiagnosticsSummaryTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public UInteger getServerViewCount() throws UaException {
        BaseDataVariableTypeNode node = this.getServerViewCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setServerViewCount(UInteger serverViewCount) throws UaException {
        BaseDataVariableTypeNode node = this.getServerViewCountNode();
        node.setValue(new Variant((Object)serverViewCount));
    }

    @Override
    public UInteger readServerViewCount() throws UaException {
        try {
            return this.readServerViewCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerViewCount(UInteger serverViewCount) throws UaException {
        try {
            this.writeServerViewCountAsync(serverViewCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readServerViewCountAsync() {
        return ((CompletableFuture)this.getServerViewCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerViewCountAsync(UInteger serverViewCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverViewCount));
        return this.getServerViewCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getServerViewCountNode() throws UaException {
        try {
            return this.getServerViewCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getServerViewCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerViewCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getCurrentSessionCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentSessionCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentSessionCount(UInteger currentSessionCount) throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentSessionCountNode();
        node.setValue(new Variant((Object)currentSessionCount));
    }

    @Override
    public UInteger readCurrentSessionCount() throws UaException {
        try {
            return this.readCurrentSessionCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentSessionCount(UInteger currentSessionCount) throws UaException {
        try {
            this.writeCurrentSessionCountAsync(currentSessionCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readCurrentSessionCountAsync() {
        return ((CompletableFuture)this.getCurrentSessionCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentSessionCountAsync(UInteger currentSessionCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentSessionCount));
        return this.getCurrentSessionCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCurrentSessionCountNode() throws UaException {
        try {
            return this.getCurrentSessionCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCurrentSessionCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentSessionCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getCumulatedSessionCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCumulatedSessionCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setCumulatedSessionCount(UInteger cumulatedSessionCount) throws UaException {
        BaseDataVariableTypeNode node = this.getCumulatedSessionCountNode();
        node.setValue(new Variant((Object)cumulatedSessionCount));
    }

    @Override
    public UInteger readCumulatedSessionCount() throws UaException {
        try {
            return this.readCumulatedSessionCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCumulatedSessionCount(UInteger cumulatedSessionCount) throws UaException {
        try {
            this.writeCumulatedSessionCountAsync(cumulatedSessionCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readCumulatedSessionCountAsync() {
        return ((CompletableFuture)this.getCumulatedSessionCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCumulatedSessionCountAsync(UInteger cumulatedSessionCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)cumulatedSessionCount));
        return this.getCumulatedSessionCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCumulatedSessionCountNode() throws UaException {
        try {
            return this.getCumulatedSessionCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCumulatedSessionCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CumulatedSessionCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getSecurityRejectedSessionCount() throws UaException {
        BaseDataVariableTypeNode node = this.getSecurityRejectedSessionCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecurityRejectedSessionCount(UInteger securityRejectedSessionCount) throws UaException {
        BaseDataVariableTypeNode node = this.getSecurityRejectedSessionCountNode();
        node.setValue(new Variant((Object)securityRejectedSessionCount));
    }

    @Override
    public UInteger readSecurityRejectedSessionCount() throws UaException {
        try {
            return this.readSecurityRejectedSessionCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecurityRejectedSessionCount(UInteger securityRejectedSessionCount) throws UaException {
        try {
            this.writeSecurityRejectedSessionCountAsync(securityRejectedSessionCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readSecurityRejectedSessionCountAsync() {
        return ((CompletableFuture)this.getSecurityRejectedSessionCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityRejectedSessionCountAsync(UInteger securityRejectedSessionCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityRejectedSessionCount));
        return this.getSecurityRejectedSessionCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSecurityRejectedSessionCountNode() throws UaException {
        try {
            return this.getSecurityRejectedSessionCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSecurityRejectedSessionCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityRejectedSessionCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getRejectedSessionCount() throws UaException {
        BaseDataVariableTypeNode node = this.getRejectedSessionCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setRejectedSessionCount(UInteger rejectedSessionCount) throws UaException {
        BaseDataVariableTypeNode node = this.getRejectedSessionCountNode();
        node.setValue(new Variant((Object)rejectedSessionCount));
    }

    @Override
    public UInteger readRejectedSessionCount() throws UaException {
        try {
            return this.readRejectedSessionCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRejectedSessionCount(UInteger rejectedSessionCount) throws UaException {
        try {
            this.writeRejectedSessionCountAsync(rejectedSessionCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readRejectedSessionCountAsync() {
        return ((CompletableFuture)this.getRejectedSessionCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRejectedSessionCountAsync(UInteger rejectedSessionCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)rejectedSessionCount));
        return this.getRejectedSessionCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRejectedSessionCountNode() throws UaException {
        try {
            return this.getRejectedSessionCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRejectedSessionCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RejectedSessionCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getSessionTimeoutCount() throws UaException {
        BaseDataVariableTypeNode node = this.getSessionTimeoutCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setSessionTimeoutCount(UInteger sessionTimeoutCount) throws UaException {
        BaseDataVariableTypeNode node = this.getSessionTimeoutCountNode();
        node.setValue(new Variant((Object)sessionTimeoutCount));
    }

    @Override
    public UInteger readSessionTimeoutCount() throws UaException {
        try {
            return this.readSessionTimeoutCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSessionTimeoutCount(UInteger sessionTimeoutCount) throws UaException {
        try {
            this.writeSessionTimeoutCountAsync(sessionTimeoutCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readSessionTimeoutCountAsync() {
        return ((CompletableFuture)this.getSessionTimeoutCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSessionTimeoutCountAsync(UInteger sessionTimeoutCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sessionTimeoutCount));
        return this.getSessionTimeoutCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSessionTimeoutCountNode() throws UaException {
        try {
            return this.getSessionTimeoutCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSessionTimeoutCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SessionTimeoutCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getSessionAbortCount() throws UaException {
        BaseDataVariableTypeNode node = this.getSessionAbortCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setSessionAbortCount(UInteger sessionAbortCount) throws UaException {
        BaseDataVariableTypeNode node = this.getSessionAbortCountNode();
        node.setValue(new Variant((Object)sessionAbortCount));
    }

    @Override
    public UInteger readSessionAbortCount() throws UaException {
        try {
            return this.readSessionAbortCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSessionAbortCount(UInteger sessionAbortCount) throws UaException {
        try {
            this.writeSessionAbortCountAsync(sessionAbortCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readSessionAbortCountAsync() {
        return ((CompletableFuture)this.getSessionAbortCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSessionAbortCountAsync(UInteger sessionAbortCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sessionAbortCount));
        return this.getSessionAbortCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSessionAbortCountNode() throws UaException {
        try {
            return this.getSessionAbortCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSessionAbortCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SessionAbortCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getPublishingIntervalCount() throws UaException {
        BaseDataVariableTypeNode node = this.getPublishingIntervalCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setPublishingIntervalCount(UInteger publishingIntervalCount) throws UaException {
        BaseDataVariableTypeNode node = this.getPublishingIntervalCountNode();
        node.setValue(new Variant((Object)publishingIntervalCount));
    }

    @Override
    public UInteger readPublishingIntervalCount() throws UaException {
        try {
            return this.readPublishingIntervalCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePublishingIntervalCount(UInteger publishingIntervalCount) throws UaException {
        try {
            this.writePublishingIntervalCountAsync(publishingIntervalCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readPublishingIntervalCountAsync() {
        return ((CompletableFuture)this.getPublishingIntervalCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePublishingIntervalCountAsync(UInteger publishingIntervalCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)publishingIntervalCount));
        return this.getPublishingIntervalCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPublishingIntervalCountNode() throws UaException {
        try {
            return this.getPublishingIntervalCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPublishingIntervalCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublishingIntervalCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getCurrentSubscriptionCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentSubscriptionCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentSubscriptionCount(UInteger currentSubscriptionCount) throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentSubscriptionCountNode();
        node.setValue(new Variant((Object)currentSubscriptionCount));
    }

    @Override
    public UInteger readCurrentSubscriptionCount() throws UaException {
        try {
            return this.readCurrentSubscriptionCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentSubscriptionCount(UInteger currentSubscriptionCount) throws UaException {
        try {
            this.writeCurrentSubscriptionCountAsync(currentSubscriptionCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readCurrentSubscriptionCountAsync() {
        return ((CompletableFuture)this.getCurrentSubscriptionCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentSubscriptionCountAsync(UInteger currentSubscriptionCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentSubscriptionCount));
        return this.getCurrentSubscriptionCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCurrentSubscriptionCountNode() throws UaException {
        try {
            return this.getCurrentSubscriptionCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCurrentSubscriptionCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentSubscriptionCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getCumulatedSubscriptionCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCumulatedSubscriptionCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setCumulatedSubscriptionCount(UInteger cumulatedSubscriptionCount) throws UaException {
        BaseDataVariableTypeNode node = this.getCumulatedSubscriptionCountNode();
        node.setValue(new Variant((Object)cumulatedSubscriptionCount));
    }

    @Override
    public UInteger readCumulatedSubscriptionCount() throws UaException {
        try {
            return this.readCumulatedSubscriptionCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCumulatedSubscriptionCount(UInteger cumulatedSubscriptionCount) throws UaException {
        try {
            this.writeCumulatedSubscriptionCountAsync(cumulatedSubscriptionCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readCumulatedSubscriptionCountAsync() {
        return ((CompletableFuture)this.getCumulatedSubscriptionCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCumulatedSubscriptionCountAsync(UInteger cumulatedSubscriptionCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)cumulatedSubscriptionCount));
        return this.getCumulatedSubscriptionCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCumulatedSubscriptionCountNode() throws UaException {
        try {
            return this.getCumulatedSubscriptionCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCumulatedSubscriptionCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CumulatedSubscriptionCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getSecurityRejectedRequestsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getSecurityRejectedRequestsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecurityRejectedRequestsCount(UInteger securityRejectedRequestsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getSecurityRejectedRequestsCountNode();
        node.setValue(new Variant((Object)securityRejectedRequestsCount));
    }

    @Override
    public UInteger readSecurityRejectedRequestsCount() throws UaException {
        try {
            return this.readSecurityRejectedRequestsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecurityRejectedRequestsCount(UInteger securityRejectedRequestsCount) throws UaException {
        try {
            this.writeSecurityRejectedRequestsCountAsync(securityRejectedRequestsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readSecurityRejectedRequestsCountAsync() {
        return ((CompletableFuture)this.getSecurityRejectedRequestsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityRejectedRequestsCountAsync(UInteger securityRejectedRequestsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityRejectedRequestsCount));
        return this.getSecurityRejectedRequestsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSecurityRejectedRequestsCountNode() throws UaException {
        try {
            return this.getSecurityRejectedRequestsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSecurityRejectedRequestsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityRejectedRequestsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getRejectedRequestsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getRejectedRequestsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setRejectedRequestsCount(UInteger rejectedRequestsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getRejectedRequestsCountNode();
        node.setValue(new Variant((Object)rejectedRequestsCount));
    }

    @Override
    public UInteger readRejectedRequestsCount() throws UaException {
        try {
            return this.readRejectedRequestsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRejectedRequestsCount(UInteger rejectedRequestsCount) throws UaException {
        try {
            this.writeRejectedRequestsCountAsync(rejectedRequestsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readRejectedRequestsCountAsync() {
        return ((CompletableFuture)this.getRejectedRequestsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRejectedRequestsCountAsync(UInteger rejectedRequestsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)rejectedRequestsCount));
        return this.getRejectedRequestsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRejectedRequestsCountNode() throws UaException {
        try {
            return this.getRejectedRequestsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRejectedRequestsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RejectedRequestsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

