/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.validation;

import java.util.HashSet;
import java.util.OptionalDouble;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.Messages;
import org.eclipse.fordiac.ide.Utils;
import org.eclipse.fordiac.ide.contractSpec.Age;
import org.eclipse.fordiac.ide.contractSpec.CausalAge;
import org.eclipse.fordiac.ide.contractSpec.CausalFuncDecl;
import org.eclipse.fordiac.ide.contractSpec.CausalFuncName;
import org.eclipse.fordiac.ide.contractSpec.CausalReaction;
import org.eclipse.fordiac.ide.contractSpec.ClockDefinition;
import org.eclipse.fordiac.ide.contractSpec.ContractSpecPackage;
import org.eclipse.fordiac.ide.contractSpec.EventExpr;
import org.eclipse.fordiac.ide.contractSpec.EventList;
import org.eclipse.fordiac.ide.contractSpec.EventSpec;
import org.eclipse.fordiac.ide.contractSpec.Interval;
import org.eclipse.fordiac.ide.contractSpec.Model;
import org.eclipse.fordiac.ide.contractSpec.Port;
import org.eclipse.fordiac.ide.contractSpec.Reaction;
import org.eclipse.fordiac.ide.contractSpec.Repetition;
import org.eclipse.fordiac.ide.contractSpec.SingleEvent;
import org.eclipse.fordiac.ide.contractSpec.TimeSpec;
import org.eclipse.fordiac.ide.validation.AbstractContractSpecValidator;
import org.eclipse.xtext.validation.Check;

public class ContractSpecValidator
extends AbstractContractSpecValidator {
    private static final int INPUT = 1;
    private static final int OUTPUT = 0;
    public static final String EMPTY_INTERVAL = "emptyInterval";
    public static final String SPECIAL_EMPTY_INTERVAL = "specialEmptyInterval";
    public static final String DEGENERATE_INTERVAL = "degenerateInterval";
    public static final String PORT_NOT_INPUT = "portNotInput";
    public static final String PORT_NOT_OUTPUT = "portNotOutput";
    public static final String SLIDING_WINDOW_UNNEEDED = "slidingWindowUnneeded";
    public static final String SLIDING_WINDOW_INVALID = "slidingWindowInvalid";
    public static final String SET_EXPR_CONTAINS_DUPLICATES = "setExprContainsDuplicates";
    public static final String CLOCK_ALREADY_DEFINED = "clockAlreadyDefined";
    public static final String MAXDIFF_AND_SKEW = "maxdiffAndSkew";
    public static final String MAXDIFF_AND_DRIFT = "maxdiffAndDrift";
    public static final String SKEW_WITHOUT_RESOLUTION = "skewWithoutResolution";
    public static final String SKEW_LT_RESOLUTION = "skewLTResolution";

    @Check
    public void checkInterval(Interval interval) {
        if (interval.getTime() != null) {
            return;
        }
        if (interval.getLbValue() > interval.getUbValue()) {
            this.warning(Messages.EmptyIntervalWarning, (EStructuralFeature)ContractSpecPackage.Literals.INTERVAL__LB_VALUE, EMPTY_INTERVAL, new String[0]);
        } else if (interval.getLbValue() == interval.getUbValue()) {
            if (interval.getLBound().equals("]") || interval.getUBound().equals("[")) {
                this.warning(Messages.EmptyIntervalWarning, (EStructuralFeature)ContractSpecPackage.Literals.INTERVAL__LB_VALUE, SPECIAL_EMPTY_INTERVAL, new String[0]);
            } else {
                this.warning(Messages.DegenerateIntervalWarning, (EStructuralFeature)ContractSpecPackage.Literals.INTERVAL__LB_VALUE, DEGENERATE_INTERVAL, new String[0]);
            }
        }
    }

    @Check
    public void checkClocksUnique(Model model) {
        HashSet<String> clockNames = new HashSet<String>();
        for (TimeSpec timeSpec : model.getTimeSpec()) {
            ClockDefinition clock;
            if (!(timeSpec instanceof ClockDefinition) || clockNames.add((clock = (ClockDefinition)timeSpec).getName())) continue;
            this.error(Messages.ClockAlreadyDefinedError, clock, (EStructuralFeature)ContractSpecPackage.Literals.CLOCK_DEFINITION__NAME, CLOCK_ALREADY_DEFINED, new String[0]);
        }
    }

    @Check
    public void checkClock(ClockDefinition clock) {
        OptionalDouble skew;
        if (clock.getMaxdiff() != null && clock.getSkew() != null) {
            this.error(Messages.MaxdiffAndSkewError, (EStructuralFeature)ContractSpecPackage.Literals.CLOCK_DEFINITION__MAXDIFF, MAXDIFF_AND_SKEW, new String[0]);
        }
        if (clock.getMaxdiff() != null && clock.getDrift() != null) {
            this.error(Messages.MaxdiffAndDriftError, (EStructuralFeature)ContractSpecPackage.Literals.CLOCK_DEFINITION__MAXDIFF, MAXDIFF_AND_DRIFT, new String[0]);
        }
        if ((skew = Utils.timeExpr2Ns(clock.getSkew())).isPresent()) {
            OptionalDouble resolution = Utils.timeExpr2Ns(clock.getResolution());
            if (resolution.isEmpty()) {
                this.error(Messages.SkewWithoutResolutionError, (EStructuralFeature)ContractSpecPackage.Literals.CLOCK_DEFINITION__SKEW, SKEW_WITHOUT_RESOLUTION, new String[0]);
            } else if (skew.getAsDouble() >= resolution.getAsDouble()) {
                this.error(Messages.SkewLTResolutionError, (EStructuralFeature)ContractSpecPackage.Literals.CLOCK_DEFINITION__SKEW, SKEW_LT_RESOLUTION, new String[0]);
            }
        }
    }

    @Check
    public void checkSingleEvent(SingleEvent singleEvent) {
        this.checkPortsOfSameType(singleEvent.getEvents(), (EStructuralFeature)ContractSpecPackage.Literals.SINGLE_EVENT__EVENTS);
    }

    @Check
    public void checkRepetition(Repetition repetition) {
        this.checkPortsOfSameType(repetition.getEvents(), (EStructuralFeature)ContractSpecPackage.Literals.REPETITION__EVENTS);
    }

    @Check
    public void checkReaction(Reaction reaction) {
        this.checkPortsOfType(reaction.getInput(), 1, (EStructuralFeature)ContractSpecPackage.Literals.REACTION__INPUT);
        this.checkPortsOfType(reaction.getOutput(), 0, (EStructuralFeature)ContractSpecPackage.Literals.REACTION__OUTPUT);
        this.validateNOutOfM(reaction.getN(), reaction.getOutOf(), (EStructuralFeature)ContractSpecPackage.Literals.REACTION__N);
        this.validateSetNoDuplicates(reaction.getInput(), (EStructuralFeature)ContractSpecPackage.Literals.REACTION__INPUT);
        this.validateSetNoDuplicates(reaction.getOutput(), (EStructuralFeature)ContractSpecPackage.Literals.REACTION__OUTPUT);
    }

    @Check
    public void checkCausalReaction(CausalReaction causalReaction) {
        this.checkPortsOfType(causalReaction.getInput(), 1, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_REACTION__INPUT);
        this.checkPortsOfType(causalReaction.getOutput(), 0, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_REACTION__OUTPUT);
    }

    @Check
    public void checkAge(Age age) {
        this.checkPortsOfType(age.getOutput(), 0, (EStructuralFeature)ContractSpecPackage.Literals.AGE__OUTPUT);
        this.checkPortsOfType(age.getInput(), 1, (EStructuralFeature)ContractSpecPackage.Literals.AGE__INPUT);
        this.validateNOutOfM(age.getN(), age.getOutOf(), (EStructuralFeature)ContractSpecPackage.Literals.AGE__N);
        this.validateSetNoDuplicates(age.getOutput(), (EStructuralFeature)ContractSpecPackage.Literals.AGE__OUTPUT);
        this.validateSetNoDuplicates(age.getInput(), (EStructuralFeature)ContractSpecPackage.Literals.AGE__INPUT);
    }

    @Check
    public void checkCausalAge(CausalAge causalAge) {
        this.checkPortsOfType(causalAge.getOutput(), 0, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_AGE__OUTPUT);
        this.checkPortsOfType(causalAge.getInput(), 1, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_AGE__INPUT);
    }

    @Check
    public void checkCausalFuncDecl(CausalFuncDecl causalFuncDecl) {
        if (causalFuncDecl.getFuncName() == CausalFuncName.REACTION) {
            this.checkPortOfType(causalFuncDecl.getPort1(), 1, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_FUNC_DECL__PORT1);
            this.checkPortOfType(causalFuncDecl.getPort2(), 0, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_FUNC_DECL__PORT2);
        } else {
            this.checkPortOfType(causalFuncDecl.getPort1(), 0, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_FUNC_DECL__PORT1);
            this.checkPortOfType(causalFuncDecl.getPort2(), 1, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_FUNC_DECL__PORT2);
        }
    }

    private void checkPortsOfSameType(EventList list, EStructuralFeature feature) {
        if (list != null && list.getEvents() != null && !list.getEvents().isEmpty()) {
            int firstType = ((EventSpec)list.getEvents().get(0)).getPort().getIsInput();
            this.checkPortsOfType(list.getEvents(), firstType, feature);
        }
    }

    private void checkPortsOfType(EventExpr expr, int type, EStructuralFeature feature) {
        if (expr.getEvent() != null) {
            this.checkPortOfType(expr.getEvent().getPort(), type, feature);
        } else if (expr.getEvents() != null) {
            this.checkPortsOfType(expr.getEvents().getEvents(), type, feature);
        }
    }

    private void checkPortsOfType(EList<EventSpec> list, int type, EStructuralFeature feature) {
        if (list != null) {
            for (EventSpec es : list) {
                this.checkPortOfType(es.getPort(), type, feature);
            }
        }
    }

    private void checkPortsOfType(EventSpec es, int type, EStructuralFeature feature) {
        if (es != null) {
            this.checkPortOfType(es.getPort(), type, feature);
        }
    }

    private void checkPortOfType(Port port, int type, EStructuralFeature feature) {
        if (port != null && port.getIsInput() != type) {
            if (type == 1) {
                String s = String.format(Messages.InputPortExpectedError, port.getName());
                this.error(s, feature, PORT_NOT_INPUT, new String[0]);
            } else {
                String s = String.format(Messages.OutputPortExpectedError, port.getName());
                this.error(s, feature, PORT_NOT_OUTPUT, new String[0]);
            }
        }
    }

    private void validateNOutOfM(int n, int m, EStructuralFeature feature) {
        if (n == 0 && m == 0) {
            return;
        }
        if (n == m) {
            this.warning(Messages.SlidingWindowNotNeededWarning, feature, SLIDING_WINDOW_UNNEEDED, new String[0]);
        } else if (n > m) {
            this.error(Messages.SlidingWindowInvalidError, feature, SLIDING_WINDOW_INVALID, new String[0]);
        }
    }

    private void validateSetNoDuplicates(EventExpr expr, EStructuralFeature feature) {
        if (expr.getEvent() != null || expr.isSequence()) {
            return;
        }
        EList<EventSpec> list = expr.getEvents().getEvents();
        long c = list.stream().map(e -> e.getPort().getName()).distinct().count();
        if (c != (long)list.size()) {
            this.warning(Messages.SetExprContainsDuplicatesWarning, feature, SET_EXPR_CONTAINS_DUPLICATES, new String[0]);
        }
    }
}

